/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.packets.ICustomEntity;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_3532;
import net.minecraft.class_638;

public class SpawnEntityPacket
extends BasePacket {
    private int id;
    private UUID uuid;
    private double x;
    private double y;
    private double z;
    private int velocityX;
    private int velocityY;
    private int velocityZ;
    private int pitch;
    private int yaw;
    private class_1299<?> entityTypeId;
    private class_2540 extraData;

    public SpawnEntityPacket(class_2540 buf) {
        this.id = buf.method_10816();
        this.uuid = buf.method_10790();
        this.entityTypeId = (class_1299)class_2378.field_11145.method_10200(buf.method_10816());
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.pitch = buf.readByte();
        this.yaw = buf.readByte();
        this.velocityX = buf.readShort();
        this.velocityY = buf.readShort();
        this.velocityZ = buf.readShort();
        this.extraData = new class_2540(buf.copy());
    }

    public SpawnEntityPacket(int id, UUID uuid, double x, double y, double z, float pitch, float yaw, class_1299<?> entityTypeId, class_243 velocity, Consumer<class_2540> extraSpawnData) {
        this.id = id;
        this.uuid = uuid;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = class_3532.method_15375((float)(pitch * 256.0f / 360.0f));
        this.yaw = class_3532.method_15375((float)(yaw * 256.0f / 360.0f));
        this.entityTypeId = entityTypeId;
        this.velocityX = (int)(class_3532.method_15350((double)velocity.field_1352, (double)-3.9, (double)3.9) * 8000.0);
        this.velocityY = (int)(class_3532.method_15350((double)velocity.field_1351, (double)-3.9, (double)3.9) * 8000.0);
        this.velocityZ = (int)(class_3532.method_15350((double)velocity.field_1350, (double)-3.9, (double)3.9) * 8000.0);
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.method_10804(this.id);
        data.method_10797(this.uuid);
        data.method_10804(class_2378.field_11145.method_10206(this.entityTypeId));
        data.writeDouble(this.x);
        data.writeDouble(this.y);
        data.writeDouble(this.z);
        data.writeByte(this.pitch);
        data.writeByte(this.yaw);
        data.writeShort(this.velocityX);
        data.writeShort(this.velocityY);
        data.writeShort(this.velocityZ);
        extraSpawnData.accept(data);
        this.configureWrite(data);
    }

    public SpawnEntityPacket(class_1297 entity, Consumer<class_2540> extraSpawnData) {
        this(entity.method_5628(), entity.method_5667(), entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.field_5965, entity.field_6031, entity.method_5864(), entity.method_18798(), extraSpawnData);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientPacketData(INetworkInfo network, class_1657 player) {
        class_1299<?> entityType = this.entityTypeId;
        class_638 world = (class_638)player.field_6002;
        class_1297 entity = entityType.method_5883((class_1937)world);
        if (entity != null) {
            entity.method_18003(this.x, this.y, this.z);
            entity.method_5750((double)this.velocityX, (double)this.velocityY, (double)this.velocityZ);
            entity.method_24203(this.x, this.y, this.z);
            entity.field_5965 = (float)(this.pitch * 360) / 256.0f;
            entity.field_6031 = (float)(this.yaw * 360) / 256.0f;
            entity.method_5838(this.id);
            entity.method_5826(this.uuid);
            if (entity instanceof ICustomEntity) {
                ((ICustomEntity)entity).readAdditionalSpawnData(this.extraData);
            }
            world.method_2942(this.id, entity);
        }
    }

    public static <T extends class_1297> class_2596<?> create(T entity) {
        ICustomEntity customEntity = (ICustomEntity)entity;
        SpawnEntityPacket packet = new SpawnEntityPacket(entity, customEntity::writeAdditionalSpawnData);
        return packet.toPacket(class_2598.field_11942);
    }
}

