/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.AELog;
import appeng.core.worlddata.IWorldPlayerData;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_18;
import net.minecraft.class_2487;

final class PlayerData
extends class_18
implements IWorldPlayerData {
    public static final String NAME = "appliedenergistics2_players";
    public static final String TAG_PLAYER_IDS = "playerIds";
    public static final String TAG_PROFILE_IDS = "profileIds";
    private final BiMap<UUID, Integer> mapping = HashBiMap.create();
    private int nextPlayerId = 0;

    public PlayerData() {
        super(NAME);
    }

    @Override
    @Nullable
    public UUID getProfileId(int playerId) {
        return (UUID)this.mapping.inverse().get((Object)playerId);
    }

    @Override
    public int getMePlayerId(@Nonnull GameProfile profile) {
        Preconditions.checkNotNull((Object)profile);
        UUID uuid = profile.getId();
        Integer playerId = (Integer)this.mapping.get((Object)uuid);
        if (playerId == null) {
            playerId = this.nextPlayerId++;
            this.mapping.put((Object)profile.getId(), (Object)playerId);
            this.method_80();
            AELog.info("Assigning ME player id %s to Minecraft profile %s (%s)", playerId, profile.getId(), profile.getName());
        }
        return playerId;
    }

    public void method_77(class_2487 nbt) {
        long[] profileIds;
        int[] playerIds = nbt.method_10561(TAG_PLAYER_IDS);
        if (playerIds.length * 2 != (profileIds = nbt.method_10565(TAG_PROFILE_IDS)).length) {
            throw new IllegalStateException("Plaer ID mapping is corrupted. " + playerIds.length + " player IDs vs. " + profileIds.length + " profile IDs (latter must be 2 * the former)");
        }
        this.mapping.clear();
        int highestPlayerId = -1;
        for (int i = 0; i < playerIds.length; ++i) {
            int playerId = playerIds[i];
            UUID profileId = new UUID(profileIds[i * 2], profileIds[i * 2 + 1]);
            highestPlayerId = Math.max(playerId, highestPlayerId);
            this.mapping.put((Object)profileId, (Object)playerId);
            AELog.debug("AE player ID %s is assigned to profile ID %s", playerId, profileId);
        }
        this.nextPlayerId = highestPlayerId + 1;
    }

    public class_2487 method_75(class_2487 compound) {
        int index = 0;
        int[] playerIds = new int[this.mapping.size()];
        long[] profileIds = new long[this.mapping.size() * 2];
        for (Map.Entry entry : this.mapping.entrySet()) {
            profileIds[index * 2] = ((UUID)entry.getKey()).getMostSignificantBits();
            profileIds[index * 2 + 1] = ((UUID)entry.getKey()).getLeastSignificantBits();
            playerIds[index++] = (Integer)entry.getValue();
        }
        compound.method_10539(TAG_PLAYER_IDS, playerIds);
        compound.method_10564(TAG_PROFILE_IDS, profileIds);
        return compound;
    }
}

