/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.AELog;
import appeng.core.worlddata.IWorldGridStorageData;
import appeng.me.GridStorage;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

final class StorageData
extends class_18
implements IWorldGridStorageData {
    public static final String NAME = "appliedenergistics2_storage";
    private static final String TAG_NEXT_ID = "nextId";
    public static final String TAG_ORDERED_VALUES = "orderedValues";
    public static final String TAG_STORAGE = "storage";
    private final Map<Long, GridStorage> storage = new HashMap<Long, GridStorage>();
    private long nextGridId;
    private final Map<String, Integer> orderedValues = new HashMap<String, Integer>();

    public StorageData() {
        super(NAME);
    }

    @Override
    public GridStorage getGridStorage(long storageID) {
        GridStorage result = this.storage.get(storageID);
        if (result == null) {
            result = new GridStorage(storageID);
            this.storage.put(storageID, result);
        }
        return result;
    }

    @Override
    @Nonnull
    public GridStorage getNewGridStorage() {
        return this.getGridStorage(this.nextGridId++);
    }

    @Override
    public void destroyGridStorage(long id) {
        this.storage.remove(id);
    }

    @Override
    public int getNextOrderedValue(String name, int firstValue) {
        return this.orderedValues.merge(name, firstValue, (oldValue, value) -> oldValue + 1);
    }

    public void method_77(class_2487 tag) {
        this.nextGridId = tag.method_10537(TAG_NEXT_ID);
        class_2487 storageTag = tag.method_10562(TAG_STORAGE);
        for (String storageIdStr : storageTag.method_10541()) {
            long storageId;
            try {
                storageId = Long.parseLong(storageIdStr);
            }
            catch (NumberFormatException e) {
                AELog.warn("Unable to load grid storage with malformed id: '{}'", storageIdStr);
                continue;
            }
            this.storage.put(storageId, new GridStorage(storageId, storageTag.method_10562(storageIdStr)));
        }
        class_2487 orderedValuesTag = tag.method_10562(TAG_ORDERED_VALUES);
        this.orderedValues.clear();
        for (String key : orderedValuesTag.method_10541()) {
            this.orderedValues.put(key, orderedValuesTag.method_10550(key));
        }
    }

    public class_2487 method_75(class_2487 tag) {
        tag.method_10544(TAG_NEXT_ID, this.nextGridId);
        class_2487 storageTag = new class_2487();
        for (Map.Entry<Long, GridStorage> entry : this.storage.entrySet()) {
            GridStorage gridStorage = entry.getValue();
            if (gridStorage.getGrid() == null || gridStorage.getGrid().isEmpty()) continue;
            try {
                entry.getValue().saveState();
            }
            catch (Exception e) {
                AELog.warn("Failed to save state of Grid {}, storing last known value instead.", entry.getKey(), e);
            }
            storageTag.method_10566(String.valueOf(entry.getKey()), (class_2520)entry.getValue().dataObject());
        }
        tag.method_10566(TAG_STORAGE, (class_2520)storageTag);
        class_2487 orderedValuesTag = new class_2487();
        for (Map.Entry<String, Integer> entry : this.orderedValues.entrySet()) {
            orderedValuesTag.method_10569(entry.getKey(), entry.getValue().intValue());
        }
        tag.method_10566(TAG_ORDERED_VALUES, (class_2520)orderedValuesTag);
        return tag;
    }
}

