/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.worlddata.CompassData;
import appeng.core.worlddata.IWorldCompassData;
import appeng.core.worlddata.IWorldData;
import appeng.core.worlddata.IWorldGridStorageData;
import appeng.core.worlddata.IWorldPlayerData;
import appeng.core.worlddata.PlayerData;
import appeng.core.worlddata.StorageData;
import appeng.services.CompassService;
import appeng.services.compass.CompassThreadFactory;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public final class WorldData
implements IWorldData {
    @Nullable
    private static WorldData instance;
    @Nullable
    private static MinecraftServer server;
    private final IWorldPlayerData playerData;
    private final IWorldGridStorageData storageData;
    private final IWorldCompassData compassData;

    private WorldData(@Nonnull class_3218 overworld) {
        Preconditions.checkNotNull((Object)overworld);
        if (overworld.method_27983() != class_1937.field_25179) {
            throw new IllegalStateException("The server doesn't have an Overworld dimension we could store our data on!");
        }
        PlayerData playerData = (PlayerData)overworld.method_17983().method_17924(PlayerData::new, "appliedenergistics2_players");
        StorageData storageData = (StorageData)overworld.method_17983().method_17924(StorageData::new, "appliedenergistics2_storage");
        CompassThreadFactory compassThreadFactory = new CompassThreadFactory();
        CompassService compassService = new CompassService(server, compassThreadFactory);
        CompassData compassData = new CompassData(compassService);
        this.playerData = playerData;
        this.storageData = storageData;
        this.compassData = compassData;
    }

    @Deprecated
    @Nonnull
    public static synchronized IWorldData instance() {
        if (instance == null) {
            if (server == null) {
                throw new IllegalStateException("No server set.");
            }
            class_3218 overworld = server.method_30002();
            instance = new WorldData(overworld);
        }
        return instance;
    }

    public static void onServerStarting(MinecraftServer server) {
        WorldData.server = server;
    }

    public static void onServerStoppped(MinecraftServer server) {
        if (WorldData.server == server) {
            if (instance != null) {
                WorldData.instance.compassData.service().kill();
            }
            instance = null;
            WorldData.server = null;
        }
    }

    @Override
    @Nonnull
    public IWorldGridStorageData storageData() {
        return this.storageData;
    }

    @Override
    @Nonnull
    public IWorldPlayerData playerData() {
        return this.playerData;
    }

    @Override
    @Nonnull
    public IWorldCompassData compassData() {
        return this.compassData;
    }
}

