/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.hooks.AEToolItem;
import appeng.hooks.TickHandler;
import appeng.items.AEBaseItem;
import appeng.me.Grid;
import appeng.me.GridNode;
import appeng.me.cache.TickManagerCache;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.tile.networking.ControllerBlockEntity;
import java.util.HashSet;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;

public class DebugCardItem
extends AEBaseItem
implements AEToolItem {
    public DebugCardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        if (context.method_8045().method_8608()) {
            return class_1269.field_5811;
        }
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        if (player == null) {
            return class_1269.field_5811;
        }
        if (player.method_18276()) {
            int grids = 0;
            int totalNodes = 0;
            for (Grid g : TickHandler.instance().getGridList()) {
                ++grids;
                totalNodes += g.getNodes().size();
            }
            this.outputMsg((class_1297)player, "Grids: " + grids);
            this.outputMsg((class_1297)player, "Total Nodes: " + totalNodes);
        } else {
            class_2586 te = world.method_8321(pos);
            if (te instanceof IGridHost) {
                GridNode node = (GridNode)((IGridHost)te).getGridNode(AEPartLocation.fromFacing(side));
                if (node != null) {
                    Grid g = node.getInternalGrid();
                    IGridNode center = g.getPivot();
                    this.outputMsg((class_1297)player, "This Node: " + node.toString());
                    this.outputMsg((class_1297)player, "Center Node: " + center.toString());
                    IPathingGrid pg = (IPathingGrid)g.getCache(IPathingGrid.class);
                    if (pg.getControllerState() == ControllerState.CONTROLLER_ONLINE) {
                        HashSet<IGridNode> next = new HashSet<IGridNode>();
                        next.add(node);
                        int maxLength = 10000;
                        int length = 0;
                        block1: while (!next.isEmpty()) {
                            HashSet<IGridNode> current = next;
                            next = new HashSet();
                            for (IGridNode n : current) {
                                if (n.getMachine() instanceof ControllerBlockEntity) break block1;
                                for (IGridConnection c : n.getConnections()) {
                                    next.add(c.getOtherSide(n));
                                }
                            }
                            if (++length <= 10000) continue;
                            break;
                        }
                        this.outputMsg((class_1297)player, "Cable Distance: " + length);
                    }
                    if (center.getMachine() instanceof P2PTunnelPart) {
                        this.outputMsg((class_1297)player, "Freq: " + ((P2PTunnelPart)center.getMachine()).getFrequency());
                    }
                    TickManagerCache tmc = (TickManagerCache)g.getCache(ITickManager.class);
                    for (Class<? extends IGridHost> c : g.getMachineClasses()) {
                        int o = 0;
                        long nanos = 0L;
                        for (IGridNode oj : g.getMachines(c)) {
                            ++o;
                            nanos += tmc.getAvgNanoTime(oj);
                        }
                        if (nanos < 0L) {
                            this.outputMsg((class_1297)player, c.getSimpleName() + " - " + o);
                            continue;
                        }
                        this.outputMsg((class_1297)player, c.getSimpleName() + " - " + o + "; " + this.timeMeasurement(nanos));
                    }
                } else {
                    this.outputMsg((class_1297)player, "No Node Available.");
                }
            } else {
                this.outputMsg((class_1297)player, "Not Networked Block");
            }
            if (te instanceof IPartHost) {
                IPart center = ((IPartHost)te).getPart(AEPartLocation.INTERNAL);
                ((IPartHost)te).markForUpdate();
                if (center != null) {
                    GridNode n = (GridNode)center.getGridNode();
                    this.outputMsg((class_1297)player, "Node Channels: " + n.usedChannels());
                    for (IGridConnection gc : n.getConnections()) {
                        AEPartLocation fd = gc.getDirection(n);
                        if (fd == AEPartLocation.INTERNAL) continue;
                        this.outputMsg((class_1297)player, fd.toString() + ": " + gc.getUsedChannels());
                    }
                }
            }
            if (te instanceof IAEPowerStorage) {
                IGridNode node;
                IAEPowerStorage ps = (IAEPowerStorage)te;
                this.outputMsg((class_1297)player, "Energy: " + ps.getAECurrentPower() + " / " + ps.getAEMaxPower());
                if (te instanceof IGridHost && (node = ((IGridHost)te).getGridNode(AEPartLocation.fromFacing(side))) != null && node.getGrid() != null) {
                    IEnergyGrid eg = (IEnergyGrid)node.getGrid().getCache(IEnergyGrid.class);
                    this.outputMsg((class_1297)player, "GridEnergy: " + eg.getStoredPower() + " : " + eg.getEnergyDemand(Double.MAX_VALUE));
                }
            }
        }
        return class_1269.field_5812;
    }

    private void outputMsg(class_1297 player, String string) {
        player.method_9203((class_2561)new class_2585(string), class_156.field_25140);
    }

    private String timeMeasurement(long nanos) {
        long ms = nanos / 100000L;
        if (nanos <= 100000L) {
            return nanos + "ns";
        }
        return (float)ms / 10.0f + "ms";
    }
}

