/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;

public class ReplicatorCardItem
extends AEBaseItem
implements AEToolItem {
    public ReplicatorCardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.method_8608()) {
            class_2487 tag = user.method_5998(hand).method_7948();
            int replications = tag.method_10545("r") ? (tag.method_10550("r") + 1) % 4 : 0;
            tag.method_10569("r", replications);
            user.method_7353((class_2561)new class_2585(replications + 1 + "\u00b3 Replications"), true);
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        if (context.method_8045().method_8608()) {
            return class_1269.field_5812;
        }
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        class_1268 hand = context.method_20287();
        if (player == null) {
            return class_1269.field_5811;
        }
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        if (player.method_18276()) {
            if (world.method_8321(pos) instanceof IGridHost) {
                class_2487 tag = player.method_5998(hand).method_7948();
                tag.method_10569("x", x);
                tag.method_10569("y", y);
                tag.method_10569("z", z);
                tag.method_10569("side", side.ordinal());
                tag.method_10582("w", world.method_27983().method_29177().toString());
                tag.method_10569("r", 0);
                this.outputMsg((class_1297)player, "Set replicator source");
            } else {
                this.outputMsg((class_1297)player, "This is not a Grid Tile.");
            }
        } else {
            class_2487 ish = player.method_5998(hand).method_7969();
            if (ish != null) {
                int src_x = ish.method_10550("x");
                int src_y = ish.method_10550("y");
                int src_z = ish.method_10550("z");
                int src_side = ish.method_10550("side");
                String worldId = ish.method_10558("w");
                class_3218 src_w = world.method_8503().method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(worldId)));
                int replications = ish.method_10550("r") + 1;
                class_2586 te = src_w.method_8321(new class_2338(src_x, src_y, src_z));
                if (te instanceof IGridHost) {
                    IGridHost gh = (IGridHost)te;
                    class_2350 sideOff = class_2350.values()[src_side];
                    class_2350 currentSideOff = side;
                    IGridNode n = gh.getGridNode(AEPartLocation.fromFacing(sideOff));
                    if (n != null) {
                        IGrid g = n.getGrid();
                        if (g != null) {
                            ISpatialCache sc = (ISpatialCache)g.getCache(ISpatialCache.class);
                            if (sc.isValidRegion()) {
                                DimensionalCoord min = sc.getMin();
                                DimensionalCoord max = sc.getMax();
                                int sc_size_x = max.x - min.x;
                                int sc_size_y = max.y - min.y;
                                int sc_size_z = max.z - min.z;
                                int min_x = min.x;
                                int min_y = min.y;
                                int min_z = min.z;
                                int x_rot = (int)(-Math.signum(class_3532.method_15393((float)player.field_6031)));
                                int z_rot = (int)Math.signum(class_3532.method_15393((float)(player.field_6031 + 90.0f)));
                                for (int r_x = 0; r_x < replications; ++r_x) {
                                    for (int r_y = 0; r_y < replications; ++r_y) {
                                        for (int r_z = 0; r_z < replications; ++r_z) {
                                            int rel_x = min.x - src_x + x + r_x * sc_size_x * x_rot;
                                            int rel_y = min.y - src_y + y + r_y * sc_size_y;
                                            int rel_z = min.z - src_z + z + r_z * sc_size_z * z_rot;
                                            for (int i = 1; i < sc_size_x; ++i) {
                                                for (int j = 1; j < sc_size_y; ++j) {
                                                    for (int k = 1; k < sc_size_z; ++k) {
                                                        class_2338 p = new class_2338(min_x + i, min_y + j, min_z + k);
                                                        class_2338 d = new class_2338(i + rel_x, j + rel_y, k + rel_z);
                                                        class_2680 state = src_w.method_8320(p);
                                                        class_2248 blk = state.method_26204();
                                                        class_2680 prev = world.method_8320(d);
                                                        world.method_8501(d, state);
                                                        if (blk instanceof class_2343) {
                                                            class_2343 blkEntityProvider = (class_2343)blk;
                                                            class_2586 ote = src_w.method_8321(p);
                                                            class_2586 nte = blkEntityProvider.method_10123((class_1922)world);
                                                            class_2487 data = new class_2487();
                                                            ote.method_11007(data);
                                                            nte.method_11014(state, data.method_10553());
                                                            world.method_8526(d, nte);
                                                        }
                                                        world.method_8413(d, prev, state, 3);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            } else {
                                this.outputMsg((class_1297)player, "requires valid spatial pylon setup.");
                            }
                        } else {
                            this.outputMsg((class_1297)player, "no grid?");
                        }
                    } else {
                        this.outputMsg((class_1297)player, "No grid node?");
                    }
                } else {
                    this.outputMsg((class_1297)player, "Src is no longer a grid block?");
                }
            } else {
                this.outputMsg((class_1297)player, "No Source Defined");
            }
        }
        return class_1269.field_5812;
    }

    private void outputMsg(class_1297 player, String string) {
        player.method_9203((class_2561)new class_2585(string), class_156.field_25140);
    }
}

