/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.features.AEFeature;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.implementations.tiles.ICrystalGrowthAccelerator;
import appeng.client.EffectType;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.entity.AEBaseItemEntity;
import appeng.items.misc.CrystalSeedItem;
import appeng.mixins.ItemEntityAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class GrowingCrystalEntity
extends AEBaseItemEntity {
    public static class_1299<GrowingCrystalEntity> TYPE;
    private static final int[] GROWTH_TICK_PROGRESS;
    private int progress_1000 = 0;

    public GrowingCrystalEntity(class_1299<? extends GrowingCrystalEntity> type, class_1937 world) {
        super(type, world);
    }

    public GrowingCrystalEntity(class_1937 w, double x, double y, double z, class_1799 is) {
        super(TYPE, w, x, y, z, is);
    }

    public void method_5773() {
        ItemEntityAccessor accessor = (ItemEntityAccessor)((Object)this);
        if (!this.field_6002.field_9236 && accessor.getAge() >= 1000) {
            accessor.setAge(0);
        }
        super.method_5773();
        class_1799 is = this.method_6983();
        class_1792 gc = is.method_7909();
        if (!(gc instanceof IGrowableCrystal)) {
            return;
        }
        this.applyGrowthTick((IGrowableCrystal)gc, is);
    }

    private void applyGrowthTick(IGrowableCrystal cry, class_1799 is) {
        int z;
        int y;
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_PURIFICATION)) {
            return;
        }
        int x = class_3532.method_15357((double)this.method_23317());
        class_2338 pos = new class_2338(x, y = class_3532.method_15357((double)((this.method_5829().field_1322 + this.method_5829().field_1325) / 2.0)), z = class_3532.method_15357((double)this.method_23321()));
        class_2680 state = this.field_6002.method_8320(pos);
        float multiplier = cry.getMultiplier(state, this.field_6002, pos);
        if (multiplier <= 0.0f) {
            this.progress_1000 = 0;
            return;
        }
        int progressPerTick = (int)Math.max(1.0f, (float)this.getSpeed(pos) * multiplier);
        if (this.field_6002.method_8608()) {
            int len = GrowingCrystalEntity.getTicksBetweenParticleEffects(progressPerTick);
            if (++this.progress_1000 >= len) {
                this.progress_1000 = 0;
                AppEng.instance().spawnEffect(EffectType.Vibrant, this.field_6002, this.method_23317(), this.method_23318() + 0.2, this.method_23321(), null);
            }
        } else {
            this.progress_1000 += progressPerTick;
            if (this.progress_1000 >= 1000) {
                class_1799 newItem = is.method_7972();
                do {
                    newItem = cry.triggerGrowth(newItem);
                    this.progress_1000 -= 1000;
                } while (this.progress_1000 >= 1000 && newItem.method_7909() == is.method_7909());
                this.method_6979(newItem);
            }
        }
    }

    private static int getTicksBetweenParticleEffects(int progressPerTick) {
        if (progressPerTick > 500) {
            return 1;
        }
        if (progressPerTick > 360) {
            return 3;
        }
        if (progressPerTick > 240) {
            return 7;
        }
        if (progressPerTick > 150) {
            return 10;
        }
        if (progressPerTick > 90) {
            return 15;
        }
        if (progressPerTick > 2) {
            return 20;
        }
        return 40;
    }

    private int getSpeed(class_2338 pos) {
        int acceleratorCount = this.getAcceleratorCount(pos);
        if (acceleratorCount < 0) {
            return GROWTH_TICK_PROGRESS[0];
        }
        if (acceleratorCount >= GROWTH_TICK_PROGRESS.length) {
            return GROWTH_TICK_PROGRESS[GROWTH_TICK_PROGRESS.length - 1];
        }
        return GROWTH_TICK_PROGRESS[acceleratorCount];
    }

    private int getAcceleratorCount(class_2338 pos) {
        int count = 0;
        class_2338.class_2339 testPos = new class_2338.class_2339();
        for (class_2350 direction : class_2350.values()) {
            if (!this.isPoweredAccelerator((class_2338)testPos.method_25505((class_2382)pos, direction))) continue;
            ++count;
        }
        return count;
    }

    private boolean isPoweredAccelerator(class_2338 pos) {
        class_2586 te = this.field_6002.method_8321(pos);
        return te instanceof ICrystalGrowthAccelerator && ((ICrystalGrowthAccelerator)te).isPowered();
    }

    public void method_6974() {
        class_1799 item = this.method_6983();
        if (item.method_7909() instanceof CrystalSeedItem) {
            class_243 v = this.method_18798();
            double yAccel = this.method_5740() ? 0.0 : -0.002;
            this.method_18800(v.field_1352 * 0.99, v.field_1351 + yAccel, v.field_1350 * 0.99);
            return;
        }
        super.method_6974();
    }

    static {
        GROWTH_TICK_PROGRESS = new int[]{1, 40, 92, 159, 247, 361, 509};
    }
}

