/*
 * Decompiled with CFR 0.152.
 */
package appeng.facade;

import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.core.Api;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.items.parts.FacadeItem;
import appeng.parts.CableBusStorage;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class FacadeContainer
implements IFacadeContainer {
    private final int facades = 6;
    private final CableBusStorage storage;
    private final Runnable changeCallback;

    public FacadeContainer(CableBusStorage cbs, Runnable changeCallback) {
        this.storage = cbs;
        this.changeCallback = changeCallback;
    }

    @Override
    public boolean addFacade(IFacadePart a) {
        if (this.getFacade(a.getSide()) == null) {
            this.storage.setFacade(a.getSide().ordinal(), a);
            this.notifyChange();
            return true;
        }
        return false;
    }

    @Override
    public void removeFacade(IPartHost host, AEPartLocation side) {
        if (side != null && side != AEPartLocation.INTERNAL && this.storage.getFacade(side.ordinal()) != null) {
            this.storage.setFacade(side.ordinal(), null);
            this.notifyChange();
            if (host != null) {
                host.markForUpdate();
            }
        }
    }

    @Override
    public IFacadePart getFacade(AEPartLocation s) {
        return this.storage.getFacade(s.ordinal());
    }

    @Override
    public void rotateLeft() {
        FacadePart[] newFacades = new FacadePart[6];
        newFacades[AEPartLocation.UP.ordinal()] = this.storage.getFacade(AEPartLocation.UP.ordinal());
        newFacades[AEPartLocation.DOWN.ordinal()] = this.storage.getFacade(AEPartLocation.DOWN.ordinal());
        newFacades[AEPartLocation.EAST.ordinal()] = this.storage.getFacade(AEPartLocation.NORTH.ordinal());
        newFacades[AEPartLocation.SOUTH.ordinal()] = this.storage.getFacade(AEPartLocation.EAST.ordinal());
        newFacades[AEPartLocation.WEST.ordinal()] = this.storage.getFacade(AEPartLocation.SOUTH.ordinal());
        newFacades[AEPartLocation.NORTH.ordinal()] = this.storage.getFacade(AEPartLocation.WEST.ordinal());
        for (int x = 0; x < this.facades; ++x) {
            this.storage.setFacade(x, newFacades[x]);
        }
        this.notifyChange();
    }

    @Override
    public void writeToNBT(class_2487 c) {
        for (int x = 0; x < this.facades; ++x) {
            if (this.storage.getFacade(x) == null) continue;
            class_2487 data = new class_2487();
            this.storage.getFacade(x).getItemStack().method_7953(data);
            c.method_10566("facade:" + x, (class_2520)data);
        }
    }

    @Override
    public boolean readFromStream(class_2540 out) throws IOException {
        byte facadeSides = out.readByte();
        boolean changed = false;
        for (int x = 0; x < this.facades; ++x) {
            AEPartLocation side = AEPartLocation.fromOrdinal(x);
            int ix = 1 << x;
            if ((facadeSides & ix) == ix) {
                FacadeItem ifa;
                class_1799 facade;
                int id = Math.abs(out.readInt());
                Optional<class_1792> maybeFacadeItem = Api.instance().definitions().items().facade().maybeItem();
                if (!maybeFacadeItem.isPresent() || (facade = (ifa = (FacadeItem)maybeFacadeItem.get()).createFromID(id)) == null) continue;
                changed = changed || this.storage.getFacade(x) == null;
                this.storage.setFacade(x, ifa.createPartFromItemStack(facade, side));
                continue;
            }
            changed = changed || this.storage.getFacade(x) != null;
            this.storage.setFacade(x, null);
        }
        return changed;
    }

    @Override
    public void readFromNBT(class_2487 c) {
        for (int x = 0; x < this.facades; ++x) {
            class_1792 i;
            class_1799 is;
            this.storage.setFacade(x, null);
            class_2487 t = c.method_10562("facade:" + x);
            if (t == null || (is = class_1799.method_7915((class_2487)t)).method_7960() || !((i = is.method_7909()) instanceof IFacadeItem)) continue;
            this.storage.setFacade(x, ((IFacadeItem)i).createPartFromItemStack(is, AEPartLocation.fromOrdinal(x)));
        }
    }

    @Override
    public void writeToStream(class_2540 out) throws IOException {
        int x;
        int facadeSides = 0;
        for (x = 0; x < this.facades; ++x) {
            if (this.getFacade(AEPartLocation.fromOrdinal(x)) == null) continue;
            facadeSides |= 1 << x;
        }
        out.writeByte((int)((byte)facadeSides));
        for (x = 0; x < this.facades; ++x) {
            IFacadePart part = this.getFacade(AEPartLocation.fromOrdinal(x));
            if (part == null) continue;
            int itemID = class_1792.method_7880((class_1792)part.getItem());
            out.writeInt(itemID * (part.notAEFacade() ? -1 : 1));
        }
    }

    @Override
    public boolean isEmpty() {
        for (int x = 0; x < this.facades; ++x) {
            if (this.storage.getFacade(x) == null) continue;
            return false;
        }
        return true;
    }

    private void notifyChange() {
        this.changeCallback.run();
    }
}

