/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.TabButton;
import appeng.container.implementations.PriorityContainer;
import appeng.container.slot.IOptionalSlotHost;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.fluids.client.gui.widgets.FluidSlotWidget;
import appeng.fluids.client.gui.widgets.OptionalFluidSlotWidget;
import appeng.fluids.container.FluidStorageBusContainer;
import appeng.fluids.util.IAEFluidTank;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4587;

public class FluidStorageBusScreen
extends UpgradeableScreen<FluidStorageBusContainer> {
    private SettingToggleButton<AccessRestriction> rwMode;
    private SettingToggleButton<StorageFilter> storageFilter;

    public FluidStorageBusScreen(FluidStorageBusContainer container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        this.field_2779 = 251;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        int xo = 8;
        int yo = 29;
        IAEFluidTank config = ((FluidStorageBusContainer)this.field_2797).getFluidConfigInventory();
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 9; ++x) {
                int idx = y * 9 + x;
                if (y < 2) {
                    this.guiSlots.add(new FluidSlotWidget(config, idx, idx, 8 + x * 18, 29 + y * 18));
                    continue;
                }
                this.guiSlots.add(new OptionalFluidSlotWidget(config, (IOptionalSlotHost)this.field_2797, idx, idx, y - 2, 8, 29, x, y));
            }
        }
    }

    @Override
    protected void addButtons() {
        this.method_25411((class_339)new ActionButton(this.field_2776 - 18, this.field_2800 + 8, ActionItems.CLOSE, btn -> this.clear()));
        this.method_25411((class_339)new ActionButton(this.field_2776 - 18, this.field_2800 + 28, ActionItems.WRENCH, btn -> this.partition()));
        this.rwMode = new ServerSettingToggleButton<AccessRestriction>(this.field_2776 - 18, this.field_2800 + 48, Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.storageFilter = new ServerSettingToggleButton<StorageFilter>(this.field_2776 - 18, this.field_2800 + 68, Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(this.field_2776 - 18, this.field_2800 + 88, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.method_25411(this.method_25411((class_339)new TabButton(this.field_2776 + 154, this.field_2800, 66, GuiText.Priority.text(), this.field_22788, btn -> this.openPriorityGui())));
        this.method_25411((class_339)this.storageFilter);
        this.method_25411((class_339)this.fuzzyMode);
        this.method_25411((class_339)this.rwMode);
    }

    @Override
    public void drawFG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_22793.method_30883(matrices, this.getGuiDisplayName(this.getName().text()), 8.0f, 6.0f, 0x404040);
        this.field_22793.method_30883(matrices, GuiText.inventory.text(), 8.0f, (float)(this.field_2779 - 96 + 3), 0x404040);
        if (this.fuzzyMode != null) {
            this.fuzzyMode.set(this.cvb.getFuzzyMode());
        }
        if (this.storageFilter != null) {
            this.storageFilter.set(((FluidStorageBusContainer)this.cvb).getStorageFilter());
        }
        if (this.rwMode != null) {
            this.rwMode.set(((FluidStorageBusContainer)this.cvb).getReadWriteMode());
        }
    }

    @Override
    protected String getBackground() {
        return "guis/storagebus.png";
    }

    private void partition() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("StorageBus.Action", "Partition"));
    }

    private void clear() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("StorageBus.Action", "Clear"));
    }

    private void openPriorityGui() {
        NetworkHandler.instance().sendToServer(new SwitchGuisPacket(PriorityContainer.TYPE));
    }

    @Override
    protected GuiText getName() {
        return GuiText.StorageBusFluids;
    }
}

