/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.IConfigManager;
import appeng.client.ActionKey;
import appeng.client.gui.AEBaseMEScreen;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.me.FluidRepo;
import appeng.client.me.InternalFluidSlotME;
import appeng.client.me.SlotFluidME;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.fluids.container.FluidTerminalContainer;
import appeng.fluids.container.slots.IMEFluidSlot;
import appeng.helpers.InventoryAction;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import me.shedaniel.math.Rectangle;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_4587;

public class FluidTerminalScreen
extends AEBaseMEScreen<FluidTerminalContainer>
implements ISortSource,
IConfigManagerHost {
    private final List<SlotFluidME> meFluidSlots = new LinkedList<SlotFluidME>();
    private final FluidRepo repo;
    private final IConfigManager configSrc;
    private static final int GRID_OFFSET_X = 9;
    private static final int GRID_OFFSET_Y = 18;
    private static final int ROWS = 6;
    private static final int COLS = 9;
    private AETextField searchField;
    private SettingToggleButton<SortOrder> sortByBox;
    private SettingToggleButton<SortDir> sortDirBox;

    public FluidTerminalScreen(FluidTerminalContainer container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        this.field_2792 = 185;
        this.field_2779 = 222;
        Scrollbar scrollbar = new Scrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new FluidRepo(scrollbar, this);
        this.configSrc = container.getConfigManager();
        ((FluidTerminalContainer)this.field_2797).setGui(this);
    }

    @Override
    public void method_25426() {
        this.field_2776 = (this.field_22789 - this.field_2792) / 2;
        this.field_2800 = (this.field_22790 - this.field_2779) / 2;
        this.searchField = new AETextField(this.field_22793, this.field_2776 + 80, this.field_2800 + 4, 90, 12);
        this.searchField.method_1858(false);
        this.searchField.method_1880(25);
        this.searchField.method_1868(0xFFFFFF);
        this.searchField.setSelectionColor(-6684775);
        this.searchField.method_1862(true);
        int offset = this.field_2800;
        this.sortByBox = (SettingToggleButton)this.method_25411((class_339)new SettingToggleButton<SortOrder>(this.field_2776 - 18, offset, Settings.SORT_BY, this.getSortBy(), Platform::isSortOrderAvailable, this::toggleServerSetting));
        this.sortDirBox = (SettingToggleButton)this.method_25411((class_339)new SettingToggleButton<SortDir>(this.field_2776 - 18, offset += 20, Settings.SORT_DIRECTION, this.getSortDir(), this::toggleServerSetting));
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 9; ++x) {
                SlotFluidME slot = new SlotFluidME(new InternalFluidSlotME(this.repo, x + y * 9, 9 + x * 18, 18 + y * 18));
                this.getMeFluidSlots().add(slot);
                ((FluidTerminalContainer)this.field_2797).field_7761.add(slot);
            }
        }
        this.setScrollBar();
    }

    @Override
    public void drawFG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_22793.method_30883(matrices, this.getGuiDisplayName((class_2561)new class_2585(GuiText.FluidTerminal.getLocal())), 8.0f, 6.0f, 0x404040);
        this.field_22793.method_30883(matrices, GuiText.inventory.text(), 8.0f, (float)(this.field_2779 - 96 + 3), 0x404040);
    }

    @Override
    public void drawBG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture(this.getBackground());
        int x_width = 197;
        this.method_25302(matrices, offsetX, offsetY, 0, 0, 197, 18);
        for (int x = 0; x < 6; ++x) {
            this.method_25302(matrices, offsetX, offsetY + 18 + x * 18, 0, 18, 197, 18);
        }
        this.method_25302(matrices, offsetX, offsetY + 16 + 108, 0, 70, 197, 176);
        if (this.searchField != null) {
            this.searchField.method_25394(matrices, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void method_25393() {
        this.repo.setPower(((FluidTerminalContainer)this.field_2797).isPowered());
        super.method_25393();
    }

    protected void method_2380(class_4587 matrices, int mouseX, int mouseY) {
        IMEFluidSlot fluidSlot;
        class_1735 slot = this.getSlot(mouseX, mouseY);
        if (slot instanceof IMEFluidSlot && slot.method_7682() && (fluidSlot = (IMEFluidSlot)slot).getAEFluidStack() != null && fluidSlot.shouldRenderAsFluid()) {
            IAEFluidStack fluidStack = fluidSlot.getAEFluidStack();
            String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format((double)fluidStack.getStackSize() / 1000.0) + " B";
            String modName = Platform.getModName(Platform.getModId(fluidStack));
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(fluidStack.getFluidStack().getName());
            list.add(new class_2585(formattedAmount));
            list.add(new class_2585(modName));
            this.method_30901(matrices, list, mouseX, mouseY);
            return;
        }
        super.method_2380(matrices, mouseX, mouseY);
    }

    private <S extends Enum<S>> void toggleServerSetting(SettingToggleButton<S> btn, boolean backwards) {
        S next = btn.getNextValue(backwards);
        NetworkHandler.instance().sendToServer(new ConfigValuePacket(btn.getSetting().name(), ((Enum)next).name()));
        btn.set(next);
    }

    @Override
    protected void method_2383(class_1735 slot, int slotIdx, int mouseButton, class_1713 clickType) {
        if (slot instanceof SlotFluidME) {
            SlotFluidME meSlot = (SlotFluidME)slot;
            if (clickType == class_1713.field_7790) {
                if (mouseButton == 0 && meSlot.method_7681()) {
                    ((FluidTerminalContainer)this.field_2797).setTargetStack(meSlot.getAEFluidStack());
                    AELog.debug("mouse0 GUI STACK SIZE %s", meSlot.getAEFluidStack().getStackSize());
                    NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.FILL_ITEM, slot.field_7874, 0L));
                } else {
                    ((FluidTerminalContainer)this.field_2797).setTargetStack(meSlot.getAEFluidStack());
                    if (meSlot.getAEFluidStack() != null) {
                        AELog.debug("mouse1 GUI STACK SIZE %s", meSlot.getAEFluidStack().getStackSize());
                    }
                    NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.EMPTY_ITEM, slot.field_7874, 0L));
                }
            }
            return;
        }
        super.method_2383(slot, slotIdx, mouseButton, clickType);
    }

    public boolean method_25400(char character, int p_charTyped_2_) {
        if (character == ' ' && this.searchField.method_1882().isEmpty()) {
            return true;
        }
        if (this.searchField.method_25370() && this.searchField.method_25400(character, p_charTyped_2_)) {
            this.repo.setSearchString(this.searchField.method_1882());
            this.repo.updateView();
            this.setScrollBar();
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (keyCode != 256 && !this.checkHotbarKeys(keyCode, scanCode)) {
            if (AppEng.instance().isActionKey(ActionKey.TOGGLE_FOCUS, keyCode, scanCode)) {
                this.searchField.method_25365(!this.searchField.method_25370());
                return true;
            }
            if (this.searchField.method_25370()) {
                if (keyCode == 257) {
                    this.searchField.method_25365(false);
                    return true;
                }
                if (this.searchField.method_25404(keyCode, scanCode, p_keyPressed_3_)) {
                    this.repo.setSearchString(this.searchField.method_1882());
                    this.repo.updateView();
                    this.setScrollBar();
                }
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, p_keyPressed_3_);
    }

    @Override
    public boolean method_25402(double xCoord, double yCoord, int btn) {
        if (this.searchField.method_25402(xCoord, yCoord, btn)) {
            return true;
        }
        if (this.searchField.method_25405(xCoord, yCoord) && btn == 1) {
            this.searchField.method_1852("");
            this.repo.setSearchString("");
            this.repo.updateView();
            this.setScrollBar();
            return true;
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    public void postUpdate(List<IAEFluidStack> list) {
        for (IAEFluidStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        this.getScrollBar().setTop(18).setLeft(175).setHeight(106);
        this.getScrollBar().setRange(0, (this.repo.size() + 9 - 1) / 9 - 6, 1);
    }

    @Override
    public SortOrder getSortBy() {
        return (SortOrder)this.configSrc.getSetting(Settings.SORT_BY);
    }

    @Override
    public SortDir getSortDir() {
        return (SortDir)this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    @Override
    public ViewItems getSortDisplay() {
        return (ViewItems)this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        if (this.sortByBox != null) {
            this.sortByBox.set(this.getSortBy());
        }
        if (this.sortDirBox != null) {
            this.sortDirBox.set(this.getSortDir());
        }
        this.repo.updateView();
    }

    protected List<SlotFluidME> getMeFluidSlots() {
        return this.meFluidSlots;
    }

    @Override
    protected boolean isPowered() {
        return this.repo.hasPower();
    }

    protected String getBackground() {
        return "guis/terminal.png";
    }

    @Override
    public List<Rectangle> getExclusionZones() {
        List<Rectangle> zones = super.getExclusionZones();
        zones.add(new Rectangle(this.field_2776 - 18, this.field_2800, 18, 40));
        return zones;
    }
}

