/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui.widgets;

import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.widgets.CustomSlotWidget;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.FluidSlotPacket;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidTank;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;

public class FluidSlotWidget
extends CustomSlotWidget {
    private final IAEFluidTank fluids;
    private final int slot;

    public FluidSlotWidget(IAEFluidTank fluids, int slot, int id, int x, int y) {
        super(id, x, y);
        this.fluids = fluids;
        this.slot = slot;
    }

    @Override
    public void drawContent(class_310 mc, int mouseX, int mouseY, float partialTicks) {
        IAEFluidStack fs = this.getFluidStack();
        if (fs != null) {
            int x = this.getTooltipAreaX();
            int y = this.getTooltipAreaY();
            int width = this.getTooltipAreaWidth();
            int height = this.getTooltipAreaHeight();
            fs.getFluidStack().renderGuiRect((double)x, (double)y, (double)(x + width), (double)(y + height));
        }
    }

    @Override
    public boolean canClick(class_1657 player) {
        class_1799 mouseStack = player.field_7514.method_7399();
        return mouseStack.method_7960() || FluidAttributes.EXTRACTABLE.getFirstOrNull(mouseStack) != null;
    }

    @Override
    public void slotClicked(class_1799 clickStack, int mouseButton) {
        GroupedFluidInvView groupView;
        Set fluids;
        if (clickStack.method_7960() || mouseButton == 1) {
            this.setFluidStack(null);
        } else if (mouseButton == 0 && !(fluids = (groupView = (GroupedFluidInvView)FluidAttributes.GROUPED_INV_VIEW.get(clickStack)).getStoredFluids()).isEmpty()) {
            FluidKey firstFluid = (FluidKey)groupView.getStoredFluids().iterator().next();
            FluidVolume volume = firstFluid.withAmount(groupView.getAmount_F(firstFluid));
            this.setFluidStack(AEFluidStack.fromFluidVolume(volume, RoundingMode.DOWN));
        }
    }

    @Override
    public class_2561 getTooltipMessage() {
        IAEFluidStack fluid = this.getFluidStack();
        if (fluid != null) {
            return fluid.getFluidStack().getName();
        }
        return class_2585.field_24366;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return true;
    }

    public IAEFluidStack getFluidStack() {
        return this.fluids.getFluidInSlot(this.slot);
    }

    public void setFluidStack(IAEFluidStack stack) {
        this.fluids.setFluidInSlot(this.slot, stack);
        NetworkHandler.instance().sendToServer(new FluidSlotPacket(Collections.singletonMap(this.getId(), this.getFluidStack())));
    }
}

