/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui.widgets;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEColor;
import appeng.client.gui.widgets.ITooltip;
import appeng.fluids.util.IAEFluidTank;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class FluidTankWidget
extends class_339
implements ITooltip {
    private final IAEFluidTank tank;
    private final int slot;

    public FluidTankWidget(IAEFluidTank tank, int slot, int x, int y, int w, int h) {
        super(x, y, w, h, class_2585.field_24366);
        this.tank = tank;
        this.slot = slot;
    }

    public void method_25359(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22764) {
            FluidTankWidget.method_25294((class_4587)matrices, (int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759), (int)(AEColor.GRAY.blackVariant | 0xFF000000));
            IAEFluidStack fluidStack = this.tank.getFluidInSlot(this.slot);
            if (fluidStack != null && fluidStack.getStackSize() > 0L) {
                FluidVolume volume = fluidStack.getFluidStack();
                FluidAmount maxAmount = this.tank.getMaxAmount_F(this.slot);
                double fillRatio = volume.amount().div(maxAmount).asInexactDouble();
                int scaledHeight = (int)((double)this.field_22759 * fillRatio);
                int iconHeightRemainder = scaledHeight % 16;
                int top = this.field_22761 + this.field_22759 - iconHeightRemainder;
                if (iconHeightRemainder > 0) {
                    int x1 = this.field_22760;
                    int y1 = top;
                    int x2 = x1 + 16;
                    int y2 = y1 + iconHeightRemainder;
                    volume.renderGuiRect((double)x1, (double)y1, (double)x2, (double)y2);
                }
                for (int i = 0; i < scaledHeight / 16; ++i) {
                    int x1 = this.field_22760;
                    int y1 = top - (i + 1) * 16;
                    int x2 = x1 + 16;
                    int y2 = y1 + 16;
                    volume.renderGuiRect((double)x1, (double)y1, (double)x2, (double)y2);
                }
            }
        }
    }

    @Override
    public class_2561 getTooltipMessage() {
        IAEFluidStack fluid = this.tank.getFluidInSlot(this.slot);
        if (fluid != null && fluid.getStackSize() > 0L) {
            class_2561 desc = fluid.getFluidStack().getName();
            String amountToText = fluid.getStackSize() + "mB";
            return desc.method_27662().method_27693("\n").method_27693(amountToText);
        }
        return class_2585.field_24366;
    }

    @Override
    public int getTooltipAreaX() {
        return this.field_22760 - 2;
    }

    @Override
    public int getTooltipAreaY() {
        return this.field_22761 - 2;
    }

    @Override
    public int getTooltipAreaWidth() {
        return this.field_22758 + 4;
    }

    @Override
    public int getTooltipAreaHeight() {
        return this.field_22759 + 4;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return true;
    }
}

