/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.render;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.render.StackSizeRenderer;
import appeng.core.AEConfig;
import appeng.util.ISlimReadableNumberConverter;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.ReadableNumberConverter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_327;

public class FluidStackSizeRenderer {
    private static final String[] NUMBER_FORMATS = new String[]{"#.000", "#.00", "#.0", "#"};
    private static final ISlimReadableNumberConverter SLIM_CONVERTER = ReadableNumberConverter.INSTANCE;
    private static final IWideReadableNumberConverter WIDE_CONVERTER = ReadableNumberConverter.INSTANCE;

    public void renderStackSize(class_327 fontRenderer, IAEFluidStack aeStack, int xPos, int yPos) {
        if (aeStack != null && aeStack.getStackSize() > 0L) {
            class_2561 stackSize = this.getToBeRenderedStackSize(aeStack.getStackSize());
            StackSizeRenderer.renderSizeLabel(fontRenderer, xPos, yPos, stackSize);
        }
    }

    private class_2561 getToBeRenderedStackSize(long originalSize) {
        if (originalSize < 100000L && AEConfig.instance().isUseLargeFonts()) {
            return this.getSlimRenderedStacksize(originalSize);
        }
        if (originalSize < 1000000L && !AEConfig.instance().isUseLargeFonts()) {
            return this.getWideRenderedStacksize(originalSize);
        }
        if (AEConfig.instance().isUseLargeFonts()) {
            return new class_2585(SLIM_CONVERTER.toSlimReadableForm(originalSize / 1000L));
        }
        return new class_2585(WIDE_CONVERTER.toWideReadableForm(originalSize / 1000L));
    }

    private class_2561 getSlimRenderedStacksize(long originalSize) {
        int log = 1 + (int)Math.floor(Math.log10(originalSize)) / 2;
        return this.getRenderedFluidStackSize(originalSize, log);
    }

    private class_2561 getWideRenderedStacksize(long originalSize) {
        int log = (int)Math.floor(Math.log10(originalSize)) / 2;
        return this.getRenderedFluidStackSize(originalSize, log);
    }

    private class_2561 getRenderedFluidStackSize(long originalSize, int log) {
        int index = Math.max(0, Math.min(3, log));
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat(NUMBER_FORMATS[index]);
        format.setDecimalFormatSymbols(symbols);
        format.setRoundingMode(RoundingMode.DOWN);
        return new class_2585(format.format((double)originalSize / 1000.0));
    }
}

