/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.container.implementations.UpgradeableContainer;
import appeng.fluids.container.IFluidSyncContainer;
import appeng.fluids.helper.FluidSyncHelper;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidTank;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Map;
import net.minecraft.class_1661;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_3917;

public abstract class FluidConfigurableContainer
extends UpgradeableContainer
implements IFluidSyncContainer {
    private FluidSyncHelper sync = null;

    public FluidConfigurableContainer(class_3917<?> containerType, int id, class_1661 ip, IUpgradeableHost te) {
        super(containerType, id, ip, te);
    }

    public abstract IAEFluidTank getFluidConfigInventory();

    private FluidSyncHelper getSyncHelper() {
        if (this.sync == null) {
            this.sync = new FluidSyncHelper(this.getFluidConfigInventory(), 0);
        }
        return this.sync;
    }

    @Override
    protected class_1799 transferStackToContainer(class_1799 input) {
        FluidVolume fluid = ((FluidExtractable)FluidAttributes.EXTRACTABLE.get(input)).attemptAnyExtraction(FluidAmount.MAX_VALUE, Simulation.ACTION);
        if (!fluid.isEmpty()) {
            IAEFluidTank t = this.getFluidConfigInventory();
            AEFluidStack stack = AEFluidStack.fromFluidVolume(fluid, RoundingMode.DOWN);
            for (int i = 0; i < t.getSlots(); ++i) {
                if (t.getFluidInSlot(i) != null || !this.isValidForConfig(i, stack)) continue;
                t.setFluidInSlot(i, stack);
                break;
            }
        }
        return input;
    }

    protected boolean isValidForConfig(int slot, IAEFluidStack fs) {
        if (this.supportCapacity()) {
            int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
            if (slot > 0 && upgrades < 1) {
                return false;
            }
            if (slot > 4 && upgrades < 2) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void standardDetectAndSendChanges() {
        if (this.isServer()) {
            this.getSyncHelper().sendDiff(this.getListeners());
            IAEFluidTank t = this.getFluidConfigInventory();
            for (int i = 0; i < t.getSlots(); ++i) {
                if (t.getFluidInSlot(i) == null || this.isValidForConfig(i, t.getFluidInSlot(i))) continue;
                t.setFluidInSlot(i, null);
            }
        }
        super.standardDetectAndSendChanges();
    }

    public void method_7596(class_1712 listener) {
        super.method_7596(listener);
        this.getSyncHelper().sendFull(Collections.singleton(listener));
    }

    @Override
    public void receiveFluidSlots(Map<Integer, IAEFluidStack> fluids) {
        this.getSyncHelper().readPacket(fluids);
    }
}

