/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.IConfigManager;
import appeng.container.ContainerLocator;
import appeng.container.implementations.ContainerHelper;
import appeng.fluids.container.FluidConfigurableContainer;
import appeng.fluids.helper.DualityFluidInterface;
import appeng.fluids.helper.FluidSyncHelper;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.fluids.util.IAEFluidTank;
import java.util.Collections;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1712;
import net.minecraft.class_2540;
import net.minecraft.class_3917;

public class FluidInterfaceContainer
extends FluidConfigurableContainer {
    public static class_3917<FluidInterfaceContainer> TYPE;
    private static final ContainerHelper<FluidInterfaceContainer, IFluidInterfaceHost> helper;
    private final DualityFluidInterface myDuality;
    private final FluidSyncHelper tankSync;

    public static FluidInterfaceContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public FluidInterfaceContainer(int id, class_1661 ip, IFluidInterfaceHost te) {
        super(TYPE, id, ip, te.getDualityFluidInterface().getHost());
        this.myDuality = te.getDualityFluidInterface();
        this.tankSync = new FluidSyncHelper(this.myDuality.getTanks(), 6);
    }

    @Override
    protected int getHeight() {
        return 231;
    }

    public IAEFluidTank getTanks() {
        return this.myDuality.getTanks();
    }

    @Override
    public IAEFluidTank getFluidConfigInventory() {
        return this.myDuality.getConfig();
    }

    @Override
    public void method_7623() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            this.tankSync.sendDiff(this.getListeners());
        }
        super.method_7623();
    }

    @Override
    protected void setupConfig() {
    }

    @Override
    protected void loadSettingsFromHost(IConfigManager cm) {
    }

    @Override
    public void method_7596(class_1712 listener) {
        super.method_7596(listener);
        this.tankSync.sendFull(Collections.singleton(listener));
    }

    @Override
    public void receiveFluidSlots(Map<Integer, IAEFluidStack> fluids) {
        super.receiveFluidSlots(fluids);
        this.tankSync.readPacket(fluids);
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 0;
    }

    @Override
    public boolean hasToolbox() {
        return false;
    }

    static {
        helper = new ContainerHelper<FluidInterfaceContainer, IFluidInterfaceHost>(FluidInterfaceContainer::new, IFluidInterfaceHost.class, SecurityPermissions.BUILD);
    }
}

