/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.container.ContainerLocator;
import appeng.container.implementations.ContainerHelper;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.fluids.container.FluidConfigurableContainer;
import appeng.fluids.parts.FluidLevelEmitterPart;
import appeng.fluids.util.IAEFluidTank;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_3917;

public class FluidLevelEmitterContainer
extends FluidConfigurableContainer {
    public static class_3917<FluidLevelEmitterContainer> TYPE;
    private static final ContainerHelper<FluidLevelEmitterContainer, FluidLevelEmitterPart> helper;
    private final FluidLevelEmitterPart lvlEmitter;
    private long reportingValue;

    public static FluidLevelEmitterContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf, (host, container, buffer) -> {
            container.reportingValue = buffer.method_10792();
        });
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator, (host, buffer) -> buffer.method_10791(host.getReportingValue()));
    }

    public FluidLevelEmitterContainer(int id, class_1661 ip, FluidLevelEmitterPart te) {
        super(TYPE, id, ip, te);
        this.lvlEmitter = te;
    }

    public long getReportingValue() {
        return this.reportingValue;
    }

    public void setReportingValue(long reportingValue) {
        if (this.isClient()) {
            if (reportingValue != this.reportingValue) {
                this.reportingValue = reportingValue;
                NetworkHandler.instance().sendToServer(new ConfigValuePacket("FluidLevelEmitter.Value", String.valueOf(reportingValue)));
            }
        } else {
            this.lvlEmitter.setReportingValue(reportingValue);
        }
    }

    @Override
    protected void setupConfig() {
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 0;
    }

    @Override
    public void method_7623() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            this.setRedStoneMode((RedstoneMode)this.getUpgradeable().getConfigManager().getSetting(Settings.REDSTONE_EMITTER));
        }
        this.standardDetectAndSendChanges();
    }

    @Override
    public IAEFluidTank getFluidConfigInventory() {
        return this.lvlEmitter.getConfig();
    }

    static {
        helper = new ContainerHelper<FluidLevelEmitterContainer, FluidLevelEmitterPart>(FluidLevelEmitterContainer::new, FluidLevelEmitterPart.class, SecurityPermissions.BUILD);
    }
}

