/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.Ref;
import alexiil.mc.lib.attributes.misc.Reference;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEFluidInventoryUpdatePacket;
import appeng.core.sync.packets.TargetFluidStackPacket;
import appeng.fluids.util.AEFluidStack;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.io.IOException;
import java.math.RoundingMode;
import java.nio.BufferOverflowException;
import javax.annotation.Nonnull;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class FluidTerminalContainer
extends AEBaseContainer
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    public static class_3917<FluidTerminalContainer> TYPE;
    private static final ContainerHelper<FluidTerminalContainer, ITerminalHost> helper;
    private final IConfigManager clientCM;
    private final IMEMonitor<IAEFluidStack> monitor;
    private final IItemList<IAEFluidStack> fluids = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
    @GuiSync(value=99)
    public boolean hasPower = false;
    private ITerminalHost terminal;
    private IConfigManager serverCM;
    private IConfigManagerHost gui;
    private IGridNode networkNode;
    private IAEFluidStack clientRequestedTargetFluid = null;

    public static FluidTerminalContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(class_1657 player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public FluidTerminalContainer(int id, class_1661 ip, ITerminalHost terminal) {
        super(TYPE, id, ip, terminal);
        this.terminal = terminal;
        this.clientCM = new ConfigManager(this);
        this.clientCM.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.clientCM.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        if (this.isServer()) {
            this.serverCM = terminal.getConfigManager();
            this.monitor = terminal.getInventory(Api.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            if (this.monitor != null) {
                IGridNode node;
                this.monitor.addListener(this, null);
                if (terminal instanceof IEnergySource) {
                    this.setPowerSource((IEnergySource)((Object)terminal));
                } else if ((terminal instanceof IGridHost || terminal instanceof IActionHost) && (node = terminal instanceof IGridHost ? ((IGridHost)((Object)terminal)).getGridNode(AEPartLocation.INTERNAL) : (terminal instanceof IActionHost ? ((IActionHost)((Object)terminal)).getActionableNode() : null)) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        this.setPowerSource(new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                    }
                }
            }
        } else {
            this.monitor = null;
        }
        this.bindPlayerInventory(ip, 0, 140);
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return true;
    }

    @Override
    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, IActionSource actionSource) {
        for (IAEFluidStack is : change) {
            this.fluids.add(is);
        }
    }

    @Override
    public void onListUpdate() {
        for (class_1712 c : this.getListeners()) {
            this.queueInventory(c);
        }
    }

    public void method_7596(class_1712 listener) {
        super.method_7596(listener);
        this.queueInventory(listener);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.monitor != null) {
            this.monitor.removeListener(this);
        }
    }

    private void queueInventory(class_1712 c) {
        if (this.isServer() && c instanceof class_1657 && this.monitor != null) {
            try {
                MEFluidInventoryUpdatePacket piu = new MEFluidInventoryUpdatePacket();
                IItemList<IAEFluidStack> monitorCache = this.monitor.getStorageList();
                for (IAEFluidStack send : monitorCache) {
                    try {
                        piu.appendFluid(send);
                    }
                    catch (BufferOverflowException boe) {
                        NetworkHandler.instance().sendTo(piu, (class_3222)c);
                        piu = new MEFluidInventoryUpdatePacket();
                        piu.appendFluid(send);
                    }
                }
                NetworkHandler.instance().sendTo(piu, (class_3222)c);
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        if (this.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public void setTargetStack(IAEFluidStack stack) {
        if (this.isClient()) {
            if (stack == null && this.clientRequestedTargetFluid == null) {
                return;
            }
            if (stack != null && this.clientRequestedTargetFluid != null && FluidVolume.areEqualExceptAmounts((FluidVolume)stack.getFluidStack(), (FluidVolume)this.clientRequestedTargetFluid.getFluidStack())) {
                return;
            }
            NetworkHandler.instance().sendToServer(new TargetFluidStackPacket((AEFluidStack)stack));
        }
        this.clientRequestedTargetFluid = stack == null ? null : stack.copy();
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    @Override
    public void method_7623() {
        if (this.isServer()) {
            if (this.monitor != this.terminal.getInventory(Api.instance().storage().getStorageChannel(IFluidStorageChannel.class))) {
                this.setValidContainer(false);
            }
            for (Settings set : this.serverCM.getSettings()) {
                Enum<?> enum_;
                Enum<?> sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (enum_ = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (class_1712 crafter : this.getListeners()) {
                    if (!(crafter instanceof class_3222)) continue;
                    NetworkHandler.instance().sendTo(new ConfigValuePacket(set.name(), sideLocal.name()), (class_3222)crafter);
                }
            }
            if (!this.fluids.isEmpty()) {
                try {
                    IItemList<IAEFluidStack> monitorCache = this.monitor.getStorageList();
                    MEFluidInventoryUpdatePacket piu = new MEFluidInventoryUpdatePacket();
                    for (IAEFluidStack iAEFluidStack : this.fluids) {
                        IAEFluidStack send = monitorCache.findPrecise(iAEFluidStack);
                        if (send == null) {
                            iAEFluidStack.setStackSize(0L);
                            piu.appendFluid(iAEFluidStack);
                            continue;
                        }
                        piu.appendFluid(send);
                    }
                    if (!piu.isEmpty()) {
                        this.fluids.resetStatus();
                        for (IAEFluidStack iAEFluidStack : this.getListeners()) {
                            if (!(iAEFluidStack instanceof class_1657)) continue;
                            NetworkHandler.instance().sendTo(piu, (class_3222)iAEFluidStack);
                        }
                    }
                }
                catch (IOException e) {
                    AELog.debug(e);
                }
            }
            this.updatePowerStatus();
            super.method_7623();
        }
    }

    @Override
    public void doAction(class_3222 player, InventoryAction action, int slot, long id) {
        if (action != InventoryAction.FILL_ITEM && action != InventoryAction.EMPTY_ITEM) {
            super.doAction(player, action, slot, id);
            return;
        }
        class_1799 held = player.field_7514.method_7399();
        if (held.method_7947() != 1) {
            return;
        }
        if (action == InventoryAction.FILL_ITEM && this.clientRequestedTargetFluid != null) {
            Ref container = new Ref((Object)held);
            FluidInsertable insertable = (FluidInsertable)FluidAttributes.INSERTABLE.getFirstOrNull((Reference)container);
            if (insertable == null) {
                return;
            }
            FluidVolume volumeOverflow = insertable.attemptInsertion(this.clientRequestedTargetFluid.getFluidStack().withAmount(FluidAmount.ofWhole((long)Long.MAX_VALUE)), Simulation.SIMULATE);
            FluidAmount amountAllowed = FluidAmount.ofWhole((long)Long.MAX_VALUE).saturatedSub(volumeOverflow.amount());
            AEFluidStack stack = AEFluidStack.fromFluidVolume(this.clientRequestedTargetFluid.getFluidStack().withAmount(amountAllowed), RoundingMode.DOWN);
            if (stack == null) {
                return;
            }
            IAEFluidStack canPull = Platform.poweredExtraction(this.getPowerSource(), this.monitor, stack, this.getActionSource(), Actionable.SIMULATE);
            if (canPull == null || canPull.getStackSize() < 1L) {
                return;
            }
            volumeOverflow = insertable.attemptInsertion(canPull.getFluidStack(), Simulation.SIMULATE);
            if (!volumeOverflow.isEmpty()) {
                return;
            }
            stack.setStackSize(canPull.getStackSize());
            IAEFluidStack pulled = Platform.poweredExtraction(this.getPowerSource(), this.monitor, stack, this.getActionSource());
            if (pulled == null || pulled.getStackSize() < 1L) {
                AELog.error("Unable to pull fluid out of the ME system even though the simulation said yes ", new Object[0]);
                return;
            }
            volumeOverflow = insertable.attemptInsertion(pulled.getFluidStack(), Simulation.ACTION);
            if (!volumeOverflow.isEmpty()) {
                AELog.error("Fluid item [%s] reported a different possible amount than it actually accepted. Overflow: %s.", held, volumeOverflow);
            }
            player.field_7514.method_7396((class_1799)container.get());
            this.updateHeld(player);
        } else if (action == InventoryAction.EMPTY_ITEM) {
            FluidVolume drained;
            Ref container = new Ref((Object)held);
            FluidExtractable extractable = (FluidExtractable)FluidAttributes.EXTRACTABLE.getFirstOrNull((Reference)container);
            if (extractable == null) {
                return;
            }
            FluidVolume extract = extractable.attemptAnyExtraction(FluidAmount.MAX_VALUE, Simulation.SIMULATE);
            AEFluidStack aeStack = AEFluidStack.fromFluidVolume(extract, RoundingMode.DOWN);
            if (aeStack == null || aeStack.getStackSize() == 0L) {
                return;
            }
            IAEFluidStack notStorable = Platform.poweredInsert(this.getPowerSource(), this.monitor, aeStack, this.getActionSource(), Actionable.SIMULATE);
            if (notStorable != null && notStorable.getStackSize() > 0L) {
                FluidAmount toStore = aeStack.getAmount().sub(notStorable.getAmount());
                extract = extractable.attemptExtraction((FluidFilter)new ExactFluidFilter(aeStack.getFluid()), toStore, Simulation.SIMULATE);
                if (extract.isEmpty()) {
                    return;
                }
            }
            if ((aeStack = AEFluidStack.fromFluidVolume(drained = extractable.extract(extract.getFluidKey(), extract.amount()), RoundingMode.DOWN)) == null) {
                return;
            }
            IAEFluidStack notInserted = Platform.poweredInsert(this.getPowerSource(), this.monitor, aeStack, this.getActionSource());
            if (notInserted != null && notInserted.getStackSize() > 0L) {
                AELog.error("Fluid item [%s] reported a different possible amount to drain than it actually provided.", held.method_7964());
            }
            player.field_7514.method_7396((class_1799)container.get());
            this.updateHeld(player);
        }
    }

    protected void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                this.setPowered(this.networkNode.isActive());
            } else if (this.getPowerSource() instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.getPowerSource()).isNetworkPowered());
            } else {
                this.setPowered(this.getPowerSource().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    private void setPowered(boolean isPowered) {
        this.hasPower = isPowered;
    }

    static {
        helper = new ContainerHelper<FluidTerminalContainer, ITerminalHost>(FluidTerminalContainer::new, ITerminalHost.class, SecurityPermissions.BUILD);
    }
}

