/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.helper;

import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.fluids.util.AEFluidStack;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupedFluidInvCache {
    private final GroupedFluidInv inventory;
    private final Map<FluidKey, IAEFluidStack> memory = new HashMap<FluidKey, IAEFluidStack>();

    public GroupedFluidInvCache(GroupedFluidInv inventory) {
        this.inventory = inventory;
    }

    public IItemList<IAEFluidStack> getAvailable(IItemList<IAEFluidStack> out) {
        for (Map.Entry<FluidKey, IAEFluidStack> entry : this.memory.entrySet()) {
            out.add((IAEFluidStack)((IAEStack)entry.getValue()));
        }
        return out;
    }

    public List<IAEFluidStack> detectChanges() {
        ArrayList<IAEFluidStack> changes = new ArrayList<IAEFluidStack>();
        Set storedFluids = this.inventory.getStoredFluids();
        for (FluidKey storedFluid : storedFluids) {
            FluidAmount oldAmount;
            IAEFluidStack old = this.memory.get(storedFluid);
            FluidAmount newAmount = this.inventory.getAmount_F(storedFluid);
            if (newAmount.equals(oldAmount = old == null ? FluidAmount.ZERO : old.getAmount())) continue;
            AEFluidStack newStack = AEFluidStack.fromFluidVolume(storedFluid.withAmount(newAmount), RoundingMode.DOWN);
            if (old != null) {
                old = old.copy();
                old.setStackSize(-old.getStackSize());
                changes.add(old);
            }
            if (newStack != null) {
                this.memory.put(storedFluid, newStack);
                changes.add(newStack);
                continue;
            }
            this.memory.remove(storedFluid);
        }
        HashSet<FluidKey> toRemove = null;
        for (Map.Entry<FluidKey, IAEFluidStack> entry : this.memory.entrySet()) {
            if (storedFluids.contains(entry.getKey())) continue;
            if (toRemove == null) {
                toRemove = new HashSet<FluidKey>();
            }
            toRemove.add(entry.getKey());
            IAEFluidStack a = entry.getValue().copy();
            a.setStackSize(-a.getStackSize());
            changes.add(a);
        }
        if (toRemove != null) {
            for (FluidKey fluidKey : toRemove) {
                this.memory.remove(fluidKey);
            }
        }
        return changes;
    }
}

