/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.items;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.core.Api;
import appeng.fluids.helper.FluidCellConfig;
import appeng.items.materials.MaterialType;
import appeng.items.storage.AbstractStorageCell;
import appeng.util.InventoryAdaptor;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public final class BasicFluidStorageCell
extends AbstractStorageCell<IAEFluidStack> {
    private final int perType;
    private final double idleDrain;

    public BasicFluidStorageCell(class_1792.class_1793 props, MaterialType whichCell, int kilobytes) {
        super(props, whichCell, kilobytes);
        switch (whichCell) {
            case FLUID_1K_CELL_COMPONENT: {
                this.idleDrain = 0.5;
                this.perType = 8;
                break;
            }
            case FLUID_4K_CELL_COMPONENT: {
                this.idleDrain = 1.0;
                this.perType = 32;
                break;
            }
            case FLUID_16K_CELL_COMPONENT: {
                this.idleDrain = 1.5;
                this.perType = 128;
                break;
            }
            case FLUID_64K_CELL_COMPONENT: {
                this.idleDrain = 2.0;
                this.perType = 512;
                break;
            }
            default: {
                this.idleDrain = 0.0;
                this.perType = 8;
            }
        }
    }

    @Override
    public int getBytesPerType(class_1799 cellItem) {
        return this.perType;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public IStorageChannel<IAEFluidStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public int getTotalTypes(class_1799 cellItem) {
        return 5;
    }

    @Override
    public FixedItemInv getConfigInventory(class_1799 is) {
        return new FluidCellConfig(is);
    }

    @Override
    protected void dropEmptyStorageCellCase(InventoryAdaptor ia, class_1657 player) {
        Api.instance().definitions().materials().emptyStorageCell().maybeStack(1).ifPresent(is -> {
            class_1799 extraA = ia.addItems((class_1799)is);
            if (!extraA.method_7960()) {
                player.method_7328(extraA, false);
            }
        });
    }
}

