/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AECableType;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.settings.TickRates;
import appeng.core.sync.packets.BlockTransitionEffectPacket;
import appeng.fluids.util.AEFluidStack;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.mixins.tags.FluidTagsAccessor;
import appeng.parts.BasicStatePart;
import appeng.parts.automation.PlaneConnectionHelper;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModels;
import appeng.util.Platform;
import java.math.RoundingMode;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class FluidAnnihilationPlanePart
extends BasicStatePart
implements IGridTickable {
    public static final class_3494.class_5123<class_3611> TAG_BLACKLIST = FluidTagsAccessor.register(AppEng.makeId("blacklisted/fluid_annihilation_plane").toString());
    private static final PlaneModels MODELS = new PlaneModels("part/fluid_annihilation_plane", "part/fluid_annihilation_plane_on");
    private final IActionSource mySrc = new MachineSource(this);
    private final PlaneConnectionHelper connectionHelper = new PlaneConnectionHelper(this);

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public FluidAnnihilationPlanePart(class_1799 is) {
        super(is);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        this.connectionHelper.getBoxes(bch);
    }

    public PlaneConnections getConnections() {
        return this.connectionHelper.getConnections();
    }

    @Override
    public void onNeighborUpdate(class_1922 w, class_2338 pos, class_2338 neighbor) {
        if (pos.method_10093(this.getSide().getFacing()).equals((Object)neighbor)) {
            this.refresh();
        } else {
            this.connectionHelper.updateConnections();
        }
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    private void refresh() {
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.refresh();
        this.getHost().markForUpdate();
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.refresh();
        this.getHost().markForUpdate();
    }

    private TickRateModulation tryDrainFluid() {
        class_2338 pos;
        if (!this.getProxy().isActive()) {
            return TickRateModulation.SLEEP;
        }
        class_2586 te = this.getTile();
        class_1937 w = te.method_10997();
        class_2680 blockstate = w.method_8320(pos = te.method_11016().method_10093(this.getSide().getFacing()));
        if (blockstate.method_26204() instanceof class_2263) {
            class_3610 fluidState = blockstate.method_26227();
            class_3611 fluid = fluidState.method_15772();
            if (this.isFluidBlacklisted(fluid)) {
                return TickRateModulation.SLEEP;
            }
            if (fluid != class_3612.field_15906 && fluidState.method_15771()) {
                AEFluidStack blockFluid = AEFluidStack.fromFluidVolume(FluidKeys.get((class_3611)fluid).withAmount(FluidAmount.ONE), RoundingMode.DOWN);
                if (this.storeFluid(blockFluid, false)) {
                    fluid = ((class_2263)blockstate.method_26204()).method_9700((class_1936)w, pos, blockstate);
                    this.storeFluid(AEFluidStack.fromFluidVolume(FluidKeys.get((class_3611)fluid).withAmount(FluidAmount.ONE), RoundingMode.DOWN), true);
                    AppEng.instance().sendToAllNearExcept(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), 64.0, w, new BlockTransitionEffectPacket(pos, blockstate, this.getSide().getOpposite(), BlockTransitionEffectPacket.SoundMode.FLUID));
                    return TickRateModulation.URGENT;
                }
                return TickRateModulation.IDLE;
            }
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.AnnihilationPlane.getMin(), TickRates.AnnihilationPlane.getMax(), false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.tryDrainFluid();
    }

    private boolean storeFluid(IAEFluidStack stack, boolean modulate) {
        try {
            IStorageGrid storage = this.getProxy().getStorage();
            IMEMonitor<IAEFluidStack> inv = storage.getInventory(Api.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            if (modulate) {
                IEnergyGrid energy = this.getProxy().getEnergy();
                return Platform.poweredInsert(energy, inv, stack, this.mySrc) == null;
            }
            float requiredPower = (float)stack.getStackSize() / Math.min(1.0f, (float)stack.getChannel().transferFactor());
            IEnergyGrid energy = this.getProxy().getEnergy();
            if (energy.extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG) < (double)requiredPower) {
                return false;
            }
            IAEFluidStack leftOver = inv.injectItems(stack, Actionable.SIMULATE, this.mySrc);
            return leftOver == null || leftOver.getStackSize() == 0L;
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    @Nonnull
    public Object getModelData() {
        return this.getConnections();
    }

    private boolean isFluidBlacklisted(class_3611 fluid) {
        return fluid.method_15791(TAG_BLACKLIST);
    }
}

