/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmountBase;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.attributes.MEAttributes;
import appeng.core.settings.TickRates;
import appeng.fluids.parts.SharedFluidBusPart;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import java.math.RoundingMode;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class FluidExportBusPart
extends SharedFluidBusPart {
    public static final class_2960 MODEL_BASE = new class_2960("appliedenergistics2", "part/fluid_export_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/fluid_export_bus_off"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/fluid_export_bus_on"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/fluid_export_bus_has_channel"));
    private final IActionSource source;

    public FluidExportBusPart(class_1799 is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT);
        this.source = new MachineSource(this);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.FluidExportBus.getMin(), TickRates.FluidExportBus.getMax(), this.isSleeping(), false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.canDoBusWork() ? this.doBusWork() : TickRateModulation.IDLE;
    }

    @Override
    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        FluidInsertable insertable = (FluidInsertable)MEAttributes.getAttributeInFrontOfPart(FluidAttributes.INSERTABLE, this);
        if (insertable != null) {
            try {
                IMEMonitor<IAEFluidStack> inv = this.getProxy().getStorage().getInventory(this.getChannel());
                for (int i = 0; i < this.getConfig().getSlots(); ++i) {
                    FluidVolume toInsert;
                    FluidVolume remainder;
                    IAEFluidStack fluid = this.getConfig().getFluidInSlot(i);
                    if (fluid == null) continue;
                    IAEFluidStack toExtract = fluid.copy();
                    toExtract.setStackSize(this.calculateAmountToSend());
                    IAEFluidStack out = inv.extractItems(toExtract, Actionable.SIMULATE, this.source);
                    if (out == null || !(remainder = insertable.attemptInsertion(toInsert = out.getFluidStack(), Simulation.ACTION)).getAmount_F().isLessThan((FluidAmountBase)toInsert.getAmount_F())) continue;
                    long remainderMillibuckets = remainder.getAmount_F().asInt(1000, RoundingMode.DOWN);
                    toExtract.decStackSize(remainderMillibuckets);
                    inv.extractItems(toExtract, Actionable.MODULATE, this.source);
                    return TickRateModulation.FASTER;
                }
                return TickRateModulation.SLOWER;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Override
    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

