/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmountBase;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.fluid.world.FluidWorldUtil;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.core.Api;
import appeng.fluids.container.FluidFormationPlaneContainer;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.automation.AbstractFormationPlanePart;
import appeng.parts.automation.PlaneModels;
import appeng.util.Platform;
import appeng.util.prioritylist.PrecisePriorityList;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2402;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3917;

public class FluidFormationPlanePart
extends AbstractFormationPlanePart<IAEFluidStack>
implements IAEFluidInventory {
    private static final PlaneModels MODELS = new PlaneModels("part/fluid_formation_plane", "part/fluid_formation_plane_on");
    private final MEInventoryHandler<IAEFluidStack> myHandler = new MEInventoryHandler<IAEFluidStack>(this, Api.instance().storage().getStorageChannel(IFluidStorageChannel.class));
    private final AEFluidInventory config = new AEFluidInventory(this, 63);

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public FluidFormationPlanePart(class_1799 is) {
        super(is);
        this.updateHandler();
    }

    @Override
    protected void updateHandler() {
        this.myHandler.setBaseAccess(AccessRestriction.WRITE);
        this.myHandler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        this.myHandler.setPriority(this.getPriority());
        IItemList<IAEFluidStack> priorityList = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
        int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
        for (int x = 0; x < this.config.getSlots() && x < slotsToUse; ++x) {
            IAEFluidStack is = this.config.getFluidInSlot(x);
            if (is == null) continue;
            priorityList.add(is);
        }
        this.myHandler.setPartitionList(new PrecisePriorityList(priorityList));
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, IActionSource src) {
        FluidVolume volume;
        if (this.blocked || input == null || input.getAmount().isLessThan((FluidAmountBase)FluidAmount.BUCKET)) {
            return input;
        }
        class_2586 te = this.getHost().getTile();
        class_1937 w = te.method_10997();
        AEPartLocation side = this.getSide();
        class_2338 pos = te.method_11016().method_10093(side.getFacing());
        FluidVolume remainder = FluidWorldUtil.fill((class_1936)w, (class_2338)pos, (FluidVolume)(volume = input.getFluidStack()), (Simulation)(type == Actionable.MODULATE ? Simulation.ACTION : Simulation.SIMULATE));
        if (remainder.getAmount_F().isLessThan((FluidAmountBase)volume.getAmount_F())) {
            if (remainder.isEmpty()) {
                return null;
            }
            return AEFluidStack.fromFluidVolume(remainder, RoundingMode.DOWN);
        }
        this.blocked = true;
        return input;
    }

    @Override
    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        if (inv == this.config) {
            this.updateHandler();
        }
    }

    @Override
    protected boolean isBlocking(class_1922 w, class_2338 pos) {
        class_2680 state = w.method_8320(pos);
        class_2248 block = state.method_26204();
        return !state.method_26215() && !(block instanceof class_2402) && !(block instanceof class_2404);
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.config.readFromNBT(data, "config");
        this.updateHandler();
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        this.config.writeToNBT(data, "config");
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.stateChanged();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged changedChannels) {
        this.stateChanged();
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isServer()) {
            ContainerOpener.openContainer(FluidFormationPlaneContainer.TYPE, player, ContainerLocator.forPart(this));
        }
        return true;
    }

    @Override
    public IStorageChannel<IAEFluidStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (this.getProxy().isActive() && channel == Api.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
            ArrayList<IMEInventoryHandler> handler = new ArrayList<IMEInventoryHandler>(1);
            handler.add(this.myHandler);
            return handler;
        }
        return Collections.emptyList();
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    @Nonnull
    public Object getModelData() {
        return this.getConnections();
    }

    public IAEFluidTank getConfig() {
        return this.config;
    }

    @Override
    public class_1799 getItemStackRepresentation() {
        return Api.instance().definitions().parts().fluidFormationnPlane().maybeStack(1).orElse(class_1799.field_8037);
    }

    @Override
    public class_3917<?> getContainerType() {
        return FluidFormationPlaneContainer.TYPE;
    }
}

