/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.fluids.helper.GroupedFluidInvCache;
import appeng.fluids.util.AEFluidStack;
import appeng.me.GridAccessException;
import appeng.me.helpers.IGridProxyable;
import appeng.me.storage.ITickingMonitor;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FluidHandlerAdapter
implements IMEInventory<IAEFluidStack>,
IBaseMonitor<IAEFluidStack>,
ITickingMonitor {
    private final Map<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> listeners = new HashMap<IMEMonitorHandlerReceiver<IAEFluidStack>, Object>();
    private IActionSource source;
    private final GroupedFluidInv fluidHandler;
    private final IGridProxyable proxyable;
    private final GroupedFluidInvCache cache;

    FluidHandlerAdapter(GroupedFluidInv fluidHandler, IGridProxyable proxy) {
        this.fluidHandler = fluidHandler;
        this.proxyable = proxy;
        this.cache = new GroupedFluidInvCache(this.fluidHandler);
    }

    private Simulation getFluidAction(Actionable actionable) {
        return actionable == Actionable.MODULATE ? Simulation.ACTION : Simulation.SIMULATE;
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, IActionSource src) {
        FluidVolume fluidStack = input.getFluidStack();
        FluidVolume excess = this.fluidHandler.attemptInsertion(fluidStack, this.getFluidAction(type));
        if (excess.amount().equals(fluidStack.amount())) {
            return input;
        }
        if (type == Actionable.MODULATE) {
            try {
                this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return AEFluidStack.fromFluidVolume(excess, RoundingMode.DOWN);
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, IActionSource src) {
        ExactFluidFilter filter = new ExactFluidFilter(request.getFluid());
        FluidVolume gathered = this.fluidHandler.attemptExtraction((FluidFilter)filter, request.getAmount(), this.getFluidAction(mode));
        if (gathered.isEmpty()) {
            return null;
        }
        if (mode == Actionable.MODULATE) {
            try {
                this.proxyable.getProxy().getTick().alertDevice(this.proxyable.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return AEFluidStack.fromFluidVolume(gathered, RoundingMode.DOWN);
    }

    @Override
    public TickRateModulation onTick() {
        List<IAEFluidStack> changes = this.cache.detectChanges();
        if (!changes.isEmpty()) {
            this.postDifference(changes);
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        return this.cache.getAvailable(out);
    }

    @Override
    public IStorageChannel<IAEFluidStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public void setActionSource(IActionSource source) {
        this.source = source;
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEFluidStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEFluidStack> l) {
        this.listeners.remove(l);
    }

    private void postDifference(Iterable<IAEFluidStack> a) {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object>> i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> l = i.next();
            IMEMonitorHandlerReceiver<IAEFluidStack> key = l.getKey();
            if (key.isValid(l.getValue())) {
                key.postChange(this, a, this.source);
                continue;
            }
            i.remove();
        }
    }
}

