/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.attributes.MEAttributes;
import appeng.core.settings.TickRates;
import appeng.fluids.parts.SharedFluidBusPart;
import appeng.fluids.util.AEFluidStack;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import java.math.RoundingMode;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class FluidImportBusPart
extends SharedFluidBusPart {
    public static final class_2960 MODEL_BASE = new class_2960("appliedenergistics2", "part/fluid_import_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/fluid_import_bus_off"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/fluid_import_bus_on"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/fluid_import_bus_has_channel"));
    private final IActionSource source;

    public FluidImportBusPart(class_1799 is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT);
        this.source = new MachineSource(this);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.FluidImportBus.getMin(), TickRates.FluidImportBus.getMax(), this.isSleeping(), false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.canDoBusWork() ? this.doBusWork() : TickRateModulation.IDLE;
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        FluidExtractable extractable = (FluidExtractable)MEAttributes.getAttributeInFrontOfPart(FluidAttributes.EXTRACTABLE, this);
        if (extractable != null) {
            try {
                IMEMonitor<IAEFluidStack> inv = this.getProxy().getStorage().getInventory(this.getChannel());
                FluidFilter filter = this.getFilter();
                FluidVolume extractableVolume = extractable.attemptExtraction(filter, FluidAmount.of((long)this.calculateAmountToSend(), (long)1000L), Simulation.SIMULATE);
                if (extractableVolume.isEmpty() || !filter.matches(extractableVolume.fluidKey)) {
                    return TickRateModulation.SLOWER;
                }
                AEFluidStack aeFluidStack = AEFluidStack.fromFluidVolume(extractableVolume, RoundingMode.DOWN);
                if (aeFluidStack != null) {
                    IAEFluidStack notInserted = inv.injectItems(aeFluidStack, Actionable.MODULATE, this.source);
                    if (notInserted != null && notInserted.getStackSize() > 0L) {
                        aeFluidStack.decStackSize(notInserted.getStackSize());
                    }
                    if (aeFluidStack.getStackSize() == 0L) {
                        return TickRateModulation.SLOWER;
                    }
                    extractable.extract(filter, aeFluidStack.getAmount());
                    return TickRateModulation.FASTER;
                }
                return TickRateModulation.IDLE;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    private FluidFilter getFilter() {
        HashSet<FluidKey> allowedFluids = null;
        for (int i = 0; i < this.getConfig().getSlots(); ++i) {
            IAEFluidStack stack = this.getConfig().getFluidInSlot(i);
            if (stack == null) continue;
            if (allowedFluids == null) {
                allowedFluids = new HashSet<FluidKey>();
            }
            allowedFluids.add(stack.getFluid());
        }
        return allowedFluids == null ? ConstantFluidFilter.ANYTHING : allowedFluids::contains;
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Override
    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

