/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.core.Api;
import appeng.fluids.container.FluidLevelEmitterContainer;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.PartModel;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class FluidLevelEmitterPart
extends UpgradeablePart
implements IStackWatcherHost,
IConfigManagerHost,
IAEFluidInventory,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    @PartModels
    public static final class_2960 MODEL_BASE_OFF = new class_2960("appliedenergistics2", "part/level_emitter_base_off");
    @PartModels
    public static final class_2960 MODEL_BASE_ON = new class_2960("appliedenergistics2", "part/level_emitter_base_on");
    @PartModels
    public static final class_2960 MODEL_STATUS_OFF = new class_2960("appliedenergistics2", "part/level_emitter_status_off");
    @PartModels
    public static final class_2960 MODEL_STATUS_ON = new class_2960("appliedenergistics2", "part/level_emitter_status_on");
    @PartModels
    public static final class_2960 MODEL_STATUS_HAS_CHANNEL = new class_2960("appliedenergistics2", "part/level_emitter_status_has_channel");
    public static final PartModel MODEL_OFF_OFF = new PartModel(MODEL_BASE_OFF, MODEL_STATUS_OFF);
    public static final PartModel MODEL_OFF_ON = new PartModel(MODEL_BASE_OFF, MODEL_STATUS_ON);
    public static final PartModel MODEL_OFF_HAS_CHANNEL = new PartModel(MODEL_BASE_OFF, MODEL_STATUS_HAS_CHANNEL);
    public static final PartModel MODEL_ON_OFF = new PartModel(MODEL_BASE_ON, MODEL_STATUS_OFF);
    public static final PartModel MODEL_ON_ON = new PartModel(MODEL_BASE_ON, MODEL_STATUS_ON);
    public static final PartModel MODEL_ON_HAS_CHANNEL = new PartModel(MODEL_BASE_ON, MODEL_STATUS_HAS_CHANNEL);
    private static final int FLAG_ON = 4;
    private boolean prevState = false;
    private long lastReportedValue = 0L;
    private long reportingValue = 0L;
    private IStackWatcher stackWatcher = null;
    private final AEFluidInventory config = new AEFluidInventory(this, 1);

    public FluidLevelEmitterPart(class_1799 is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_EMITTER, RedstoneMode.HIGH_SIGNAL);
    }

    public long getReportingValue() {
        return this.reportingValue;
    }

    public void setReportingValue(long v) {
        this.reportingValue = v;
        this.updateState();
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        this.configureWatchers();
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.stackWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onStackChange(IItemList<?> o, IAEStack<?> fullStack, IAEStack<?> diffStack, IActionSource src, IStorageChannel<?> chan) {
        if (chan == Api.instance().storage().getStorageChannel(IFluidStorageChannel.class) && fullStack.equals(this.config.getFluidInSlot(0))) {
            this.lastReportedValue = fullStack.getStackSize();
            this.updateState();
        }
    }

    @Override
    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        this.configureWatchers();
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelsChanged c) {
        this.updateState();
    }

    @MENetworkEventSubscribe
    public void powerChanged(MENetworkPowerStatusChange c) {
        this.updateState();
    }

    @Override
    public int isProvidingStrongPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    protected int populateFlags(int cf) {
        return cf | (this.prevState ? 4 : 0);
    }

    @Override
    public boolean isValid(Object effectiveGrid) {
        try {
            return this.getProxy().getGrid() == effectiveGrid;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    @Override
    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, IActionSource actionSource) {
        this.updateReportingValue((IMEMonitor)monitor);
    }

    @Override
    public void onListUpdate() {
        try {
            IFluidStorageChannel channel = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
            IMEMonitor<IAEFluidStack> inventory = this.getProxy().getStorage().getInventory(channel);
            this.updateReportingValue(inventory);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateState() {
        boolean isOn = this.isLevelEmitterOn();
        if (this.prevState != isOn) {
            this.getHost().markForUpdate();
            class_2586 te = this.getHost().getTile();
            this.prevState = isOn;
            Platform.notifyBlocksOfNeighbors(te.method_10997(), te.method_11016());
            Platform.notifyBlocksOfNeighbors(te.method_10997(), te.method_11016().method_10093(this.getSide().getFacing()));
        }
    }

    private void configureWatchers() {
        IFluidStorageChannel channel = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
        if (this.stackWatcher != null) {
            this.stackWatcher.reset();
            IAEFluidStack myStack = this.config.getFluidInSlot(0);
            try {
                if (myStack != null) {
                    this.getProxy().getStorage().getInventory(channel).removeListener(this);
                    this.stackWatcher.add(myStack);
                } else {
                    this.getProxy().getStorage().getInventory(channel).addListener(this, this.getProxy().getGrid());
                }
                IMEMonitor<IAEFluidStack> inventory = this.getProxy().getStorage().getInventory(channel);
                this.updateReportingValue(inventory);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private void updateReportingValue(IMEMonitor<IAEFluidStack> monitor) {
        IAEFluidStack myStack = this.config.getFluidInSlot(0);
        if (myStack == null) {
            this.lastReportedValue = 0L;
            for (IAEFluidStack st : monitor.getStorageList()) {
                this.lastReportedValue += st.getStackSize();
            }
        } else {
            IAEFluidStack r = monitor.getStorageList().findPrecise(myStack);
            this.lastReportedValue = r == null ? 0L : r.getStackSize();
        }
        this.updateState();
    }

    private boolean isLevelEmitterOn() {
        boolean flipState;
        if (Platform.isClient()) {
            return (this.getClientFlags() & 4) == 4;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        boolean bl = flipState = this.getConfigManager().getSetting(Settings.REDSTONE_EMITTER) == RedstoneMode.LOW_SIGNAL;
        return flipState ? this.reportingValue > this.lastReportedValue : this.reportingValue <= this.lastReportedValue;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 16.0f;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    public void randomDisplayTick(class_1937 world, class_2338 pos, Random r) {
        if (this.isLevelEmitterOn()) {
            AEPartLocation d = this.getSide();
            double d0 = (double)((float)d.xOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)d.yOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)d.zOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.method_8406((class_2394)class_2390.field_11188, 0.5 + (double)pos.method_10263() + d0, 0.5 + (double)pos.method_10264() + d1, 0.5 + (double)pos.method_10260() + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isServer()) {
            ContainerOpener.openContainer(FluidLevelEmitterContainer.TYPE, player, ContainerLocator.forPart(this));
        }
        return true;
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_HAS_CHANNEL : MODEL_OFF_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_ON : MODEL_OFF_ON;
        }
        return this.isLevelEmitterOn() ? MODEL_ON_OFF : MODEL_OFF_OFF;
    }

    public IAEFluidTank getConfig() {
        return this.config;
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.lastReportedValue = data.method_10537("lastReportedValue");
        this.reportingValue = data.method_10537("reportingValue");
        this.prevState = data.method_10577("prevState");
        this.config.readFromNBT(data, "config");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10544("lastReportedValue", this.lastReportedValue);
        data.method_10544("reportingValue", this.reportingValue);
        data.method_10556("prevState", this.prevState);
        this.config.writeToNBT(data, "config");
    }
}

