/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.attributes.MEAttributes;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.core.Api;
import appeng.core.settings.TickRates;
import appeng.fluids.container.FluidStorageBusContainer;
import appeng.fluids.parts.FluidHandlerAdapter;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import appeng.helpers.IInterfaceHost;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.ITickingMonitor;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.PartModel;
import appeng.parts.misc.SharedStorageBusPart;
import appeng.util.Platform;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.PrecisePriorityList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3917;

public class FluidStorageBusPart
extends SharedStorageBusPart
implements IMEMonitorHandlerReceiver<IAEFluidStack>,
IAEFluidInventory {
    public static final class_2960 MODEL_BASE = new class_2960("appliedenergistics2", "part/fluid_storage_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/fluid_storage_bus_off"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/fluid_storage_bus_on"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new class_2960("appliedenergistics2", "part/fluid_storage_bus_has_channel"));
    private final IActionSource source;
    private final AEFluidInventory config = new AEFluidInventory(this, 63);
    private boolean cached = false;
    private ITickingMonitor monitor = null;
    private MEInventoryHandler<IAEFluidStack> handler = null;
    private int handlerHash = 0;
    private byte resetCacheLogic = 0;

    public FluidStorageBusPart(class_1799 is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.source = new MachineSource(this);
    }

    private IMEInventory<IAEFluidStack> getInventoryWrapper(class_2586 target) {
        IStorageMonitorableAccessor accessor = MEAttributes.getAttributeInFrontOfPart(MEAttributes.STORAGE_MONITORABLE_ACCESSOR, this);
        if (accessor != null) {
            IStorageMonitorable inventory = accessor.getInventory(this.source);
            if (inventory != null) {
                return inventory.getInventory(Api.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            }
            return null;
        }
        GroupedFluidInv handlerExt = (GroupedFluidInv)MEAttributes.getAttributeInFrontOfPart(FluidAttributes.GROUPED_INV, this);
        if (handlerExt != null) {
            return new FluidHandlerAdapter(handlerExt, this);
        }
        return null;
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.resetCacheLogic != 0) {
            this.resetCache();
        }
        if (this.monitor != null) {
            return this.monitor.onTick();
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    protected void resetCache() {
        MEInventoryHandler<IAEFluidStack> out;
        boolean fullReset = this.resetCacheLogic == 2;
        this.resetCacheLogic = 0;
        MEInventoryHandler<IAEFluidStack> in = this.getInternalHandler();
        IItemList before = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
        if (in != null) {
            before = in.getAvailableItems(before);
        }
        this.cached = false;
        if (fullReset) {
            this.handlerHash = 0;
        }
        if (in != (out = this.getInternalHandler())) {
            IItemList after = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
            if (out != null) {
                after = out.getAvailableItems(after);
            }
            Platform.postListChanges(before, after, this, this.source);
        }
    }

    @Override
    protected void resetCache(boolean fullReset) {
        if (this.getHost() == null || this.getHost().getTile() == null || this.getHost().getTile().method_10997() == null || this.getHost().getTile().method_10997().field_9236) {
            return;
        }
        this.resetCacheLogic = fullReset ? (byte)2 : (byte)1;
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (Platform.isServer()) {
            ContainerOpener.openContainer(FluidStorageBusContainer.TYPE, player, ContainerLocator.forPart(this));
        }
        return true;
    }

    @Override
    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        if (inv == this.config) {
            this.resetCache(true);
        }
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.config.readFromNBT(data, "config");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        this.config.writeToNBT(data, "config");
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return this.handler == verificationToken;
    }

    @Override
    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, IActionSource source) {
        try {
            if (this.getProxy().isActive()) {
                this.getProxy().getStorage().postAlterationOfStoredItems(Api.instance().storage().getStorageChannel(IFluidStorageChannel.class), change, this.source);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public MEInventoryHandler<IAEFluidStack> getInternalHandler() {
        if (this.cached) {
            return this.handler;
        }
        boolean wasSleeping = this.monitor == null;
        this.cached = true;
        class_2586 self = this.getHost().getTile();
        class_2586 target = self.method_10997().method_8321(self.method_11016().method_10093(this.getSide().getFacing()));
        int newHandlerHash = this.createHandlerHash(target);
        if (newHandlerHash != 0 && newHandlerHash == this.handlerHash) {
            return this.handler;
        }
        this.handlerHash = newHandlerHash;
        this.handler = null;
        this.monitor = null;
        if (target != null) {
            IMEInventory<IAEFluidStack> inv = this.getInventoryWrapper(target);
            if (inv instanceof ITickingMonitor) {
                this.monitor = (ITickingMonitor)((Object)inv);
                this.monitor.setActionSource(new MachineSource(this));
            }
            if (inv != null) {
                this.checkInterfaceVsStorageBus(target, this.getSide().getOpposite());
                this.handler = new MEInventoryHandler<IAEFluidStack>(inv, Api.instance().storage().getStorageChannel(IFluidStorageChannel.class));
                this.handler.setBaseAccess((AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS));
                this.handler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
                this.handler.setPriority(this.getPriority());
                IItemList<IAEFluidStack> priorityList = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
                int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
                for (int x = 0; x < this.config.getSlots() && x < slotsToUse; ++x) {
                    IAEFluidStack is = this.config.getFluidInSlot(x);
                    if (is == null) continue;
                    priorityList.add(is);
                }
                if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
                    this.handler.setPartitionList(new FuzzyPriorityList(priorityList, (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE)));
                } else {
                    this.handler.setPartitionList(new PrecisePriorityList(priorityList));
                }
                if (inv instanceof IBaseMonitor) {
                    ((IBaseMonitor)((Object)inv)).addListener(this, this.handler);
                }
            }
        }
        if (wasSleeping != (this.monitor == null)) {
            try {
                ITickManager tm = this.getProxy().getTick();
                if (this.monitor == null) {
                    tm.sleepDevice(this.getProxy().getNode());
                } else {
                    tm.wakeDevice(this.getProxy().getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return this.handler;
    }

    private void checkInterfaceVsStorageBus(class_2586 target, AEPartLocation side) {
        IPart part;
        IInterfaceHost achievement = null;
        if (target instanceof IInterfaceHost) {
            achievement = (IInterfaceHost)target;
        }
        if (target instanceof IPartHost && (part = ((IPartHost)target).getPart(side)) instanceof IInterfaceHost) {
            achievement = (IInterfaceHost)((Object)part);
        }
        if (achievement == null || achievement.getActionableNode() != null) {
            // empty if block
        }
    }

    @Override
    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (channel == this.getStorageChannel()) {
            MEInventoryHandler<IAEFluidStack> out;
            MEInventoryHandler<IAEFluidStack> mEInventoryHandler = out = this.getProxy().isActive() ? this.getInternalHandler() : null;
            if (out != null) {
                return Collections.singletonList(out);
            }
        }
        return super.getCellArray(channel);
    }

    private int createHandlerHash(class_2586 target) {
        if (target == null) {
            return 0;
        }
        IStorageMonitorableAccessor accessor = MEAttributes.getAttributeInFrontOfPart(MEAttributes.STORAGE_MONITORABLE_ACCESSOR, this);
        if (accessor != null) {
            return Objects.hash(target, accessor);
        }
        GroupedFluidInv groupedInv = (GroupedFluidInv)MEAttributes.getAttributeInFrontOfPart(FluidAttributes.GROUPED_INV, this);
        if (groupedInv != null) {
            return Objects.hash(target, groupedInv);
        }
        return 0;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.FluidStorageBus.getMin(), TickRates.FluidStorageBus.getMax(), this.isSleeping(), true);
    }

    @Override
    public void onListUpdate() {
    }

    @Override
    public IStorageChannel getStorageChannel() {
        return Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    public IAEFluidTank getConfig() {
        return this.config;
    }

    @Override
    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Override
    public class_1799 getItemStackRepresentation() {
        return Api.instance().definitions().parts().fluidStorageBus().maybeStack(1).orElse(class_1799.field_8037);
    }

    @Override
    public class_3917<?> getContainerType() {
        return FluidStorageBusContainer.TYPE;
    }
}

