/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.util;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidInvTankChangeListener;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.storage.data.IAEFluidStack;
import appeng.core.AELog;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import appeng.util.Platform;
import java.math.RoundingMode;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class AEFluidInventory
implements IAEFluidTank {
    private static final IAEFluidStack EMPTY_AE_FLUIDSTACK = null;
    private final IAEFluidStack[] fluids;
    private final IAEFluidInventory handler;
    private final int capacity;

    public AEFluidInventory(IAEFluidInventory handler, int slots, int capacity) {
        this.fluids = new IAEFluidStack[slots];
        this.handler = handler;
        this.capacity = capacity;
    }

    public AEFluidInventory(IAEFluidInventory handler, int slots) {
        this(handler, slots, Integer.MAX_VALUE);
    }

    public boolean setInvFluid(int tank, FluidVolume to, Simulation simulation) {
        if (tank >= 0 && tank < this.getSlots()) {
            if (simulation == Simulation.ACTION) {
                this.setFluidInSlot(tank, AEFluidStack.fromFluidVolume(to, RoundingMode.DOWN));
            }
            return true;
        }
        return false;
    }

    @Override
    public void setFluidInSlot(int slot, IAEFluidStack fluid) {
        if (slot >= 0 && slot < this.getSlots()) {
            if (Objects.equals(this.fluids[slot], fluid)) {
                if (fluid != EMPTY_AE_FLUIDSTACK && fluid.getStackSize() != this.fluids[slot].getStackSize()) {
                    this.fluids[slot].setStackSize(Math.min(fluid.getStackSize(), (long)this.capacity));
                    this.onContentChanged(slot);
                }
            } else {
                if (fluid == EMPTY_AE_FLUIDSTACK) {
                    this.fluids[slot] = EMPTY_AE_FLUIDSTACK;
                } else {
                    this.fluids[slot] = fluid.copy();
                    this.fluids[slot].setStackSize(Math.min(fluid.getStackSize(), (long)this.capacity));
                }
                this.onContentChanged(slot);
            }
        }
    }

    private void onContentChanged(int slot) {
        if (this.handler != null && Platform.isServer()) {
            this.handler.onFluidInventoryChanged(this, slot);
        }
    }

    @Override
    public IAEFluidStack getFluidInSlot(int slot) {
        if (slot >= 0 && slot < this.getSlots()) {
            return this.fluids[slot];
        }
        return EMPTY_AE_FLUIDSTACK;
    }

    @Override
    public int getSlots() {
        return this.fluids.length;
    }

    public int getTankCount() {
        return this.fluids.length;
    }

    public FluidAmount getMaxAmount_F(int tank) {
        return FluidAmount.of((long)Math.min(this.capacity, Integer.MAX_VALUE), (long)1000L);
    }

    public FluidVolume getInvFluid(int tank) {
        if (tank < 0 || tank >= this.fluids.length) {
            return FluidVolumeUtil.EMPTY;
        }
        return this.fluids[tank] == EMPTY_AE_FLUIDSTACK ? FluidVolumeUtil.EMPTY : this.fluids[tank].getFluidStack();
    }

    public boolean isFluidValidForTank(int tank, FluidKey fluid) {
        return !fluid.isEmpty();
    }

    public ListenerToken addListener(FluidInvTankChangeListener listener, ListenerRemovalToken removalToken) {
        return null;
    }

    public int fill(int slot, FluidVolume resource, boolean doFill) {
        if (resource.isEmpty() || resource.getAmount() <= 0) {
            return 0;
        }
        IAEFluidStack fluid = this.fluids[slot];
        if (fluid != EMPTY_AE_FLUIDSTACK && !FluidVolume.areEqualExceptAmounts((FluidVolume)fluid.getFluidStack(), (FluidVolume)resource)) {
            return 0;
        }
        int amountToStore = this.capacity;
        if (fluid != EMPTY_AE_FLUIDSTACK) {
            amountToStore = (int)((long)amountToStore - fluid.getStackSize());
        }
        amountToStore = Math.min(amountToStore, (int)resource.getAmount_F().asLong(1000L, RoundingMode.DOWN));
        if (doFill) {
            if (fluid == null) {
                this.setFluidInSlot(slot, AEFluidStack.fromFluidVolume(resource, RoundingMode.DOWN));
            } else {
                fluid.setStackSize(fluid.getStackSize() + (long)amountToStore);
                this.onContentChanged(slot);
            }
        }
        return amountToStore;
    }

    public FluidAmount drain(int slot, FluidVolume resource, boolean doDrain) {
        IAEFluidStack fluid = this.fluids[slot];
        if (resource.isEmpty() || fluid == EMPTY_AE_FLUIDSTACK || !FluidVolume.areEqualExceptAmounts((FluidVolume)fluid.getFluidStack(), (FluidVolume)resource)) {
            return FluidAmount.ZERO;
        }
        int toDrain = (int)resource.getAmount_F().asLong(1000L, RoundingMode.DOWN);
        return this.drain(slot, toDrain, doDrain);
    }

    public FluidAmount drain(int slot, int maxDrain, boolean doDrain) {
        IAEFluidStack fluid = this.fluids[slot];
        if (fluid == EMPTY_AE_FLUIDSTACK || maxDrain <= 0) {
            return FluidAmount.ZERO;
        }
        int drained = maxDrain;
        if (fluid.getStackSize() < (long)drained) {
            drained = (int)fluid.getStackSize();
        }
        FluidAmount amount = FluidAmount.of((long)drained, (long)1000L);
        if (doDrain) {
            fluid.setStackSize(fluid.getStackSize() - (long)drained);
            if (fluid.getStackSize() <= 0L) {
                this.fluids[slot] = EMPTY_AE_FLUIDSTACK;
            }
            this.onContentChanged(slot);
        }
        return amount;
    }

    public void writeToNBT(class_2487 data, String name) {
        class_2487 c = new class_2487();
        this.writeToNBT(c);
        data.method_10566(name, (class_2520)c);
    }

    private void writeToNBT(class_2487 target) {
        for (int x = 0; x < this.fluids.length; ++x) {
            try {
                class_2487 c = new class_2487();
                if (this.fluids[x] != EMPTY_AE_FLUIDSTACK) {
                    this.fluids[x].writeToNBT(c);
                }
                target.method_10566("#" + x, (class_2520)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(class_2487 data, String name) {
        class_2487 c = data.method_10562(name);
        if (!c.isEmpty()) {
            this.readFromNBT(c);
        }
    }

    private void readFromNBT(class_2487 target) {
        for (int x = 0; x < this.fluids.length; ++x) {
            try {
                class_2487 c = target.method_10562("#" + x);
                if (c.isEmpty()) continue;
                this.fluids[x] = AEFluidStack.fromNBT(c);
                continue;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }
}

