/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.util;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.core.Api;
import appeng.fluids.items.FluidDummyItem;
import appeng.util.item.AEStack;
import com.google.common.base.Preconditions;
import java.math.RoundingMode;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public final class AEFluidStack
extends AEStack<IAEFluidStack>
implements IAEFluidStack,
Comparable<AEFluidStack> {
    private static final String NBT_STACKSIZE = "cnt";
    private static final String NBT_REQUESTABLE = "req";
    private static final String NBT_CRAFTABLE = "craft";
    private static final String NBT_FLUID_ID = "f";
    private final FluidKey fluid;

    private AEFluidStack(AEFluidStack fluidStack) {
        this.fluid = fluidStack.fluid;
        this.setStackSize(fluidStack.getStackSize());
        this.setCraftable(fluidStack.isCraftable());
        this.setCountRequestable(fluidStack.getCountRequestable());
    }

    private AEFluidStack(@Nonnull FluidKey fluid, long amount) {
        this.fluid = (FluidKey)Preconditions.checkNotNull((Object)fluid);
        this.setStackSize(amount);
        this.setCraftable(false);
        this.setCountRequestable(0L);
    }

    public static AEFluidStack fromFluidVolume(FluidVolume input, RoundingMode roundingMode) {
        if (input.isEmpty()) {
            return null;
        }
        FluidKey fluid = input.getFluidKey();
        if (fluid == null) {
            throw new IllegalArgumentException("Fluid is null.");
        }
        long amount = input.amount().asLong(1000L, roundingMode);
        return new AEFluidStack(fluid, amount);
    }

    public static IAEFluidStack fromNBT(class_2487 data) {
        class_2487 fluidId = data.method_10562(NBT_FLUID_ID);
        FluidKey fluid = FluidKey.fromTag((class_2487)fluidId);
        if (fluid == FluidKeys.EMPTY) {
            return null;
        }
        long amount = data.method_10537(NBT_STACKSIZE);
        AEFluidStack fluidStack = new AEFluidStack(fluid, amount);
        fluidStack.setCountRequestable(data.method_10537(NBT_REQUESTABLE));
        fluidStack.setCraftable(data.method_10577(NBT_CRAFTABLE));
        return fluidStack;
    }

    @Override
    public void add(IAEFluidStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    @Override
    public void writeToNBT(class_2487 data) {
        data.method_10566(NBT_FLUID_ID, (class_2520)this.fluid.toTag());
        data.method_10544(NBT_STACKSIZE, this.getStackSize());
        data.method_10544(NBT_REQUESTABLE, this.getCountRequestable());
        data.method_10556(NBT_CRAFTABLE, this.isCraftable());
    }

    @Override
    public boolean fuzzyComparison(IAEFluidStack other, FuzzyMode mode) {
        return this.fluid == other.getFluid();
    }

    @Override
    public IAEFluidStack copy() {
        return new AEFluidStack(this);
    }

    @Override
    public IAEFluidStack empty() {
        IAEFluidStack dup = this.copy();
        dup.reset();
        return dup;
    }

    @Override
    public IStorageChannel<IAEFluidStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public int compareTo(AEFluidStack other) {
        if (this.fluid != other.fluid) {
            return this.fluid.entry.getId().method_12833(other.fluid.entry.getId());
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fluid == null ? 0 : this.fluid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AEFluidStack) {
            AEFluidStack is = (AEFluidStack)other;
            return is.fluid == this.fluid;
        }
        if (other instanceof FluidVolume) {
            FluidVolume is = (FluidVolume)other;
            return is.getFluidKey() == this.fluid;
        }
        return false;
    }

    public String toString() {
        return this.getStackSize() + "x" + this.getFluidStack().getFluidKey().entry.getId();
    }

    @Override
    public boolean hasTagCompound() {
        return false;
    }

    @Override
    public FluidVolume getFluidStack() {
        FluidAmount amount = FluidAmount.of((long)this.getStackSize(), (long)1000L);
        return this.fluid.withAmount(amount);
    }

    @Override
    public FluidAmount getAmount() {
        return FluidAmount.of((long)this.getStackSize(), (long)1000L);
    }

    @Override
    public FluidKey getFluid() {
        return this.fluid;
    }

    @Override
    public class_1799 asItemStackRepresentation() {
        class_1799 is = Api.instance().definitions().items().dummyFluidItem().maybeStack(1).orElse(class_1799.field_8037);
        if (!is.method_7960()) {
            FluidDummyItem item = (FluidDummyItem)is.method_7909();
            item.setFluidStack(is, this.getFluidStack());
            return is;
        }
        return class_1799.field_8037;
    }

    public static IAEFluidStack fromPacket(class_2540 buffer) {
        boolean isCraftable = buffer.readBoolean();
        FluidKey fluid = FluidKey.fromTag((class_2487)buffer.method_10798());
        long amount = buffer.method_10792();
        long countRequestable = buffer.method_10792();
        AEFluidStack fluidStack = new AEFluidStack(fluid, amount);
        fluidStack.setCountRequestable(countRequestable);
        fluidStack.setCraftable(isCraftable);
        return fluidStack;
    }

    @Override
    public void writeToPacket(class_2540 buffer) {
        buffer.writeBoolean(this.isCraftable());
        buffer.method_10794(this.fluid.toTag());
        buffer.method_10791(this.getStackSize());
        buffer.method_10791(this.getCountRequestable());
    }
}

