/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerNull;
import appeng.core.Api;
import appeng.items.misc.EncodedPatternItem;
import appeng.mixins.IngredientAccessor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3956;

public class CraftingPatternDetails
implements ICraftingPatternDetails,
Comparable<CraftingPatternDetails> {
    private static final int CRAFTING_GRID_DIMENSION = 3;
    private static final int ALL_INPUT_LIMIT = 9;
    private static final int CRAFTING_OUTPUT_LIMIT = 1;
    private static final int PROCESSING_OUTPUT_LIMIT = 3;
    private static final Comparator<IAEItemStack> COMPARE_BY_STACKSIZE = (left, right) -> Long.compare(right.getStackSize(), left.getStackSize());
    private final class_1715 crafting = new class_1715((class_1703)new ContainerNull(), 3, 3);
    private final class_1715 testFrame = new class_1715((class_1703)new ContainerNull(), 3, 3);
    private final class_1799 correctOutput;
    private final class_3955 standardRecipe;
    private final List<IAEItemStack> inputs;
    private final List<IAEItemStack> outputs;
    private final IAEItemStack[] sparseInputs;
    private final IAEItemStack[] sparseOutputs;
    private final Map<Integer, List<IAEItemStack>> substituteInputs;
    private final boolean isCraftable;
    private final boolean canSubstitute;
    private final Set<TestLookup> failCache = new HashSet<TestLookup>();
    private final Set<TestLookup> passCache = new HashSet<TestLookup>();
    private final IAEItemStack pattern;
    private int priority = 0;

    public CraftingPatternDetails(IAEItemStack is, class_1937 w) {
        IAEItemStack ais;
        int x;
        Preconditions.checkArgument((boolean)(is.getItem() instanceof EncodedPatternItem), (Object)"itemStack is not a ICraftingPatternItem");
        EncodedPatternItem templateItem = (EncodedPatternItem)is.getItem();
        class_1799 itemStack = is.createItemStack();
        List<IAEItemStack> ingredients = templateItem.getIngredients(itemStack);
        List<IAEItemStack> products = templateItem.getProducts(itemStack);
        class_2960 recipeId = templateItem.getCraftingRecipeId(itemStack);
        this.pattern = is.copy();
        this.isCraftable = recipeId != null;
        this.canSubstitute = templateItem.allowsSubstitution(itemStack);
        ArrayList<IAEItemStack> in = new ArrayList<IAEItemStack>();
        ArrayList<IAEItemStack> out = new ArrayList<IAEItemStack>();
        for (x = 0; x < 9; ++x) {
            ais = ingredients.get(x);
            class_1799 gs = ais != null ? ais.createItemStack() : class_1799.field_8037;
            this.crafting.method_5447(x, gs);
            if (!gs.method_7960() && !this.isCraftable || !gs.method_7985()) {
                this.markItemAs(x, gs, TestStatus.ACCEPT);
            }
            in.add(ais != null ? ais.copy() : null);
            this.testFrame.method_5447(x, gs);
        }
        if (this.isCraftable) {
            class_1860 recipe = (class_1860)w.method_8433().method_17717(class_3956.field_17545).get(recipeId);
            if (recipe == null || recipe.method_17716() != class_3956.field_17545) {
                throw new IllegalStateException("recipe id is not a crafting recipe");
            }
            this.standardRecipe = (class_3955)recipe;
            this.correctOutput = this.standardRecipe.method_8116((class_1263)this.crafting);
            out.add((IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(this.correctOutput));
        } else {
            this.standardRecipe = null;
            this.correctOutput = class_1799.field_8037;
            for (x = 0; x < 3; ++x) {
                ais = products.get(x);
                out.add(ais != null ? ais.copy() : null);
            }
        }
        int outputLength = this.isCraftable ? 1 : 3;
        this.sparseInputs = in.toArray(new IAEItemStack[9]);
        this.sparseOutputs = out.toArray(new IAEItemStack[outputLength]);
        this.substituteInputs = new HashMap<Integer, List<IAEItemStack>>(9);
        this.inputs = this.condenseStacks(in);
        this.outputs = this.condenseStacks(out);
    }

    private void markItemAs(int slotIndex, class_1799 i, TestStatus b) {
        if (b == TestStatus.TEST || i.method_7985()) {
            return;
        }
        (b == TestStatus.ACCEPT ? this.passCache : this.failCache).add(new TestLookup(slotIndex, i));
    }

    @Override
    public class_1799 getPattern() {
        return this.pattern.createItemStack();
    }

    @Override
    public synchronized boolean isValidItemForSlot(int slotIndex, class_1799 i, class_1937 w) {
        if (!this.isCraftable) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }
        TestStatus result = this.getStatus(slotIndex, i);
        switch (result) {
            case ACCEPT: {
                return true;
            }
            case DECLINE: {
                return false;
            }
        }
        for (int x = 0; x < this.crafting.method_5439(); ++x) {
            this.testFrame.method_5447(x, this.crafting.method_5438(x));
        }
        this.testFrame.method_5447(slotIndex, i);
        if (!this.canSubstitute && slotIndex < this.sparseInputs.length && !this.sparseInputs[slotIndex].isSameType(i)) {
            this.markItemAs(slotIndex, i, TestStatus.DECLINE);
            return false;
        }
        if (this.standardRecipe.method_8115((class_1263)this.testFrame, w)) {
            class_1799 testOutput = this.standardRecipe.method_8116((class_1263)this.testFrame);
            if (Platform.itemComparisons().isSameItem(this.correctOutput, testOutput)) {
                this.testFrame.method_5447(slotIndex, this.crafting.method_5438(slotIndex));
                this.markItemAs(slotIndex, i, TestStatus.ACCEPT);
                return true;
            }
        }
        this.markItemAs(slotIndex, i, TestStatus.DECLINE);
        return false;
    }

    @Override
    public boolean isCraftable() {
        return this.isCraftable;
    }

    @Override
    public IAEItemStack[] getSparseInputs() {
        return this.sparseInputs;
    }

    @Override
    public List<IAEItemStack> getInputs() {
        return this.inputs;
    }

    @Override
    public List<IAEItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public IAEItemStack[] getSparseOutputs() {
        return this.sparseOutputs;
    }

    @Override
    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    @Override
    public List<IAEItemStack> getSubstituteInputs(int slot) {
        if (this.sparseInputs[slot] == null) {
            return Collections.emptyList();
        }
        return this.substituteInputs.computeIfAbsent(slot, value -> {
            class_1799[] matchingStacks = ((IngredientAccessor)this.getRecipeIngredient(slot)).getMatchingStacks();
            ArrayList<IAEItemStack> itemList = new ArrayList<IAEItemStack>(matchingStacks.length + 1);
            for (class_1799 matchingStack : matchingStacks) {
                itemList.add(AEItemStack.fromItemStack(matchingStack));
            }
            itemList.add(0, this.sparseInputs[slot]);
            return itemList;
        });
    }

    private class_1856 getRecipeIngredient(int slot) {
        if (this.standardRecipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)this.standardRecipe;
            return this.getShapedRecipeIngredient(slot, shapedRecipe.method_8150());
        }
        return this.getShapelessRecipeIngredient(slot);
    }

    private class_1856 getShapedRecipeIngredient(int slot, int recipeWidth) {
        int topOffset = 0;
        if (this.sparseInputs[0] == null && this.sparseInputs[1] == null && this.sparseInputs[2] == null) {
            ++topOffset;
            if (this.sparseInputs[3] == null && this.sparseInputs[4] == null && this.sparseInputs[5] == null) {
                ++topOffset;
            }
        }
        int leftOffset = 0;
        if (this.sparseInputs[0] == null && this.sparseInputs[3] == null && this.sparseInputs[6] == null) {
            ++leftOffset;
            if (this.sparseInputs[1] == null && this.sparseInputs[4] == null && this.sparseInputs[7] == null) {
                ++leftOffset;
            }
        }
        int slotX = slot % 3 - leftOffset;
        int slotY = slot / 3 - topOffset;
        int ingredientIndex = slotY * recipeWidth + slotX;
        class_2371 ingredients = this.standardRecipe.method_8117();
        if (ingredientIndex < 0 || ingredientIndex > ingredients.size()) {
            return class_1856.field_9017;
        }
        return (class_1856)ingredients.get(ingredientIndex);
    }

    private class_1856 getShapelessRecipeIngredient(int slot) {
        int ingredientIndex = 0;
        for (int i = 0; i < slot; ++i) {
            if (this.sparseInputs[i] == null) continue;
            ++ingredientIndex;
        }
        class_2371 ingredients = this.standardRecipe.method_8117();
        if (ingredientIndex < ingredients.size()) {
            return (class_1856)ingredients.get(ingredientIndex);
        }
        return class_1856.field_9017;
    }

    @Override
    public class_1799 getOutput(class_1715 craftingInv, class_1937 w) {
        if (!this.isCraftable) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }
        for (int x = 0; x < craftingInv.method_5439(); ++x) {
            if (this.isValidItemForSlot(x, craftingInv.method_5438(x), w)) continue;
            return class_1799.field_8037;
        }
        if (this.sparseOutputs != null && this.sparseOutputs.length > 0) {
            return this.sparseOutputs[0].createItemStack();
        }
        return class_1799.field_8037;
    }

    private TestStatus getStatus(int slotIndex, class_1799 i) {
        if (this.crafting.method_5438(slotIndex).method_7960()) {
            return i.method_7960() ? TestStatus.ACCEPT : TestStatus.DECLINE;
        }
        if (i.method_7960()) {
            return TestStatus.DECLINE;
        }
        if (i.method_7985()) {
            return TestStatus.TEST;
        }
        if (this.passCache.contains(new TestLookup(slotIndex, i))) {
            return TestStatus.ACCEPT;
        }
        if (this.failCache.contains(new TestLookup(slotIndex, i))) {
            return TestStatus.DECLINE;
        }
        return TestStatus.TEST;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(CraftingPatternDetails o) {
        return Integer.compare(o.priority, this.priority);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftingPatternDetails other = (CraftingPatternDetails)obj;
        if (this.pattern != null && other.pattern != null) {
            return this.pattern.equals(other.pattern);
        }
        return false;
    }

    private List<IAEItemStack> condenseStacks(Collection<IAEItemStack> collection) {
        List merged = (List)collection.stream().filter(Objects::nonNull).collect(Collectors.toMap(Function.identity(), IAEItemStack::copy, (left, right) -> (IAEItemStack)left.setStackSize(left.getStackSize() + right.getStackSize()))).values().stream().sorted(COMPARE_BY_STACKSIZE).collect(ImmutableList.toImmutableList());
        if (merged.isEmpty()) {
            throw new IllegalStateException("No pattern here!");
        }
        return merged;
    }

    private static final class TestLookup {
        private final int slot;
        private final int ref;
        private final int hash;

        public TestLookup(int slot, class_1799 i) {
            this(slot, i.method_7909(), i.method_7919());
        }

        public TestLookup(int slot, class_1792 item, int dmg) {
            this.slot = slot;
            this.ref = dmg << 16 | class_1792.method_7880((class_1792)item) & 0xFFFF;
            int offset = 3 * slot;
            this.hash = this.ref << offset | this.ref >> offset + 32;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            boolean equality;
            if (obj instanceof TestLookup) {
                TestLookup b = (TestLookup)obj;
                equality = b.slot == this.slot && b.ref == this.ref;
            } else {
                equality = false;
            }
            return equality;
        }
    }

    private static enum TestStatus {
        ACCEPT,
        DECLINE,
        TEST;

    }
}

