/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.Api;
import appeng.core.settings.TickRates;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.MultiCraftingTracker;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.MEMonitorIInventory;
import appeng.me.storage.MEMonitorPassThrough;
import appeng.me.storage.NullInventory;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorFixedInv;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;

public class DualityInterface
implements IGridTickable,
IStorageMonitorable,
IInventoryDestination,
IAEAppEngInventory,
IConfigManagerHost,
ICraftingProvider,
IUpgradeableHost {
    public static final int NUMBER_OF_STORAGE_SLOTS = 9;
    public static final int NUMBER_OF_CONFIG_SLOTS = 9;
    public static final int NUMBER_OF_PATTERN_SLOTS = 9;
    private static final Collection<class_2248> BAD_BLOCKS = new HashSet<class_2248>(100);
    private final IAEItemStack[] requireWork = new IAEItemStack[]{null, null, null, null, null, null, null, null, null};
    private final MultiCraftingTracker craftingTracker;
    private final AENetworkProxy gridProxy;
    private final IInterfaceHost iHost;
    private final IActionSource mySource;
    private final IActionSource interfaceRequestSource;
    private final ConfigManager cm = new ConfigManager(this);
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 9);
    private final AppEngInternalInventory storage = new AppEngInternalInventory(this, 9);
    private final AppEngInternalInventory patterns = new AppEngInternalInventory(this, 9);
    private final MEMonitorPassThrough<IAEItemStack> items = new MEMonitorPassThrough(new NullInventory(), Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
    private final MEMonitorPassThrough<IAEFluidStack> fluids = new MEMonitorPassThrough(new NullInventory(), Api.instance().storage().getStorageChannel(IFluidStorageChannel.class));
    private final UpgradeInventory upgrades;
    private boolean hasConfig = false;
    private int priority;
    private List<ICraftingPatternDetails> craftingList = null;
    private List<class_1799> waitingToSend = null;
    private IMEInventory<IAEItemStack> destination;
    private int isWorking = -1;
    private final Accessor accessor = new Accessor();

    public DualityInterface(AENetworkProxy networkProxy, IInterfaceHost ih) {
        this.gridProxy = networkProxy;
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.upgrades = new StackUpgradeInventory(this.gridProxy.getMachineRepresentation(), this, 1);
        this.cm.registerSetting(Settings.BLOCK, (Enum)YesNo.NO);
        this.cm.registerSetting(Settings.INTERFACE_TERMINAL, (Enum)YesNo.YES);
        this.iHost = ih;
        this.craftingTracker = new MultiCraftingTracker(this.iHost, 9);
        MachineSource actionSource = new MachineSource(this.iHost);
        this.mySource = actionSource;
        this.fluids.setChangeSource(actionSource);
        this.items.setChangeSource(actionSource);
        this.interfaceRequestSource = new InterfaceRequestSource(this.iHost);
    }

    @Override
    public void saveChanges() {
        this.iHost.saveChanges();
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
        if (this.isWorking == slot) {
            return;
        }
        if (inv == this.config) {
            this.readConfig();
        } else if (!(inv != this.patterns || removed.method_7960() && added.method_7960())) {
            this.updateCraftingList();
        } else if (inv == this.storage && slot >= 0) {
            boolean had = this.hasWorkToDo();
            this.updatePlan(slot);
            boolean now = this.hasWorkToDo();
            if (had != now) {
                try {
                    if (now) {
                        this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                    } else {
                        this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public void writeToNBT(class_2487 data) {
        this.config.writeToNBT(data, "config");
        this.patterns.writeToNBT(data, "patterns");
        this.storage.writeToNBT(data, "storage");
        this.upgrades.writeToNBT(data, "upgrades");
        this.cm.writeToNBT(data);
        this.craftingTracker.writeToNBT(data);
        data.method_10569("priority", this.priority);
        class_2499 waitingToSend = new class_2499();
        if (this.waitingToSend != null) {
            for (class_1799 is : this.waitingToSend) {
                class_2487 item = new class_2487();
                is.method_7953(item);
                waitingToSend.add((Object)item);
            }
        }
        data.method_10566("waitingToSend", (class_2520)waitingToSend);
    }

    public void readFromNBT(class_2487 data) {
        this.waitingToSend = null;
        class_2499 waitingList = data.method_10554("waitingToSend", 10);
        if (waitingList != null) {
            for (int x = 0; x < waitingList.size(); ++x) {
                class_2487 c = waitingList.method_10602(x);
                if (c == null) continue;
                class_1799 is = class_1799.method_7915((class_2487)c);
                this.addToSendList(is);
            }
        }
        this.craftingTracker.readFromNBT(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.config.readFromNBT(data, "config");
        this.patterns.readFromNBT(data, "patterns");
        this.storage.readFromNBT(data, "storage");
        this.priority = data.method_10550("priority");
        this.cm.readFromNBT(data);
        this.readConfig();
        this.updateCraftingList();
    }

    private void addToSendList(class_1799 is) {
        if (is.method_7960()) {
            return;
        }
        if (this.waitingToSend == null) {
            this.waitingToSend = new ArrayList<class_1799>();
        }
        this.waitingToSend.add(is);
        try {
            this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void readConfig() {
        this.hasConfig = false;
        for (class_1799 p : this.config) {
            if (p.method_7960()) continue;
            this.hasConfig = true;
            break;
        }
        boolean had = this.hasWorkToDo();
        for (int x = 0; x < 9; ++x) {
            this.updatePlan(x);
        }
        boolean has = this.hasWorkToDo();
        if (had != has) {
            try {
                if (has) {
                    this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                } else {
                    this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        this.notifyNeighbors();
    }

    private void updateCraftingList() {
        Boolean[] accountedFor = new Boolean[]{false, false, false, false, false, false, false, false, false};
        assert (accountedFor.length == this.patterns.getSlotCount());
        if (!this.gridProxy.isReady()) {
            return;
        }
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    class_1799 is = this.patterns.getInvStack(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (accountedFor[x].booleanValue()) continue;
            this.addToCraftingList(this.patterns.getInvStack(x));
        }
        try {
            this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private boolean hasWorkToDo() {
        if (this.hasItemsToSend()) {
            return true;
        }
        for (IAEItemStack requiredWork : this.requireWork) {
            if (requiredWork == null) continue;
            return true;
        }
        return false;
    }

    private void updatePlan(int slot) {
        IAEItemStack req = this.config.getAEStackInSlot(slot);
        if (req != null && req.getStackSize() <= 0L) {
            this.config.setInvStack(slot, class_1799.field_8037, Simulation.ACTION);
            req = null;
        }
        class_1799 stored = this.storage.getInvStack(slot);
        if (req == null && !stored.method_7960()) {
            IAEItemStack work = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(stored);
            this.requireWork[slot] = (IAEItemStack)work.setStackSize(-work.getStackSize());
            return;
        }
        if (req != null) {
            if (stored.method_7960()) {
                this.requireWork[slot] = req.copy();
                return;
            }
            if (req.isSameType(stored)) {
                if (req.getStackSize() != (long)stored.method_7947()) {
                    this.requireWork[slot] = req.copy();
                    this.requireWork[slot].setStackSize(req.getStackSize() - (long)stored.method_7947());
                    return;
                }
            } else {
                IAEItemStack work = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(stored);
                this.requireWork[slot] = (IAEItemStack)work.setStackSize(-work.getStackSize());
                return;
            }
        }
        this.requireWork[slot] = null;
    }

    public void notifyNeighbors() {
        class_2586 te;
        if (this.gridProxy.isActive()) {
            try {
                this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if ((te = this.iHost.getBlockEntity()) != null && te.method_10997() != null) {
            Platform.notifyBlocksOfNeighbors(te.method_10997(), te.method_11016());
        }
    }

    private void addToCraftingList(class_1799 is) {
        ICraftingPatternDetails details = Api.instance().crafting().decodePattern(is, this.iHost.getBlockEntity().method_10997());
        if (details != null) {
            if (this.craftingList == null) {
                this.craftingList = new ArrayList<ICraftingPatternDetails>();
            }
            this.craftingList.add(details);
        }
    }

    private boolean hasItemsToSend() {
        return this.waitingToSend != null && !this.waitingToSend.isEmpty();
    }

    @Override
    public boolean canInsert(class_1799 stack) {
        IAEItemStack out = this.destination.injectItems((IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(stack), Actionable.SIMULATE, null);
        if (out == null) {
            return true;
        }
        return out.getStackSize() != (long)stack.method_7947();
    }

    public FixedItemInv getConfig() {
        return this.config;
    }

    public FixedItemInv getPatterns() {
        return this.patterns;
    }

    public void gridChanged() {
        try {
            this.items.setInternal(this.gridProxy.getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class)));
            this.fluids.setInternal(this.gridProxy.getStorage().getInventory(Api.instance().storage().getStorageChannel(IFluidStorageChannel.class)));
        }
        catch (GridAccessException gae) {
            this.items.setInternal(new NullInventory());
            this.fluids.setInternal(new NullInventory());
        }
        this.notifyNeighbors();
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.iHost.getBlockEntity());
    }

    public FixedItemInv getInternalInventory() {
        return this.storage;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Interface.getMin(), TickRates.Interface.getMax(), !this.hasWorkToDo(), true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.gridProxy.isActive()) {
            return TickRateModulation.SLEEP;
        }
        if (this.hasItemsToSend()) {
            this.pushItemsOut(this.iHost.getTargets());
        }
        boolean couldDoWork = this.updateStorage();
        return this.hasWorkToDo() ? (couldDoWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER) : TickRateModulation.SLEEP;
    }

    private void pushItemsOut(EnumSet<class_2350> possibleDirections) {
        if (!this.hasItemsToSend()) {
            return;
        }
        class_2586 tile = this.iHost.getBlockEntity();
        class_1937 w = tile.method_10997();
        Iterator<class_1799> i = this.waitingToSend.iterator();
        while (i.hasNext()) {
            class_1799 whatToSend = i.next();
            for (class_2350 s : possibleDirections) {
                InventoryAdaptor ad;
                class_2586 te = w.method_8321(tile.method_11016().method_10093(s));
                if (te == null || (ad = InventoryAdaptor.getAdaptor(te, s.method_10153())) == null) continue;
                class_1799 result = ad.addItems(whatToSend);
                if (result.method_7960()) {
                    whatToSend = class_1799.field_8037;
                } else {
                    whatToSend.method_7939(whatToSend.method_7947() - (whatToSend.method_7947() - result.method_7947()));
                }
                if (!whatToSend.method_7960()) continue;
                break;
            }
            if (!whatToSend.method_7960()) continue;
            i.remove();
        }
        if (this.waitingToSend.isEmpty()) {
            this.waitingToSend = null;
        }
    }

    private boolean updateStorage() {
        boolean didSomething = false;
        for (int x = 0; x < 9; ++x) {
            if (this.requireWork[x] == null) continue;
            didSomething = this.usePlan(x, this.requireWork[x]) || didSomething;
        }
        return didSomething;
    }

    private boolean usePlan(int x, IAEItemStack itemStack) {
        InventoryAdaptor adaptor = this.getAdaptor(x);
        this.isWorking = x;
        boolean changed = false;
        try {
            this.destination = this.gridProxy.getStorage().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IEnergyGrid src = this.gridProxy.getEnergy();
            if (this.craftingTracker.isBusy(x)) {
                changed = this.handleCrafting(x, adaptor, itemStack) || changed;
            } else if (itemStack.getStackSize() > 0L) {
                if (!adaptor.simulateAdd(itemStack.createItemStack()).method_7960()) {
                    changed = true;
                    throw new GridAccessException();
                }
                IAEItemStack acquired = Platform.poweredExtraction(src, this.destination, itemStack, this.interfaceRequestSource);
                if (acquired != null) {
                    changed = true;
                    class_1799 issue = adaptor.addItems(acquired.createItemStack());
                    if (!issue.method_7960()) {
                        throw new IllegalStateException("bad attempt at managing inventory. ( addItems )");
                    }
                } else {
                    changed = this.handleCrafting(x, adaptor, itemStack) || changed;
                }
            } else if (itemStack.getStackSize() < 0L) {
                IAEItemStack toStore = itemStack.copy();
                toStore.setStackSize(-toStore.getStackSize());
                long diff = toStore.getStackSize();
                class_1799 canExtract = adaptor.simulateRemove((int)diff, toStore.getDefinition(), null);
                if (canExtract.method_7960() || (long)canExtract.method_7947() != diff) {
                    changed = true;
                    throw new GridAccessException();
                }
                if ((toStore = Platform.poweredInsert(src, this.destination, toStore, this.interfaceRequestSource)) != null) {
                    diff -= toStore.getStackSize();
                }
                if (diff != 0L) {
                    changed = true;
                    class_1799 removed = adaptor.removeItems((int)diff, class_1799.field_8037, null);
                    if (removed.method_7960()) {
                        throw new IllegalStateException("bad attempt at managing inventory. ( removeItems )");
                    }
                    if ((long)removed.method_7947() != diff) {
                        throw new IllegalStateException("bad attempt at managing inventory. ( removeItems )");
                    }
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (changed) {
            this.updatePlan(x);
        }
        this.isWorking = -1;
        return changed;
    }

    private InventoryAdaptor getAdaptor(int slot) {
        return new AdaptorFixedInv(this.storage.getSubInv(slot, slot + 1));
    }

    private boolean handleCrafting(int x, InventoryAdaptor d, IAEItemStack itemStack) {
        try {
            if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0 && itemStack != null) {
                return this.craftingTracker.handleCrafting(x, itemStack.getStackSize(), itemStack, d, this.iHost.getBlockEntity().method_10997(), this.gridProxy.getGrid(), this.gridProxy.getCrafting(), this.mySource);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        if (this.upgrades == null) {
            return 0;
        }
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    public class_2586 getTile() {
        return (class_2586)(this.iHost instanceof class_2586 ? this.iHost : null);
    }

    @Override
    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (channel == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            if (this.hasConfig()) {
                return new InterfaceInventory(this);
            }
            return this.items;
        }
        if (channel == Api.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
            if (this.hasConfig()) {
                return null;
            }
            return this.fluids;
        }
        return null;
    }

    private boolean hasConfig() {
        return this.hasConfig;
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        if (name.equals("storage")) {
            return this.storage;
        }
        if (name.equals("patterns")) {
            return this.patterns;
        }
        if (name.equals("config")) {
            return this.config;
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    public FixedItemInv getStorage() {
        return this.storage;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) == 0) {
            this.cancelCrafting();
        }
        this.iHost.saveChanges();
    }

    private void cancelCrafting() {
        this.craftingTracker.cancel();
    }

    public IStorageMonitorable getMonitorable(IActionSource src, IStorageMonitorable myInterface) {
        if (Platform.canAccess(this.gridProxy, src)) {
            return myInterface;
        }
        final DualityInterface di = this;
        return new IStorageMonitorable(){

            @Override
            public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
                if (channel == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                    return new InterfaceInventory(di);
                }
                return null;
            }
        };
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, class_1715 table) {
        if (this.hasItemsToSend() || !this.gridProxy.isActive() || !this.craftingList.contains(patternDetails)) {
            return false;
        }
        class_2586 tile = this.iHost.getBlockEntity();
        class_1937 w = tile.method_10997();
        EnumSet<class_2350> possibleDirections = this.iHost.getTargets();
        for (class_2350 s : possibleDirections) {
            ICraftingMachine cm;
            class_2586 te = w.method_8321(tile.method_11016().method_10093(s));
            if (te instanceof IInterfaceHost) {
                try {
                    if (((IInterfaceHost)te).getInterfaceDuality().sameGrid(this.gridProxy.getGrid())) {
                    }
                }
                catch (GridAccessException e) {}
                continue;
            }
            if (te instanceof ICraftingMachine && (cm = (ICraftingMachine)te).acceptsPlans()) {
                if (!cm.pushPattern(patternDetails, table, s.method_10153())) continue;
                return true;
            }
            InventoryAdaptor ad = InventoryAdaptor.getAdaptor(te, s.method_10153());
            if (ad == null || this.isBlocking() && !ad.simulateRemove(1, class_1799.field_8037, null).method_7960() || !this.acceptsItems(ad, table)) continue;
            for (int x = 0; x < table.method_5439(); ++x) {
                class_1799 is = table.method_5438(x);
                if (is.method_7960()) continue;
                class_1799 added = ad.addItems(is);
                this.addToSendList(added);
            }
            this.pushItemsOut(possibleDirections);
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        if (this.hasItemsToSend()) {
            return true;
        }
        boolean busy = false;
        if (this.isBlocking()) {
            EnumSet<class_2350> possibleDirections = this.iHost.getTargets();
            class_2586 tile = this.iHost.getBlockEntity();
            class_1937 w = tile.method_10997();
            boolean allAreBusy = true;
            for (class_2350 s : possibleDirections) {
                class_2586 te = w.method_8321(tile.method_11016().method_10093(s));
                InventoryAdaptor ad = InventoryAdaptor.getAdaptor(te, s.method_10153());
                if (ad == null || !ad.simulateRemove(1, class_1799.field_8037, null).method_7960()) continue;
                allAreBusy = false;
                break;
            }
            busy = allAreBusy;
        }
        return busy;
    }

    private boolean sameGrid(IGrid grid) throws GridAccessException {
        return grid == this.gridProxy.getGrid();
    }

    private boolean isBlocking() {
        return this.cm.getSetting(Settings.BLOCK) == YesNo.YES;
    }

    private boolean acceptsItems(InventoryAdaptor ad, class_1715 table) {
        for (int x = 0; x < table.method_5439(); ++x) {
            class_1799 is = table.method_5438(x);
            if (is.method_7960() || ad.simulateAdd(is.method_7972()).method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.gridProxy.isActive() && this.craftingList != null) {
            for (ICraftingPatternDetails details : this.craftingList) {
                details.setPriority(this.priority);
                craftingTracker.addCraftingOption(this, details);
            }
        }
    }

    public void addDrops(List<class_1799> drops) {
        if (this.waitingToSend != null) {
            for (class_1799 is : this.waitingToSend) {
                if (is.method_7960()) continue;
                drops.add(is);
            }
        }
        for (class_1799 is : this.upgrades) {
            if (is.method_7960()) continue;
            drops.add(is);
        }
        for (class_1799 is : this.storage) {
            if (is.method_7960()) continue;
            drops.add(is);
        }
        for (class_1799 is : this.patterns) {
            if (is.method_7960()) continue;
            drops.add(is);
        }
    }

    public IUpgradeableHost getHost() {
        if (this.getPart() instanceof IUpgradeableHost) {
            return (IUpgradeableHost)((Object)this.getPart());
        }
        if (this.getTile() instanceof IUpgradeableHost) {
            return (IUpgradeableHost)this.getTile();
        }
        return null;
    }

    private IPart getPart() {
        return (IPart)((Object)(this.iHost instanceof IPart ? this.iHost : null));
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack acquired, Actionable mode) {
        int slot = this.craftingTracker.getSlot(link);
        if (acquired != null && slot >= 0 && slot <= this.requireWork.length) {
            InventoryAdaptor adaptor = this.getAdaptor(slot);
            if (mode == Actionable.SIMULATE) {
                return AEItemStack.fromItemStack(adaptor.simulateAdd(acquired.createItemStack()));
            }
            AEItemStack is = AEItemStack.fromItemStack(adaptor.addItems(acquired.createItemStack()));
            this.updatePlan(slot);
            return is;
        }
        return acquired;
    }

    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public class_2561 getTermName() {
        class_2248 directedBlock;
        class_2586 hostTile = this.iHost.getBlockEntity();
        class_1937 hostWorld = hostTile.method_10997();
        if (((ICustomNameObject)((Object)this.iHost)).hasCustomInventoryName()) {
            return ((ICustomNameObject)((Object)this.iHost)).getCustomInventoryName();
        }
        EnumSet<class_2350> possibleDirections = this.iHost.getTargets();
        Iterator iterator = possibleDirections.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return new class_2585("Nothing");
            }
            class_2350 direction = (class_2350)iterator.next();
            class_2338 targ = hostTile.method_11016().method_10093(direction);
            class_2586 directedTile = hostWorld.method_8321(targ);
            if (directedTile == null) continue;
            if (directedTile instanceof IInterfaceHost) {
                try {
                    if (((IInterfaceHost)directedTile).getInterfaceDuality().sameGrid(this.gridProxy.getGrid())) {
                    }
                }
                catch (GridAccessException e) {}
                continue;
            }
            InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(directedTile, direction.method_10153());
            if (!(directedTile instanceof ICraftingMachine) && adaptor == null || adaptor != null && !adaptor.hasSlots()) continue;
            class_2680 directedBlockState = hostWorld.method_8320(targ);
            directedBlock = directedBlockState.method_26204();
            class_1799 what = new class_1799((class_1935)directedBlock, 1);
            try {
                class_243 from = new class_243((double)hostTile.method_11016().method_10263() + 0.5, (double)hostTile.method_11016().method_10264() + 0.5, (double)hostTile.method_11016().method_10260() + 0.5);
                from = from.method_1031((double)direction.method_10148() * 0.501, (double)direction.method_10164() * 0.501, (double)direction.method_10165() * 0.501);
                class_243 to = from.method_1031((double)direction.method_10148(), (double)direction.method_10164(), (double)direction.method_10165());
                Object hit = null;
                if (hit != null && !BAD_BLOCKS.contains(directedBlock) && !hit.method_17777().equals((Object)directedTile.method_11016())) {
                    // empty if block
                }
            }
            catch (Throwable t) {
                BAD_BLOCKS.add(directedBlock);
            }
            if (what.method_7909() != class_1802.field_8162) {
                return new class_2588(what.method_7922());
            }
            class_1792 item = class_1792.method_7867((class_2248)directedBlock);
            if (item == class_1802.field_8162) break;
        }
        return new class_2588(directedBlock.method_9539());
    }

    public long getSortValue() {
        class_2586 te = this.iHost.getBlockEntity();
        return te.method_11016().method_10260() << 24 ^ te.method_11016().method_10263() << 8 ^ te.method_11016().method_10264();
    }

    public void initialize() {
        this.updateCraftingList();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.iHost.saveChanges();
        try {
            this.gridProxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.gridProxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void addAllAttributes(AttributeList<?> to) {
        to.offer((Object)this.storage);
        to.offer((Object)this.accessor);
    }

    private class Accessor
    implements IStorageMonitorableAccessor {
        private Accessor() {
        }

        @Override
        @Nullable
        public IStorageMonitorable getInventory(IActionSource src) {
            return DualityInterface.this.getMonitorable(src, DualityInterface.this);
        }
    }

    private class InterfaceInventory
    extends MEMonitorIInventory {
        public InterfaceInventory(DualityInterface tileInterface) {
            super(new AdaptorFixedInv((FixedItemInv)tileInterface.storage));
            this.setActionSource(new MachineSource(DualityInterface.this.iHost));
        }

        @Override
        public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
            Optional<InterfaceRequestContext> context = src.context(InterfaceRequestContext.class);
            boolean isInterface = context.isPresent();
            if (isInterface) {
                return input;
            }
            return super.injectItems(input, type, src);
        }

        @Override
        public IAEItemStack extractItems(IAEItemStack request, Actionable type, IActionSource src) {
            Optional<InterfaceRequestContext> context = src.context(InterfaceRequestContext.class);
            boolean hasLowerOrEqualPriority = context.map(c -> c.compareTo(DualityInterface.this.priority) <= 0).orElse(false);
            if (hasLowerOrEqualPriority) {
                return null;
            }
            return super.extractItems(request, type, src);
        }
    }

    private class InterfaceRequestContext
    implements Comparable<Integer> {
        private InterfaceRequestContext() {
        }

        @Override
        public int compareTo(Integer o) {
            return Integer.compare(DualityInterface.this.priority, o);
        }
    }

    private class InterfaceRequestSource
    extends MachineSource {
        private final InterfaceRequestContext context;

        public InterfaceRequestSource(IActionHost v) {
            super(v);
            this.context = new InterfaceRequestContext();
        }

        @Override
        public <T> Optional<T> context(Class<T> key) {
            if (key == InterfaceRequestContext.class) {
                return Optional.of(this.context);
            }
            return super.context(key);
        }
    }
}

