/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.networking.IGridNode;
import appeng.api.util.AEColor;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.sync.packets.PaintedEntityPacket;
import appeng.crafting.CraftingJob;
import appeng.me.Grid;
import appeng.tile.AEBaseBlockEntity;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import com.google.common.base.Stopwatch;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2802;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class TickHandler {
    private static TickHandler INSTANCE;
    private final Queue<IWorldCallable<?>> serverQueue = new ArrayDeque();
    private final Multimap<class_1937, CraftingJob> craftingJobs = LinkedListMultimap.create();
    private final Map<class_1936, Queue<IWorldCallable<?>>> callQueue = new WeakHashMap();
    private final HandlerRep server = new HandlerRep();
    private final HandlerRep client = new HandlerRep();
    private final HashMap<Integer, PlayerColor> srvPlayerColors = new HashMap();

    public TickHandler() {
        if (INSTANCE != null) {
            throw new IllegalStateException("There can only be a single tick handler.");
        }
        INSTANCE = this;
        ServerTickEvents.END_SERVER_TICK.register(this::onAfterServerTick);
        ServerTickEvents.START_WORLD_TICK.register(this::onBeforeWorldTick);
        ServerTickEvents.END_WORLD_TICK.register(this::onAfterWorldTick);
        ServerWorldEvents.UNLOAD.register(this::onUnloadWorld);
    }

    public static TickHandler instance() {
        return INSTANCE;
    }

    public Map<Integer, PlayerColor> getPlayerColors() {
        return this.srvPlayerColors;
    }

    public void addCallable(class_1936 w, IWorldCallable<?> c) {
        if (w == null) {
            this.serverQueue.add(c);
        } else {
            Queue<IWorldCallable<?>> queue = this.callQueue.get(w);
            if (queue == null) {
                queue = new ArrayDeque();
                this.callQueue.put(w, queue);
            }
            queue.add(c);
        }
    }

    public void addInit(AEBaseBlockEntity tile) {
        if (Platform.isServer()) {
            this.getRepo().tiles.add(tile);
        }
    }

    private HandlerRep getRepo() {
        if (Platform.isServer()) {
            return this.server;
        }
        return this.client;
    }

    public void addNetwork(Grid grid) {
        if (Platform.isServer()) {
            this.getRepo().addNetwork(grid);
        }
    }

    public void removeNetwork(Grid grid) {
        if (Platform.isServer()) {
            this.getRepo().removeNetwork(grid);
        }
    }

    public Iterable<Grid> getGridList() {
        return this.getRepo().networks;
    }

    public void shutdown() {
        this.getRepo().clear();
    }

    public void onUnloadWorld(MinecraftServer server, class_3218 world) {
        ArrayList<IGridNode> toDestroy = new ArrayList<IGridNode>();
        this.getRepo().updateNetworks();
        for (Grid g : this.getRepo().networks) {
            for (IGridNode n : g.getNodes()) {
                if (n.getWorld() != world) continue;
                toDestroy.add(n);
            }
        }
        for (IGridNode n : toDestroy) {
            n.destroy();
        }
    }

    private void onBeforeWorldTick(class_3218 world) {
        Queue<IWorldCallable<?>> queue = this.callQueue.get(world);
        this.processQueue(queue, (class_1937)world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAfterWorldTick(class_3218 world) {
        Multimap<class_1937, CraftingJob> multimap = this.craftingJobs;
        synchronized (multimap) {
            Collection jobSet = this.craftingJobs.get((Object)world);
            if (!jobSet.isEmpty()) {
                int jobSize = jobSet.size();
                int microSecondsPerTick = AEConfig.instance().getCraftingCalculationTimePerTick() * 1000;
                int simTime = Math.max(1, microSecondsPerTick / jobSize);
                Iterator i = jobSet.iterator();
                while (i.hasNext()) {
                    CraftingJob cj = (CraftingJob)i.next();
                    if (cj.simulateFor(simTime)) continue;
                    i.remove();
                }
            }
        }
    }

    private void onAfterServerTick(MinecraftServer server) {
        this.tickColors(this.srvPlayerColors);
        ArrayList<AEBaseBlockEntity> delayQueue = null;
        HandlerRep repo = this.getRepo();
        while (!repo.tiles.isEmpty()) {
            AEBaseBlockEntity bt = (AEBaseBlockEntity)repo.tiles.poll();
            if (bt.method_11015()) continue;
            class_2802 chunkProvider = bt.method_10997().method_8398();
            if (chunkProvider.method_20529(bt.method_11016())) {
                bt.onReady();
                continue;
            }
            class_1923 chunkPos = new class_1923(bt.method_11016());
            if (chunkProvider.method_12123(chunkPos.field_9181, chunkPos.field_9180)) {
                if (delayQueue == null) {
                    delayQueue = new ArrayList<AEBaseBlockEntity>();
                }
                delayQueue.add(bt);
                continue;
            }
            AELog.warn("Skipping onReady for Tile-Entity in unloaded chunk %s", chunkPos);
        }
        if (delayQueue != null) {
            AELog.debug("Delaying onReady for %s tile-entities because their chunks are not fully loaded", delayQueue.size());
            repo.tiles.addAll(delayQueue);
        }
        this.getRepo().updateNetworks();
        for (Grid g : this.getRepo().networks) {
            g.update();
        }
        this.processQueue(this.serverQueue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCraftingSimulation(class_1937 world, CraftingJob craftingJob) {
        Multimap<class_1937, CraftingJob> multimap = this.craftingJobs;
        synchronized (multimap) {
            this.craftingJobs.put((Object)world, (Object)craftingJob);
        }
    }

    protected void tickColors(Map<Integer, PlayerColor> playerSet) {
        Iterator<PlayerColor> i = playerSet.values().iterator();
        while (i.hasNext()) {
            PlayerColor pc = i.next();
            if (pc.ticksLeft <= 0) {
                i.remove();
            }
            pc.ticksLeft--;
        }
    }

    private void processQueue(Queue<IWorldCallable<?>> queue, class_1937 world) {
        if (queue == null) {
            return;
        }
        Stopwatch sw = Stopwatch.createStarted();
        IWorldCallable<?> c = null;
        while ((c = queue.poll()) != null) {
            try {
                c.call(world);
                if (sw.elapsed(TimeUnit.MILLISECONDS) <= 50L) continue;
                break;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    public static class PlayerColor {
        public final AEColor myColor;
        private final int myEntity;
        private int ticksLeft;

        public PlayerColor(int id, AEColor col, int ticks) {
            this.myEntity = id;
            this.myColor = col;
            this.ticksLeft = ticks;
        }

        public PaintedEntityPacket getPacket() {
            return new PaintedEntityPacket(this.myEntity, this.myColor, this.ticksLeft);
        }
    }

    private static class HandlerRep {
        private Queue<AEBaseBlockEntity> tiles = new ArrayDeque<AEBaseBlockEntity>();
        private Set<Grid> networks = new HashSet<Grid>();
        private Set<Grid> toAdd = new HashSet<Grid>();
        private Set<Grid> toRemove = new HashSet<Grid>();

        private HandlerRep() {
        }

        private void clear() {
            this.tiles = new ArrayDeque<AEBaseBlockEntity>();
            this.networks = new HashSet<Grid>();
            this.toAdd = new HashSet<Grid>();
            this.toRemove = new HashSet<Grid>();
        }

        private synchronized void addNetwork(Grid g) {
            this.toAdd.add(g);
            this.toRemove.remove(g);
        }

        private synchronized void removeNetwork(Grid g) {
            this.toRemove.add(g);
            this.toAdd.remove(g);
        }

        private synchronized void updateNetworks() {
            this.networks.removeAll(this.toRemove);
            this.toRemove.clear();
            this.networks.addAll(this.toAdd);
            this.toAdd.clear();
        }
    }
}

