/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.core.Api;
import appeng.integration.modules.jei.CondenserOutputDisplay;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.widgets.Slot;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

class CondenserCategory
implements RecipeCategory<CondenserOutputDisplay> {
    private static final int PADDING = 7;
    public static final class_2960 UID = new class_2960("appliedenergistics2", "condenser");
    private final String localizedName = class_2477.method_10517().method_4679("gui.appliedenergistics2.Condenser");
    private final EntryStack icon = EntryStack.create((class_1799)Api.INSTANCE.definitions().blocks().condenser().stack(1));

    public class_2960 getIdentifier() {
        return UID;
    }

    public String getCategoryName() {
        return this.localizedName;
    }

    public EntryStack getLogo() {
        return this.icon;
    }

    public List<Widget> setupDisplay(CondenserOutputDisplay recipeDisplay, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        Point origin = new Point(bounds.x + 7, bounds.y + 7);
        class_2960 location = new class_2960("appliedenergistics2", "textures/guis/condenser.png");
        widgets.add(Widgets.createTexturedWidget((class_2960)location, (int)origin.x, (int)origin.y, (float)50.0f, (float)25.0f, (int)94, (int)48));
        class_2960 statesLocation = new class_2960("appliedenergistics2", "textures/guis/states.png");
        widgets.add(Widgets.createTexturedWidget((class_2960)statesLocation, (int)(origin.x + 2), (int)(origin.y + 28), (float)241.0f, (float)81.0f, (int)14, (int)14));
        widgets.add(Widgets.createTexturedWidget((class_2960)statesLocation, (int)(origin.x + 78), (int)(origin.y + 28), (float)240.0f, (float)240.0f, (int)16, (int)16));
        if (recipeDisplay.getType() == CondenserOutput.MATTER_BALLS) {
            widgets.add(Widgets.createTexturedWidget((class_2960)statesLocation, (int)(origin.x + 78), (int)(origin.y + 28), (float)16.0f, (float)112.0f, (int)14, (int)14));
        } else if (recipeDisplay.getType() == CondenserOutput.SINGULARITY) {
            widgets.add(Widgets.createTexturedWidget((class_2960)statesLocation, (int)(origin.x + 78), (int)(origin.y + 28), (float)32.0f, (float)112.0f, (int)14, (int)14));
        }
        widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            Rectangle rect = new Rectangle(origin.x + 78, origin.y + 28, 16, 16);
            if (rect.contains(mouseX, mouseY)) {
                Tooltip.create((Collection)this.getTooltip(recipeDisplay.getType()).stream().map(class_2585::new).collect(Collectors.toList())).queue();
            }
        }));
        Slot outputSlot = Widgets.createSlot((Point)new Point(origin.x + 55, origin.y + 27)).disableBackground().markOutput().entries(recipeDisplay.getOutputEntries());
        widgets.add((Widget)outputSlot);
        Slot storageCellSlot = Widgets.createSlot((Point)new Point(origin.x + 51, origin.y + 1)).disableBackground().markInput().entries(recipeDisplay.getViableStorageComponents());
        widgets.add((Widget)storageCellSlot);
        return widgets;
    }

    public int getDisplayWidth(CondenserOutputDisplay display) {
        return 108;
    }

    public int getDisplayHeight() {
        return 62;
    }

    private List<String> getTooltip(CondenserOutput type) {
        String key;
        switch (type) {
            case MATTER_BALLS: {
                key = "gui.tooltips.appliedenergistics2.MatterBalls";
                break;
            }
            case SINGULARITY: {
                key = "gui.tooltips.appliedenergistics2.Singularity";
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        return Splitter.on((String)"\n").splitToList((CharSequence)new class_2588(key, new Object[]{type.requiredPower}).getString());
    }
}

