/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IStorageComponent;
import appeng.core.Api;
import appeng.integration.modules.jei.CondenserCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class CondenserOutputDisplay
implements RecipeDisplay {
    private final CondenserOutput type;
    private final List<EntryStack> output;
    private final List<EntryStack> viableStorageComponents;

    public CondenserOutputDisplay(CondenserOutput output) {
        this.type = output;
        this.output = Collections.singletonList(EntryStack.create((class_1799)CondenserOutputDisplay.getOutput(this.type)));
        this.viableStorageComponents = this.getViableStorageComponents(output);
    }

    public List<List<EntryStack>> getInputEntries() {
        return Collections.emptyList();
    }

    public List<EntryStack> getOutputEntries() {
        return this.output;
    }

    public class_2960 getRecipeCategory() {
        return CondenserCategory.UID;
    }

    public CondenserOutput getType() {
        return this.type;
    }

    private static class_1799 getOutput(CondenserOutput recipe) {
        switch (recipe) {
            case MATTER_BALLS: {
                return Api.INSTANCE.definitions().materials().matterBall().stack(1);
            }
            case SINGULARITY: {
                return Api.INSTANCE.definitions().materials().singularity().stack(1);
            }
        }
        return class_1799.field_8037;
    }

    private List<EntryStack> getViableStorageComponents(CondenserOutput condenserOutput) {
        IMaterials materials = Api.instance().definitions().materials();
        ArrayList<EntryStack> viableComponents = new ArrayList<EntryStack>();
        this.addViableComponent(condenserOutput, viableComponents, materials.cell1kPart().stack(1));
        this.addViableComponent(condenserOutput, viableComponents, materials.cell4kPart().stack(1));
        this.addViableComponent(condenserOutput, viableComponents, materials.cell16kPart().stack(1));
        this.addViableComponent(condenserOutput, viableComponents, materials.cell64kPart().stack(1));
        return viableComponents;
    }

    private void addViableComponent(CondenserOutput condenserOutput, List<EntryStack> viableComponents, class_1799 itemStack) {
        IStorageComponent comp = (IStorageComponent)itemStack.method_7909();
        int storage = comp.getBytes(itemStack) * 8;
        if (storage >= condenserOutput.requiredPower) {
            viableComponents.add(EntryStack.create((class_1799)itemStack));
        }
    }

    public List<EntryStack> getViableStorageComponents() {
        return this.viableStorageComponents;
    }
}

