/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.integration.modules.jei.GrinderRecipeCategory;
import appeng.recipes.handlers.GrinderOptionalResult;
import appeng.recipes.handlers.GrinderRecipe;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.TransferRecipeDisplay;
import me.shedaniel.rei.server.ContainerInfo;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

class GrinderRecipeWrapper
implements TransferRecipeDisplay {
    private final GrinderRecipe recipe;
    private final List<List<EntryStack>> input;
    private final List<EntryStack> outputs;
    private final List<Double> outputChances;

    public GrinderRecipeWrapper(GrinderRecipe recipe) {
        this.recipe = recipe;
        this.input = CollectionUtils.map(recipe.method_8117(), i -> CollectionUtils.map((Object[])i.method_8105(), EntryStack::create));
        ArrayList<EntryStack> outputs = new ArrayList<EntryStack>();
        ArrayList<Double> outputChances = new ArrayList<Double>();
        outputs.add(EntryStack.create((class_1799)recipe.method_8110()));
        outputChances.add(100.0);
        for (GrinderOptionalResult optionalResult : recipe.getOptionalResults()) {
            outputs.add(EntryStack.create((class_1799)optionalResult.getResult()));
            outputChances.add((double)optionalResult.getChance() * 100.0);
        }
        this.outputs = ImmutableList.copyOf(outputs);
        this.outputChances = ImmutableList.copyOf(outputChances);
    }

    public List<List<EntryStack>> getInputEntries() {
        return this.input;
    }

    public List<EntryStack> getOutputEntries() {
        return this.outputs;
    }

    public List<Double> getOutputChances() {
        return this.outputChances;
    }

    public List<List<EntryStack>> getRequiredEntries() {
        return this.input;
    }

    public class_2960 getRecipeCategory() {
        return GrinderRecipeCategory.UID;
    }

    public Optional<class_2960> getRecipeLocation() {
        return Optional.of(this.recipe.method_8114());
    }

    public int getWidth() {
        return 1;
    }

    public int getHeight() {
        return 1;
    }

    public List<List<EntryStack>> getOrganisedInputEntries(ContainerInfo<class_1703> containerInfo, class_1703 container) {
        return this.input;
    }
}

