/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.JEIRecipePacket;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.rei.api.AutoTransferHandler;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.TransferRecipeDisplay;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2960;

abstract class RecipeTransferHandler<T extends class_1703>
implements AutoTransferHandler {
    private final Class<T> containerClass;

    RecipeTransferHandler(Class<T> containerClass) {
        this.containerClass = containerClass;
    }

    public AutoTransferHandler.Result handle(AutoTransferHandler.Context context) {
        TransferRecipeDisplay trd;
        RecipeDisplay recipe = context.getRecipe();
        if (!this.containerClass.isInstance(context.getContainerScreen().method_17577())) {
            return AutoTransferHandler.Result.createNotApplicable();
        }
        class_1703 container = (class_1703)this.containerClass.cast(context.getContainerScreen().method_17577());
        class_2960 recipeId = recipe.getRecipeLocation().orElse(null);
        boolean canSendReference = true;
        if (recipeId == null || !context.getMinecraft().field_1687.method_8433().method_8130(recipeId).isPresent()) {
            canSendReference = false;
        }
        if (recipe instanceof TransferRecipeDisplay ? (trd = (TransferRecipeDisplay)recipe).getWidth() > 3 || trd.getHeight() > 3 : recipe.getInputEntries().size() > 9) {
            return AutoTransferHandler.Result.createFailed((String)"jei.appliedenergistics2.recipe_too_large");
        }
        AutoTransferHandler.Result error = this.doTransferRecipe(container, recipe, context);
        if (error != null) {
            return error;
        }
        if (context.isActuallyCrafting()) {
            if (canSendReference) {
                NetworkHandler.instance().sendToServer(new JEIRecipePacket(recipeId, this.isCrafting()));
            } else {
                class_2371 flatIngredients = class_2371.method_10213((int)9, (Object)class_1856.field_9017);
                class_1799 output = null;
                for (EntryStack entryStack : (List)recipe.getResultingEntries().get(0)) {
                    if (entryStack.getType() != EntryStack.Type.ITEM) continue;
                    output = entryStack.getItemStack();
                }
                if (output == null || output.method_7960()) {
                    return AutoTransferHandler.Result.createFailed((String)"jei.appliedenergistics2.no_output");
                }
                for (int i = 0; i < recipe.getInputEntries().size(); ++i) {
                    class_1799 displayedIngredient;
                    List inputEntry = (List)recipe.getInputEntries().get(i);
                    if (inputEntry.isEmpty()) continue;
                    EntryStack first = (EntryStack)inputEntry.get(0);
                    if (i >= flatIngredients.size() || (displayedIngredient = first.getItemStack()) == null) continue;
                    flatIngredients.set(i, (Object)class_1856.method_26964(Stream.of(displayedIngredient)));
                }
                class_1869 fallbackRecipe = new class_1869(recipeId, "", 3, 3, flatIngredients, output);
                NetworkHandler.instance().sendToServer(new JEIRecipePacket(fallbackRecipe, this.isCrafting()));
            }
        }
        return AutoTransferHandler.Result.createSuccessful().blocksFurtherHandling();
    }

    protected abstract AutoTransferHandler.Result doTransferRecipe(T var1, RecipeDisplay var2, AutoTransferHandler.Context var3);

    protected abstract boolean isCrafting();
}

