/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.definitions.IParts;
import appeng.api.features.AEFeature;
import appeng.api.util.AEColor;
import appeng.client.gui.AEBaseScreen;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.implementations.PatternTermContainer;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.api.definitions.ApiBlocks;
import appeng.core.api.definitions.ApiItems;
import appeng.core.localization.GuiText;
import appeng.integration.abstraction.ReiFacade;
import appeng.integration.modules.jei.CondenserCategory;
import appeng.integration.modules.jei.CondenserOutputDisplay;
import appeng.integration.modules.jei.CraftingRecipeTransferHandler;
import appeng.integration.modules.jei.FacadeRecipeCategory;
import appeng.integration.modules.jei.FacadeRegistryGenerator;
import appeng.integration.modules.jei.GrinderRecipeCategory;
import appeng.integration.modules.jei.GrinderRecipeWrapper;
import appeng.integration.modules.jei.InscriberRecipeCategory;
import appeng.integration.modules.jei.InscriberRecipeWrapper;
import appeng.integration.modules.jei.PatternRecipeTransferHandler;
import appeng.integration.modules.jei.ReiRuntimeAdapter;
import appeng.items.parts.FacadeItem;
import appeng.recipes.handlers.GrinderRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.AutoTransferHandler;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.LiveRecipeGenerator;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import me.shedaniel.rei.plugin.information.DefaultInformationDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ReiPlugin
implements REIPluginV0 {
    private static final class_2960 ID = new class_2960("appliedenergistics2", "core");
    private final ApiBlocks blocks = Api.INSTANCE.definitions().blocks();
    private final ApiItems items = Api.INSTANCE.definitions().items();
    private final List<Predicate<class_1799>> developerItems = ImmutableList.of(this.blocks.cubeGenerator()::isSameAs, this.blocks.chunkLoader()::isSameAs, this.blocks.itemGen()::isSameAs, this.blocks.phantomNode()::isSameAs, this.items.toolDebugCard()::isSameAs, this.items.toolEraser()::isSameAs, this.items.toolMeteoritePlacer()::isSameAs, this.items.toolReplicatorCard()::isSameAs);
    private final List<Predicate<class_1799>> coloredCables;

    public ReiPlugin() {
        ArrayList<Predicate<class_1799>> predicates = new ArrayList<Predicate<class_1799>>();
        IParts parts = Api.instance().definitions().parts();
        for (AEColor color : AEColor.values()) {
            if (color == AEColor.TRANSPARENT) continue;
            predicates.add(stack -> parts.cableCovered().sameAs(color, (class_1799)stack));
            predicates.add(stack -> parts.cableDenseCovered().sameAs(color, (class_1799)stack));
            predicates.add(stack -> parts.cableGlass().sameAs(color, (class_1799)stack));
            predicates.add(stack -> parts.cableSmart().sameAs(color, (class_1799)stack));
            predicates.add(stack -> parts.cableDenseSmart().sameAs(color, (class_1799)stack));
        }
        this.coloredCables = ImmutableList.copyOf(predicates);
    }

    public class_2960 getPluginIdentifier() {
        return ID;
    }

    public void registerPluginCategories(RecipeHelper recipeHelper) {
        recipeHelper.registerCategory((RecipeCategory)new GrinderRecipeCategory());
        recipeHelper.registerCategory((RecipeCategory)new CondenserCategory());
        recipeHelper.registerCategory((RecipeCategory)new InscriberRecipeCategory());
        recipeHelper.registerCategory((RecipeCategory)new FacadeRecipeCategory());
    }

    public void registerRecipeDisplays(RecipeHelper recipeHelper) {
        recipeHelper.registerRecipes(GrinderRecipeCategory.UID, GrinderRecipe.class, GrinderRecipeWrapper::new);
        recipeHelper.registerRecipes(InscriberRecipeCategory.UID, InscriberRecipe.class, InscriberRecipeWrapper::new);
        recipeHelper.registerDisplay((RecipeDisplay)new CondenserOutputDisplay(CondenserOutput.MATTER_BALLS));
        recipeHelper.registerDisplay((RecipeDisplay)new CondenserOutputDisplay(CondenserOutput.SINGULARITY));
    }

    public void registerOthers(RecipeHelper recipeHelper) {
        recipeHelper.registerAutoCraftingHandler((AutoTransferHandler)new CraftingRecipeTransferHandler(CraftingTermContainer.class));
        recipeHelper.registerAutoCraftingHandler((AutoTransferHandler)new PatternRecipeTransferHandler(PatternTermContainer.class));
        recipeHelper.removeAutoCraftButton(GrinderRecipeCategory.UID);
        recipeHelper.removeAutoCraftButton(InscriberRecipeCategory.UID);
        recipeHelper.removeAutoCraftButton(CondenserCategory.UID);
        this.registerWorkingStations(recipeHelper);
        if (AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_FACADE_CRAFTING)) {
            IDefinitions definitions = Api.instance().definitions();
            recipeHelper.registerLiveRecipeGenerator((LiveRecipeGenerator)new FacadeRegistryGenerator((FacadeItem)definitions.items().facade().item(), definitions.parts().cableAnchor().stack(1)));
        }
    }

    public void registerEntries(EntryRegistry entryRegistry) {
        entryRegistry.removeEntryIf(this::shouldEntryBeHidden);
    }

    public void postRegister() {
        IDefinitions definitions = Api.instance().definitions();
        this.registerDescriptions(definitions);
        ReiFacade.setInstance(new ReiRuntimeAdapter());
    }

    public void registerBounds(DisplayHelper displayHelper) {
        BaseBoundsHandler baseBoundsHandler = BaseBoundsHandler.getInstance();
        baseBoundsHandler.registerExclusionZones(AEBaseScreen.class, () -> {
            AEBaseScreen screen = (AEBaseScreen)class_310.method_1551().field_1755;
            return screen != null ? screen.getExclusionZones() : Collections.emptyList();
        });
    }

    private void registerWorkingStations(RecipeHelper registration) {
        IDefinitions definitions = Api.instance().definitions();
        class_1799 grindstone = definitions.blocks().grindstone().stack(1);
        registration.registerWorkingStations(GrinderRecipeCategory.UID, new EntryStack[]{EntryStack.create((class_1799)grindstone)});
        class_1799 condenser = definitions.blocks().condenser().stack(1);
        registration.registerWorkingStations(CondenserCategory.UID, new EntryStack[]{EntryStack.create((class_1799)condenser)});
        class_1799 inscriber = definitions.blocks().inscriber().stack(1);
        registration.registerWorkingStations(InscriberRecipeCategory.UID, new EntryStack[]{EntryStack.create((class_1799)inscriber)});
    }

    private void registerDescriptions(IDefinitions definitions) {
        IMaterials materials = definitions.materials();
        String[] message = AEConfig.instance().isFeatureEnabled(AEFeature.CERTUS_QUARTZ_WORLD_GEN) ? new String[]{GuiText.ChargedQuartz.getTranslationKey(), "", GuiText.ChargedQuartzFind.getTranslationKey()} : new String[]{GuiText.ChargedQuartzFind.getTranslationKey()};
        ReiPlugin.addDescription(materials.certusQuartzCrystalCharged(), message);
        if (AEConfig.instance().isFeatureEnabled(AEFeature.METEORITE_WORLD_GEN)) {
            ReiPlugin.addDescription(materials.logicProcessorPress(), GuiText.inWorldCraftingPresses.getTranslationKey());
            ReiPlugin.addDescription(materials.calcProcessorPress(), GuiText.inWorldCraftingPresses.getTranslationKey());
            ReiPlugin.addDescription(materials.engProcessorPress(), GuiText.inWorldCraftingPresses.getTranslationKey());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_FLUIX)) {
            ReiPlugin.addDescription(materials.fluixCrystal(), GuiText.inWorldFluix.getTranslationKey());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_SINGULARITY)) {
            ReiPlugin.addDescription(materials.qESingularity(), GuiText.inWorldSingularity.getTranslationKey());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_PURIFICATION)) {
            ReiPlugin.addDescription(materials.purifiedCertusQuartzCrystal(), GuiText.inWorldPurificationCertus.getTranslationKey());
            ReiPlugin.addDescription(materials.purifiedNetherQuartzCrystal(), GuiText.inWorldPurificationNether.getTranslationKey());
            ReiPlugin.addDescription(materials.purifiedFluixCrystal(), GuiText.inWorldPurificationFluix.getTranslationKey());
        }
    }

    private static void addDescription(IItemDefinition itemDefinition, String ... message) {
        DefaultInformationDisplay info = DefaultInformationDisplay.createFromEntry((EntryStack)EntryStack.create((class_1935)itemDefinition), (class_2561)itemDefinition.item().method_7848());
        info.lines((Collection)Arrays.stream(message).map(class_2588::new).collect(Collectors.toList()));
        RecipeHelper.getInstance().registerDisplay((RecipeDisplay)info);
    }

    private boolean shouldEntryBeHidden(EntryStack entryStack) {
        if (entryStack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        class_1799 stack = entryStack.getItemStack();
        if (this.items.dummyFluidItem().isSameAs(stack) || this.items.facade().isSameAs(stack) || this.blocks.multiPart().isSameAs(stack) || this.blocks.matrixFrame().isSameAs(stack) || this.blocks.paint().isSameAs(stack)) {
            return true;
        }
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.UNSUPPORTED_DEVELOPER_TOOLS)) {
            for (Predicate<class_1799> developerItem : this.developerItems) {
                if (!developerItem.test(stack)) continue;
                return true;
            }
        }
        if (AEConfig.instance().isDisableColoredCableRecipesInJEI()) {
            for (Predicate<class_1799> predicate : this.coloredCables) {
                if (!predicate.test(stack)) continue;
                return true;
            }
        }
        return false;
    }
}

