/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.trenergy;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import net.minecraft.class_1799;
import team.reborn.energy.Energy;
import team.reborn.energy.EnergySide;
import team.reborn.energy.EnergyStorage;
import team.reborn.energy.EnergyTier;

public final class ItemPowerStorageAdapter
implements EnergyStorage {
    private final IAEItemPowerStorage item;
    private final class_1799 stack;

    public ItemPowerStorageAdapter(IAEItemPowerStorage item, class_1799 stack) {
        this.item = item;
        this.stack = stack;
    }

    public double getStored(EnergySide energySide) {
        return PowerUnits.AE.convertTo(PowerUnits.TR, this.item.getAECurrentPower(this.stack));
    }

    public void setStored(double v) {
        double currentPower;
        double newPower = PowerUnits.TR.convertTo(PowerUnits.AE, v);
        double toInject = newPower - (currentPower = this.item.getAECurrentPower(this.stack));
        if (toInject > 1.0E-7) {
            this.item.injectAEPower(this.stack, toInject, Actionable.MODULATE);
        }
    }

    public double getMaxStoredPower() {
        return PowerUnits.AE.convertTo(PowerUnits.TR, this.item.getAEMaxPower(this.stack));
    }

    public EnergyTier getTier() {
        return EnergyTier.INFINITE;
    }

    public static void register() {
        Energy.registerHolder(obj -> obj instanceof class_1799 && ((class_1799)obj).method_7909() instanceof IAEItemPowerStorage, obj -> {
            class_1799 stack = (class_1799)obj;
            IAEItemPowerStorage item = (IAEItemPowerStorage)stack.method_7909();
            return new ItemPowerStorageAdapter(item, stack);
        });
    }
}

