/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila;

import appeng.api.parts.IPart;
import appeng.api.parts.PartItemStack;
import appeng.integration.modules.waila.part.ChannelWailaDataProvider;
import appeng.integration.modules.waila.part.IPartWailaDataProvider;
import appeng.integration.modules.waila.part.P2PStateWailaDataProvider;
import appeng.integration.modules.waila.part.PartAccessor;
import appeng.integration.modules.waila.part.PartStackWailaDataProvider;
import appeng.integration.modules.waila.part.PowerStateWailaDataProvider;
import appeng.integration.modules.waila.part.StorageMonitorWailaDataProvider;
import appeng.integration.modules.waila.part.Tracer;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public final class PartWailaDataProvider
implements IComponentProvider,
IServerDataProvider<class_2586> {
    private final List<IPartWailaDataProvider> providers;
    private final PartAccessor accessor = new PartAccessor();
    private final Tracer tracer = new Tracer();

    public PartWailaDataProvider() {
        ChannelWailaDataProvider channel = new ChannelWailaDataProvider();
        StorageMonitorWailaDataProvider storageMonitor = new StorageMonitorWailaDataProvider();
        PowerStateWailaDataProvider powerState = new PowerStateWailaDataProvider();
        P2PStateWailaDataProvider p2pState = new P2PStateWailaDataProvider();
        PartStackWailaDataProvider partStack = new PartStackWailaDataProvider();
        this.providers = Lists.newArrayList((Object[])new IPartWailaDataProvider[]{channel, storageMonitor, powerState, partStack, p2pState});
    }

    public class_1799 getStack(IDataAccessor accessor, IPluginConfig config) {
        class_239 mop;
        class_2586 te = accessor.getBlockEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getHitResult());
        if (maybePart.isPresent()) {
            IPart part = maybePart.get();
            class_1799 wailaStack = class_1799.field_8037;
            for (IPartWailaDataProvider provider : this.providers) {
                wailaStack = provider.getStack(part, config, wailaStack);
            }
            return wailaStack;
        }
        return class_1799.field_8037;
    }

    public void appendHead(List<class_2561> currentToolTip, IDataAccessor accessor, IPluginConfig config) {
        class_239 mop;
        class_2586 te = accessor.getBlockEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getHitResult());
        if (maybePart.isPresent()) {
            IPart part = maybePart.get();
            currentToolTip.clear();
            currentToolTip.add(part.getItemStack(PartItemStack.PICK).method_7964());
            for (IPartWailaDataProvider provider : this.providers) {
                provider.appendHead(part, currentToolTip, accessor, config);
            }
        }
    }

    public void appendBody(List<class_2561> tooltip, IDataAccessor accessor, IPluginConfig config) {
        class_239 mop;
        class_2586 te = accessor.getBlockEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getHitResult());
        if (maybePart.isPresent()) {
            IPart part = maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.appendBody(part, tooltip, accessor, config);
            }
        }
    }

    public void appendTail(List<class_2561> tooltip, IDataAccessor accessor, IPluginConfig config) {
        class_239 mop;
        class_2586 te = accessor.getBlockEntity();
        Optional<IPart> maybePart = this.accessor.getMaybePart(te, mop = accessor.getHitResult());
        if (maybePart.isPresent()) {
            IPart part = maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.appendTail(part, tooltip, accessor, config);
            }
        }
    }

    public void appendServerData(class_2487 tag, class_3222 player, class_1937 world, class_2586 te) {
        Optional<IPart> maybePart;
        class_239 mop = this.tracer.retraceBlock(world, (class_1657)player, te.method_11016());
        if (mop != null && (maybePart = this.accessor.getMaybePart(te, mop)).isPresent()) {
            IPart part = maybePart.get();
            for (IPartWailaDataProvider provider : this.providers) {
                provider.appendServerData(player, part, te, tag, world, te.method_11016());
            }
        }
    }
}

