/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.parts.IPart;
import appeng.core.localization.WailaText;
import appeng.integration.modules.waila.part.BasePartWailaDataProvider;
import appeng.parts.networking.SmartCablePart;
import appeng.parts.networking.SmartDenseCablePart;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import java.util.List;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public final class ChannelWailaDataProvider
extends BasePartWailaDataProvider {
    private static final String ID_USED_CHANNELS = "usedChannels";
    private final Object2ByteMap<IPart> cache = new Object2ByteOpenHashMap();

    @Override
    public void appendBody(IPart part, List<class_2561> tooltip, IDataAccessor accessor, IPluginConfig config) {
        class_2487 tag;
        byte usedChannels;
        if ((part instanceof SmartCablePart || part instanceof SmartDenseCablePart) && (usedChannels = this.getUsedChannels(part, tag = accessor.getServerData(), this.cache)) >= 0) {
            byte maxChannels = (byte)(part instanceof SmartDenseCablePart ? 32 : 8);
            class_5250 formattedToolTip = WailaText.Channels.text(usedChannels, maxChannels);
            tooltip.add((class_2561)formattedToolTip);
        }
    }

    private byte getUsedChannels(IPart part, class_2487 tag, Object2ByteMap<IPart> cache) {
        byte usedChannels;
        if (tag.method_10545(ID_USED_CHANNELS)) {
            usedChannels = tag.method_10571(ID_USED_CHANNELS);
            this.cache.put((Object)part, usedChannels);
        } else {
            usedChannels = this.cache.containsKey((Object)part) ? this.cache.get((Object)part) : (byte)-1;
        }
        return usedChannels;
    }

    @Override
    public void appendServerData(class_3222 player, IPart part, class_2586 te, class_2487 tag, class_1937 world, class_2338 pos) {
        if (part instanceof SmartCablePart || part instanceof SmartDenseCablePart) {
            class_2487 tempTag = new class_2487();
            part.writeToNBT(tempTag);
            if (tempTag.method_10545(ID_USED_CHANNELS)) {
                byte usedChannels = tempTag.method_10571(ID_USED_CHANNELS);
                tag.method_10567(ID_USED_CHANNELS, usedChannels);
            }
        }
    }
}

