/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.parts.IPart;
import appeng.core.localization.WailaText;
import appeng.integration.modules.waila.part.BasePartWailaDataProvider;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.Platform;
import com.google.common.collect.Iterators;
import java.util.List;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_3222;

public final class P2PStateWailaDataProvider
extends BasePartWailaDataProvider {
    private static final int STATE_UNLINKED = 0;
    private static final int STATE_OUTPUT = 1;
    private static final int STATE_INPUT = 2;
    public static final String TAG_P2P_STATE = "p2p_state";
    public static final String TAG_P2P_FREQUENCY = "p2p_frequency";

    @Override
    public void appendBody(IPart part, List<class_2561> tooltip, IDataAccessor accessor, IPluginConfig config) {
        class_2487 nbtData;
        if (part instanceof P2PTunnelPart && (nbtData = accessor.getServerData()).method_10545(TAG_P2P_STATE)) {
            int[] stateArr = nbtData.method_10561(TAG_P2P_STATE);
            if (stateArr.length == 2) {
                int state = stateArr[0];
                int outputs = stateArr[1];
                switch (state) {
                    case 0: {
                        tooltip.add(WailaText.P2PUnlinked.text());
                        break;
                    }
                    case 1: {
                        tooltip.add(WailaText.P2POutput.text());
                        break;
                    }
                    case 2: {
                        tooltip.add(P2PStateWailaDataProvider.getOutputText(outputs));
                    }
                }
            }
            short freq = nbtData.method_10568(TAG_P2P_FREQUENCY);
            String freqTooltip = Platform.p2p().toHexString(freq);
            tooltip.add((class_2561)new class_2588("gui.tooltips.appliedenergistics2.P2PFrequency", new Object[]{freqTooltip}));
        }
    }

    @Override
    public void appendServerData(class_3222 player, IPart part, class_2586 te, class_2487 tag, class_1937 world, class_2338 pos) {
        if (part instanceof P2PTunnelPart) {
            P2PTunnelPart tunnel = (P2PTunnelPart)part;
            if (!tunnel.isPowered()) {
                return;
            }
            short frequency = tunnel.getFrequency();
            tag.method_10575(TAG_P2P_FREQUENCY, frequency);
            int state = 0;
            int outputCount = 0;
            if (!tunnel.isOutput()) {
                outputCount = P2PStateWailaDataProvider.getOutputCount(tunnel);
                if (outputCount > 0) {
                    state = 2;
                }
            } else {
                Object input = tunnel.getInput();
                if (input != null) {
                    state = 1;
                }
            }
            tag.method_10539(TAG_P2P_STATE, new int[]{state, outputCount});
        }
    }

    private static int getOutputCount(P2PTunnelPart<?> tunnel) {
        try {
            return Iterators.size(tunnel.getOutputs().iterator());
        }
        catch (GridAccessException e) {
            return 0;
        }
    }

    private static class_2561 getOutputText(int outputs) {
        if (outputs <= 1) {
            return WailaText.P2PInputOneOutput.text();
        }
        return WailaText.P2PInputManyOutputs.text(outputs);
    }
}

