/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.networking.energy.IAEPowerStorage;
import appeng.core.localization.WailaText;
import appeng.integration.modules.waila.BaseWailaDataProvider;
import appeng.util.Platform;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public final class PowerStorageWailaDataProvider
extends BaseWailaDataProvider {
    private static final String ID_CURRENT_POWER = "currentPower";
    private final Object2LongMap<class_2586> cache = new Object2LongOpenHashMap();

    @Override
    public void appendBody(List<class_2561> tooltip, IDataAccessor accessor, IPluginConfig config) {
        class_2487 tag;
        long internalCurrentPower;
        IAEPowerStorage storage;
        double maxPower;
        class_2586 te = accessor.getBlockEntity();
        if (te instanceof IAEPowerStorage && (maxPower = (storage = (IAEPowerStorage)te).getAEMaxPower()) > 0.0 && (internalCurrentPower = this.getInternalCurrentPower(tag = accessor.getServerData(), te)) >= 0L) {
            long internalMaxPower = (long)(100.0 * maxPower);
            String formatCurrentPower = Platform.formatPowerLong(internalCurrentPower, false);
            String formatMaxPower = Platform.formatPowerLong(internalMaxPower, false);
            tooltip.add((class_2561)WailaText.Contains.text().method_27662().method_27693(": " + formatCurrentPower + " / " + formatMaxPower));
        }
    }

    @Override
    public void appendServerData(class_2487 tag, class_3222 serverPlayerEntity, class_1937 world, class_2586 te) {
        IAEPowerStorage storage;
        if (te instanceof IAEPowerStorage && (storage = (IAEPowerStorage)te).getAEMaxPower() > 0.0) {
            long internalCurrentPower = (long)(100.0 * storage.getAECurrentPower());
            tag.method_10544(ID_CURRENT_POWER, internalCurrentPower);
        }
    }

    private long getInternalCurrentPower(class_2487 tag, class_2586 te) {
        long internalCurrentPower;
        if (tag.method_10545(ID_CURRENT_POWER)) {
            internalCurrentPower = tag.method_10537(ID_CURRENT_POWER);
            this.cache.put((Object)te, internalCurrentPower);
        } else {
            internalCurrentPower = this.cache.containsKey((Object)te) ? this.cache.get((Object)te) : -1L;
        }
        return internalCurrentPower;
    }
}

