/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.materials;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.hooks.AECustomEntityItem;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.items.materials.MaterialType;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.AdaptorFixedInv;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public final class MaterialItem
extends AEBaseItem
implements IStorageComponent,
IUpgradeModule,
AEToolItem,
AECustomEntityItem {
    public static final String TAG_INSCRIBE_NAME = "InscribeName";
    private static final int KILO_SCALAR = 1024;
    private final MaterialType materialType;

    public MaterialItem(class_1792.class_1793 properties, MaterialType materialType) {
        super(properties);
        this.materialType = materialType;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 advancedTooltips) {
        Upgrades u;
        class_2487 c;
        super.method_7851(stack, world, lines, advancedTooltips);
        if (this.materialType == MaterialType.NAME_PRESS && (c = stack.method_7948()).method_10545(TAG_INSCRIBE_NAME)) {
            lines.add((class_2561)new class_2585(c.method_10558(TAG_INSCRIBE_NAME)));
        }
        if ((u = this.getType(stack)) != null) {
            lines.addAll(u.getTooltipLines());
        }
    }

    @Override
    public Upgrades getType(class_1799 itemstack) {
        switch (this.materialType) {
            case CARD_CAPACITY: {
                return Upgrades.CAPACITY;
            }
            case CARD_FUZZY: {
                return Upgrades.FUZZY;
            }
            case CARD_REDSTONE: {
                return Upgrades.REDSTONE;
            }
            case CARD_SPEED: {
                return Upgrades.SPEED;
            }
            case CARD_INVERTER: {
                return Upgrades.INVERTER;
            }
            case CARD_CRAFTING: {
                return Upgrades.CRAFTING;
            }
        }
        return null;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return super.method_7836(world, user, hand);
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        class_1657 player = context.method_8036();
        class_1268 hand = context.method_20287();
        if (player.method_18276()) {
            IUpgradeModule um;
            Upgrades u;
            class_2586 te = context.method_8045().method_8321(context.method_8037());
            FixedItemInv upgrades = null;
            if (te instanceof IPartHost) {
                SelectedPart sp = ((IPartHost)te).selectPart(context.method_17698());
                if (sp.part instanceof IUpgradeableHost) {
                    upgrades = ((ISegmentedInventory)((Object)sp.part)).getInventoryByName("upgrades");
                }
            } else if (te instanceof IUpgradeableHost) {
                upgrades = ((ISegmentedInventory)te).getInventoryByName("upgrades");
            }
            if (upgrades != null && !player.method_5998(hand).method_7960() && player.method_5998(hand).method_7909() instanceof IUpgradeModule && (u = (um = (IUpgradeModule)player.method_5998(hand).method_7909()).getType(player.method_5998(hand))) != null) {
                if (player.field_6002.field_9236) {
                    return class_1269.field_5811;
                }
                AdaptorFixedInv ad = new AdaptorFixedInv(upgrades);
                player.method_6122(hand, ((InventoryAdaptor)ad).addItems(player.method_5998(hand)));
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    @Override
    public class_1297 replaceItemEntity(class_3218 world, class_1542 itemEntity, class_1799 itemStack) {
        class_1297 eqi;
        if (!this.materialType.hasCustomEntity()) {
            return itemEntity;
        }
        Class<? extends class_1297> droppedEntity = this.materialType.getCustomEntityClass();
        try {
            eqi = droppedEntity.getConstructor(class_1937.class, Double.TYPE, Double.TYPE, Double.TYPE, class_1799.class).newInstance(world, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), itemStack);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
        eqi.method_18799(itemEntity.method_18798());
        if (eqi instanceof class_1542) {
            ((class_1542)eqi).method_6988();
        }
        return eqi;
    }

    @Override
    public int getBytes(class_1799 is) {
        switch (this.materialType) {
            case ITEM_1K_CELL_COMPONENT: {
                return 1024;
            }
            case ITEM_4K_CELL_COMPONENT: {
                return 4096;
            }
            case ITEM_16K_CELL_COMPONENT: {
                return 16384;
            }
            case ITEM_64K_CELL_COMPONENT: {
                return 65536;
            }
        }
        return 0;
    }

    @Override
    public boolean isStorageComponent(class_1799 is) {
        switch (this.materialType) {
            case ITEM_1K_CELL_COMPONENT: 
            case ITEM_4K_CELL_COMPONENT: 
            case ITEM_16K_CELL_COMPONENT: 
            case ITEM_64K_CELL_COMPONENT: {
                return true;
            }
        }
        return false;
    }
}

