/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.implementations.items.IGrowableCrystal;
import appeng.core.AEConfig;
import appeng.core.localization.ButtonToolTips;
import appeng.entity.GrowingCrystalEntity;
import appeng.hooks.AECustomEntityItem;
import appeng.items.AEBaseItem;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public class CrystalSeedItem
extends AEBaseItem
implements IGrowableCrystal,
AECustomEntityItem {
    private static final String TAG_GROWTH_TICKS = "p";
    public static final int GROWTH_TICKS_REQUIRED = 600;
    private final class_1935 grownItem;
    private final class_3494<class_3611> improvedFluidTag;

    public CrystalSeedItem(class_1792.class_1793 properties, class_1935 grownItem) {
        super(properties);
        this.grownItem = (class_1935)Preconditions.checkNotNull((Object)grownItem);
        String improvedFluidTagName = AEConfig.instance().getImprovedFluidTag();
        this.improvedFluidTag = improvedFluidTagName != null ? TagRegistry.fluid((class_2960)new class_2960(improvedFluidTagName)) : null;
    }

    @Override
    @Nullable
    public class_1799 triggerGrowth(class_1799 is) {
        int growthTicks = CrystalSeedItem.getGrowthTicks(is) + 1;
        if (growthTicks >= 600) {
            return new class_1799(this.grownItem, is.method_7947());
        }
        this.setGrowthTicks(is, growthTicks);
        return is;
    }

    public static int getGrowthTicks(class_1799 is) {
        class_2487 tag = is.method_7969();
        return tag != null ? tag.method_10550(TAG_GROWTH_TICKS) : 0;
    }

    private void setGrowthTicks(class_1799 is, int ticks) {
        ticks = class_3532.method_15340((int)ticks, (int)0, (int)600);
        is.method_7948().method_10569(TAG_GROWTH_TICKS, ticks);
    }

    @Override
    public float getMultiplier(class_2680 state, @Nullable class_1937 world, @Nullable class_2338 pos) {
        class_3610 fluidState = state.method_26227();
        if (this.improvedFluidTag != null && fluidState.method_15767(this.improvedFluidTag)) {
            return AEConfig.instance().getImprovedFluidMultiplier();
        }
        if (world != null && world.method_27983() == class_1937.field_25180) {
            return fluidState.method_15767((class_3494)class_3486.field_15518) ? 1.0f : 0.0f;
        }
        return fluidState.method_15767((class_3494)class_3486.field_15517) ? 1.0f : 0.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 advancedTooltips) {
        lines.add(ButtonToolTips.DoesntDespawn.text());
        lines.add(this.getGrowthTooltipItem(stack));
        super.method_7851(stack, world, lines, advancedTooltips);
    }

    public class_2561 getGrowthTooltipItem(class_1799 stack) {
        int progress = CrystalSeedItem.getGrowthTicks(stack);
        return new class_2585(Math.round((float)(100 * progress) / 600.0f) + "%");
    }

    @Override
    public class_1297 replaceItemEntity(class_3218 world, class_1542 itemEntity, class_1799 itemStack) {
        GrowingCrystalEntity egc = new GrowingCrystalEntity((class_1937)world, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), itemStack);
        egc.method_18799(itemEntity.method_18798());
        egc.method_6982(40);
        return egc;
    }

    public void method_7850(class_1761 group, class_2371<class_1799> items) {
        if (this.method_7877(group)) {
            items.add((Object)new class_1799((class_1935)this, 1));
            class_1799 almostFullGrown = new class_1799((class_1935)this, 1);
            this.setGrowthTicks(almostFullGrown, 599);
            items.add((Object)almostFullGrown);
        }
    }
}

