/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import appeng.helpers.InvalidPatternHelper;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class EncodedPatternItem
extends AEBaseItem
implements AEToolItem {
    public static final String NBT_INGREDIENTS = "in";
    public static final String NBT_PRODUCTS = "out";
    public static final String NBT_SUBSITUTE = "substitute";
    public static final String NBT_RECIPE_ID = "recipe";
    private static final Map<class_1799, class_1799> SIMPLE_CACHE = new WeakHashMap<class_1799, class_1799>();

    public EncodedPatternItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 w, class_1657 player, class_1268 hand) {
        this.clearPattern(player.method_5998(hand), player);
        return new class_1271(class_1269.field_5812, (Object)player.method_5998(hand));
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        return this.clearPattern(stack, context.method_8036()) ? class_1269.field_5812 : class_1269.field_5811;
    }

    private boolean clearPattern(class_1799 stack, class_1657 player) {
        if (player.method_18276()) {
            if (Platform.isClient()) {
                return false;
            }
            class_1661 inv = player.field_7514;
            class_1799 is = Api.instance().definitions().materials().blankPattern().maybeStack(stack.method_7947()).orElse(class_1799.field_8037);
            if (!is.method_7960()) {
                for (int s = 0; s < player.field_7514.method_5439(); ++s) {
                    if (inv.method_5438(s) != stack) continue;
                    inv.method_5447(s, is);
                    return true;
                }
            }
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 advancedTooltips) {
        ICraftingPatternDetails details = Api.instance().crafting().decodePattern(stack, world);
        if (details == null) {
            if (!stack.method_7985()) {
                return;
            }
            stack.method_7977((class_2561)GuiText.InvalidPattern.text().method_27661().method_27692(class_124.field_1061));
            InvalidPatternHelper invalid = new InvalidPatternHelper(stack);
            class_5250 label = (invalid.isCraftable() ? GuiText.Crafts.text() : GuiText.Creates.text()).method_27661().method_27693(": ");
            class_5250 and = new class_2585(" ").method_27661().method_10852(GuiText.And.text()).method_27661().method_27693(" ");
            class_5250 with = GuiText.With.text().method_27661().method_27693(": ");
            boolean first = true;
            for (InvalidPatternHelper.PatternIngredient output : invalid.getOutputs()) {
                lines.add((class_2561)(first ? label : and).method_27661().method_10852(output.getFormattedToolTip()));
                first = false;
            }
            first = true;
            for (InvalidPatternHelper.PatternIngredient input : invalid.getInputs()) {
                lines.add((class_2561)(first ? with : and).method_27661().method_10852(input.getFormattedToolTip()));
                first = false;
            }
            if (invalid.isCraftable()) {
                class_5250 substitutionLabel = GuiText.Substitute.text().method_27661().method_27693(" ");
                class_2561 canSubstitute = invalid.canSubstitute() ? GuiText.Yes.text() : GuiText.No.text();
                lines.add((class_2561)substitutionLabel.method_27661().method_10852(canSubstitute));
            }
            return;
        }
        if (stack.method_7938()) {
            stack.method_7925();
        }
        boolean isCrafting = details.isCraftable();
        boolean substitute = details.canSubstitute();
        List<IAEItemStack> in = details.getInputs();
        List<IAEItemStack> out = details.getOutputs();
        class_5250 label = (isCrafting ? GuiText.Crafts.text() : GuiText.Creates.text()).method_27661().method_27693(": ");
        class_5250 and = new class_2585(" ").method_27661().method_10852(GuiText.And.text()).method_27693(" ");
        class_5250 with = GuiText.With.text().method_27661().method_27693(": ");
        boolean first = true;
        for (IAEItemStack anOut : out) {
            if (anOut == null) continue;
            lines.add((class_2561)(first ? label : and).method_27661().method_27693(anOut.getStackSize() + "x ").method_10852(Platform.getItemDisplayName(anOut)));
            first = false;
        }
        first = true;
        for (IAEItemStack anIn : in) {
            if (anIn == null) continue;
            lines.add((class_2561)(first ? with : and).method_27661().method_27693(anIn.getStackSize() + "x ").method_10852(Platform.getItemDisplayName(anIn)));
            first = false;
        }
        if (isCrafting) {
            class_5250 substitutionLabel = GuiText.Substitute.text().method_27661().method_27693(" ");
            class_2561 canSubstitute = substitute ? GuiText.Yes.text() : GuiText.No.text();
            lines.add((class_2561)substitutionLabel.method_27661().method_10852(canSubstitute));
        }
    }

    public class_1799 getOutput(class_1937 w, class_1799 item) {
        class_1799 out = SIMPLE_CACHE.get(item);
        if (out != null) {
            return out;
        }
        ICraftingPatternDetails details = Api.instance().crafting().decodePattern(item, w);
        out = details != null ? details.getOutputs().get(0).createItemStack() : class_1799.field_8037;
        SIMPLE_CACHE.put(item, out);
        return out;
    }

    public boolean isEncodedPattern(class_1799 itemStack) {
        return itemStack != null && !itemStack.method_7960() && itemStack.method_7909() == this && itemStack.method_7969() != null && itemStack.method_7969().method_10573(NBT_INGREDIENTS, 9) && itemStack.method_7969().method_10573(NBT_PRODUCTS, 9);
    }

    public class_2960 getCraftingRecipeId(class_1799 itemStack) {
        Preconditions.checkArgument((itemStack.method_7909() == this ? 1 : 0) != 0, (String)"Given item stack %s is not an encoded pattern.", (Object)itemStack);
        class_2487 tag = itemStack.method_7969();
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"itemStack missing a NBT tag");
        return tag.method_10573(NBT_RECIPE_ID, 8) ? new class_2960(tag.method_10558(NBT_RECIPE_ID)) : null;
    }

    public List<IAEItemStack> getIngredients(class_1799 itemStack) {
        Preconditions.checkArgument((itemStack.method_7909() == this ? 1 : 0) != 0, (String)"Given item stack %s is not an encoded pattern.", (Object)itemStack);
        class_2487 tag = itemStack.method_7969();
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"itemStack missing a NBT tag");
        class_2499 inTag = tag.method_10554(NBT_INGREDIENTS, 10);
        Preconditions.checkArgument((inTag.size() < 10 ? 1 : 0) != 0, (Object)"Cannot use more than 9 ingredients");
        ArrayList<IAEItemStack> in = new ArrayList<IAEItemStack>(inTag.size());
        for (int x = 0; x < inTag.size(); ++x) {
            class_2487 ingredient = inTag.method_10602(x);
            class_1799 gs = class_1799.method_7915((class_2487)ingredient);
            Preconditions.checkArgument((ingredient.isEmpty() || !gs.method_7960() ? 1 : 0) != 0, (String)"invalid itemStack in slot", (int)x);
            in.add((IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(gs));
        }
        return in;
    }

    public List<IAEItemStack> getProducts(class_1799 itemStack) {
        Preconditions.checkArgument((itemStack.method_7909() == this ? 1 : 0) != 0, (String)"Given item stack %s is not an encoded pattern.", (Object)itemStack);
        class_2487 tag = itemStack.method_7969();
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"itemStack missing a NBT tag");
        class_2499 outTag = tag.method_10554(NBT_PRODUCTS, 10);
        Preconditions.checkArgument((outTag.size() < 4 ? 1 : 0) != 0, (Object)"Cannot use more than 3 ingredients");
        ArrayList<IAEItemStack> out = new ArrayList<IAEItemStack>(outTag.size());
        for (int x = 0; x < outTag.size(); ++x) {
            class_2487 ingredient = outTag.method_10602(x);
            class_1799 gs = class_1799.method_7915((class_2487)ingredient);
            Preconditions.checkArgument((ingredient.isEmpty() || !gs.method_7960() ? 1 : 0) != 0, (String)"invalid itemStack in slot", (int)x);
            out.add((IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(gs));
        }
        return out;
    }

    public boolean allowsSubstitution(class_1799 itemStack) {
        class_2487 tag = itemStack.method_7969();
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"itemStack missing a NBT tag");
        return this.getCraftingRecipeId(itemStack) != null && tag.method_10577(NBT_SUBSITUTE);
    }

    public static void encodeCraftingPattern(class_1799 stack, class_1799[] in, class_1799[] out, class_2960 recipeId, boolean allowSubstitutes) {
        class_2487 encodedValue = EncodedPatternItem.encodeInputsAndOutputs(in, out);
        encodedValue.method_10582(NBT_RECIPE_ID, recipeId.toString());
        encodedValue.method_10556(NBT_SUBSITUTE, allowSubstitutes);
        stack.method_7980(encodedValue);
    }

    public static void encodeProcessingPattern(class_1799 stack, class_1799[] in, class_1799[] out) {
        stack.method_7980(EncodedPatternItem.encodeInputsAndOutputs(in, out));
    }

    private static class_2487 encodeInputsAndOutputs(class_1799[] in, class_1799[] out) {
        class_2487 encodedValue = new class_2487();
        class_2499 tagIn = new class_2499();
        class_2499 tagOut = new class_2499();
        boolean hasInput = false;
        for (class_1799 i : in) {
            tagIn.add((Object)EncodedPatternItem.createItemTag(i));
            if (i.method_7960()) continue;
            hasInput = true;
        }
        Preconditions.checkArgument((boolean)hasInput, (Object)"cannot encode a pattern that has no inputs.");
        boolean hasNonEmptyOutput = false;
        for (class_1799 i : out) {
            tagOut.add((Object)EncodedPatternItem.createItemTag(i));
            if (i.method_7960()) continue;
            hasNonEmptyOutput = true;
        }
        Preconditions.checkArgument((boolean)hasNonEmptyOutput, (Object)"cannot encode a pattern that has no output.");
        encodedValue.method_10566(NBT_INGREDIENTS, (class_2520)tagIn);
        encodedValue.method_10566(NBT_PRODUCTS, (class_2520)tagOut);
        return encodedValue;
    }

    private static class_2520 createItemTag(class_1799 i) {
        class_2487 c = new class_2487();
        if (!i.method_7960()) {
            i.method_7953(c);
        }
        return c;
    }
}

