/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.exceptions.MissingDefinitionException;
import appeng.api.features.AEFeature;
import appeng.api.parts.IAlphaPassItem;
import appeng.api.util.AEPartLocation;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.mixins.tags.BlockTagsAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_4696;

@EnvironmentInterface(value=EnvType.CLIENT, itf=IAlphaPassItem.class)
public class FacadeItem
extends AEBaseItem
implements IFacadeItem,
IAlphaPassItem,
AEToolItem {
    private static final class_3494.class_5123<class_2248> BLOCK_WHITELIST = BlockTagsAccessor.register(AppEng.makeId("whitelisted/facades").toString());
    private static final String NBT_ITEM_ID = "item";

    public FacadeItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        return Api.instance().partHelper().placeBus(stack, context.method_8037(), context.method_8038(), context.method_8036(), context.method_20287(), context.method_8045());
    }

    public class_2561 method_7864(class_1799 is) {
        try {
            class_1799 in = this.getTextureItem(is);
            if (!in.method_7960()) {
                return super.method_7864(is).method_27662().method_27693(" - ").method_10852(in.method_7964());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.method_7864(is);
    }

    public void method_7850(class_1761 group, class_2371<class_1799> items) {
    }

    public class_1799 createFacadeForItem(class_1799 itemStack, boolean returnItem) {
        boolean isBlockAllowed;
        if (itemStack.method_7960() || itemStack.method_7985() || !(itemStack.method_7909() instanceof class_1747)) {
            return class_1799.field_8037;
        }
        class_1747 blockItem = (class_1747)itemStack.method_7909();
        class_2248 block = blockItem.method_7711();
        if (block == class_2246.field_10124) {
            return class_1799.field_8037;
        }
        class_2680 blockState = block.method_9564();
        boolean areTileEntitiesEnabled = AEConfig.instance().isFeatureEnabled(AEFeature.TILE_ENTITY_FACADES);
        boolean isWhiteListed = BLOCK_WHITELIST.method_15141((Object)block);
        boolean isModel = blockState.method_26217() == class_2464.field_11458;
        class_2680 defaultState = block.method_9564();
        boolean isTileEntity = block.method_26161();
        boolean isFullCube = defaultState.method_26216((class_1922)class_2682.field_12294, class_2338.field_10980);
        boolean isTileEntityAllowed = !isTileEntity || areTileEntitiesEnabled && isWhiteListed;
        boolean bl = isBlockAllowed = isFullCube || isWhiteListed;
        if (isModel && isTileEntityAllowed && isBlockAllowed) {
            if (returnItem) {
                return itemStack;
            }
            class_1799 is = new class_1799((class_1935)this);
            class_2487 data = new class_2487();
            class_2960 itemId = class_2378.field_11142.method_10221((Object)itemStack.method_7909());
            data.method_10582(NBT_ITEM_ID, itemId.toString());
            is.method_7980(data);
            return is;
        }
        return class_1799.field_8037;
    }

    @Override
    public FacadePart createPartFromItemStack(class_1799 is, AEPartLocation side) {
        class_1799 in = this.getTextureItem(is);
        if (!in.method_7960()) {
            return new FacadePart(is, side);
        }
        return null;
    }

    @Override
    public class_1799 getTextureItem(class_1799 is) {
        class_2487 nbt = is.method_7969();
        if (nbt == null) {
            return class_1799.field_8037;
        }
        class_2960 itemId = new class_2960(nbt.method_10558(NBT_ITEM_ID));
        class_1792 baseItem = class_2378.field_11142.method_17966(itemId).orElse(null);
        if (baseItem == null) {
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)baseItem);
    }

    @Override
    public class_2680 getTextureBlockState(class_1799 is) {
        class_1799 baseItemStack = this.getTextureItem(is);
        if (baseItemStack.method_7960()) {
            return class_2246.field_10033.method_9564();
        }
        class_2248 block = class_2248.method_9503((class_1792)baseItemStack.method_7909());
        if (block == class_2246.field_10124) {
            return class_2246.field_10033.method_9564();
        }
        return block.method_9564();
    }

    public class_1799 createFromID(int id) {
        class_1799 facadeStack = Api.instance().definitions().items().facade().maybeStack(1).orElseThrow(() -> new MissingDefinitionException("Tried to create a facade, while facades are being deactivated."));
        class_1792 item = (class_1792)class_2378.field_11142.method_10200(id);
        if (item == class_1802.field_8162) {
            return class_1799.field_8037;
        }
        class_2960 longId = class_2378.field_11142.method_10221((Object)item);
        class_2487 facadeTag = new class_2487();
        facadeTag.method_10582(NBT_ITEM_ID, longId.toString());
        facadeStack.method_7980(facadeTag);
        return facadeStack;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean useAlphaPass(class_1799 is) {
        class_2680 blockState = this.getTextureBlockState(is);
        if (blockState == null) {
            return false;
        }
        return class_4696.method_23679((class_2680)blockState) == class_1921.method_23583() || class_4696.method_23679((class_2680)blockState) == class_1921.method_23585();
    }
}

