/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.materials.MaterialType;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2561;

public abstract class AbstractStorageCell<T extends IAEStack<T>>
extends AEBaseItem
implements IStorageCell<T>,
AEToolItem {
    protected final MaterialType component;
    protected final int totalBytes;

    public AbstractStorageCell(class_1792.class_1793 properties, MaterialType whichCell, int kilobytes) {
        super(properties);
        this.totalBytes = kilobytes * 1024;
        this.component = whichCell;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 advancedTooltips) {
        Api.instance().client().addCellInformation(Api.instance().registries().cell().getCellInventory(stack, null, this.getChannel()), lines);
    }

    @Override
    public int getBytes(class_1799 cellItem) {
        return this.totalBytes;
    }

    @Override
    public int getTotalTypes(class_1799 cellItem) {
        return 63;
    }

    @Override
    public boolean isBlackListed(class_1799 cellItem, T requestedAddition) {
        return false;
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(class_1799 i) {
        return true;
    }

    @Override
    public boolean isEditable(class_1799 is) {
        return true;
    }

    @Override
    public FixedItemInv getUpgradesInventory(class_1799 is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public FixedItemInv getConfigInventory(class_1799 is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(class_1799 is) {
        String fz = is.method_7948().method_10558("FuzzyMode");
        if (fz.isEmpty()) {
            return FuzzyMode.IGNORE_ALL;
        }
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(class_1799 is, FuzzyMode fzMode) {
        is.method_7948().method_10582("FuzzyMode", fzMode.name());
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        this.disassembleDrive(player.method_5998(hand), world, player);
        return new class_1271(class_1269.field_5812, (Object)player.method_5998(hand));
    }

    private boolean disassembleDrive(class_1799 stack, class_1937 world, class_1657 player) {
        if (player.method_18276()) {
            if (Platform.isClient()) {
                return false;
            }
            class_1661 playerInventory = player.field_7514;
            ICellInventoryHandler inv = Api.instance().registries().cell().getCellInventory(stack, null, this.getChannel());
            if (inv != null && playerInventory.method_7391() == stack) {
                InventoryAdaptor ia = InventoryAdaptor.getAdaptor(player);
                IItemList list = inv.getAvailableItems(this.getChannel().createList());
                if (list.isEmpty() && ia != null) {
                    playerInventory.method_5447(playerInventory.field_7545, class_1799.field_8037);
                    class_1799 extraB = ia.addItems(this.component.stack(1));
                    if (!extraB.method_7960()) {
                        player.method_7328(extraB, false);
                    }
                    FixedItemInv upgradesInventory = this.getUpgradesInventory(stack);
                    for (int upgradeIndex = 0; upgradeIndex < upgradesInventory.getSlotCount(); ++upgradeIndex) {
                        class_1799 upgradeStack = upgradesInventory.getInvStack(upgradeIndex);
                        class_1799 leftStack = ia.addItems(upgradeStack);
                        if (leftStack.method_7960() || !(upgradeStack.method_7909() instanceof IUpgradeModule)) continue;
                        player.method_7328(upgradeStack, false);
                    }
                    this.dropEmptyStorageCellCase(ia, player);
                    if (player.field_7512 != null) {
                        player.field_7512.method_7623();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected abstract void dropEmptyStorageCellCase(InventoryAdaptor var1, class_1657 var2);

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        return this.disassembleDrive(stack, context.method_8045(), context.method_8036()) ? class_1269.field_5812 : class_1269.field_5811;
    }
}

