/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.util.AEColor;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class MemoryCardItem
extends AEBaseItem
implements AEToolItem,
IMemoryCard {
    private static final AEColor[] DEFAULT_COLOR_CODE = new AEColor[]{AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT};

    public MemoryCardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 advancedTooltips) {
        String firstLineKey = this.getFirstValidTranslationKey(this.getSettingsName(stack) + ".name", this.getSettingsName(stack));
        lines.add((class_2561)new class_2588(firstLineKey));
        class_2487 data = this.getData(stack);
        if (data.method_10545("tooltip")) {
            String tooltipKey = this.getFirstValidTranslationKey(data.method_10558("tooltip") + ".name", data.method_10558("tooltip"));
            lines.add((class_2561)new class_2588(tooltipKey));
        }
        if (data.method_10545("freq")) {
            short freq = data.method_10568("freq");
            String freqTooltip = class_124.field_1067 + Platform.p2p().toHexString(freq);
            lines.add((class_2561)new class_2588("gui.tooltips.appliedenergistics2.P2PFrequency", new Object[]{freqTooltip}));
        }
    }

    private String getFirstValidTranslationKey(String ... name) {
        for (String n3 : name) {
            if (!class_2477.method_10517().method_4678(n3)) continue;
            return n3;
        }
        int n = 0;
        String[] stringArray = name;
        int n2 = stringArray.length;
        if (n < n2) {
            String n3;
            n3 = stringArray[n];
            return n3;
        }
        return "";
    }

    @Override
    public void setMemoryCardContents(class_1799 is, String settingsName, class_2487 data) {
        class_2487 c = is.method_7948();
        c.method_10582("Config", settingsName);
        c.method_10566("Data", (class_2520)data);
    }

    @Override
    public String getSettingsName(class_1799 is) {
        class_2487 c = is.method_7948();
        String name = c.method_10558("Config");
        return name.isEmpty() ? GuiText.Blank.getTranslationKey() : name;
    }

    @Override
    public class_2487 getData(class_1799 is) {
        class_2487 c = is.method_7948();
        class_2487 o = c.method_10562("Data");
        return o.method_10553();
    }

    @Override
    public AEColor[] getColorCode(class_1799 is) {
        class_2487 tag = this.getData(is);
        if (tag.method_10545("colorCode")) {
            int[] frequency = tag.method_10561("colorCode");
            AEColor[] colorArray = AEColor.values();
            return new AEColor[]{colorArray[frequency[0]], colorArray[frequency[1]], colorArray[frequency[2]], colorArray[frequency[3]], colorArray[frequency[4]], colorArray[frequency[5]], colorArray[frequency[6]], colorArray[frequency[7]]};
        }
        return DEFAULT_COLOR_CODE;
    }

    @Override
    public void notifyUser(class_1657 player, MemoryCardMessages msg) {
        if (Platform.isClient()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.method_9203(PlayerMessages.SettingCleared.get(), class_156.field_25140);
                break;
            }
            case INVALID_MACHINE: {
                player.method_9203(PlayerMessages.InvalidMachine.get(), class_156.field_25140);
                break;
            }
            case SETTINGS_LOADED: {
                player.method_9203(PlayerMessages.LoadedSettings.get(), class_156.field_25140);
                break;
            }
            case SETTINGS_SAVED: {
                player.method_9203(PlayerMessages.SavedSettings.get(), class_156.field_25140);
                break;
            }
            case SETTINGS_RESET: {
                player.method_9203(PlayerMessages.ResetSettings.get(), class_156.field_25140);
                break;
            }
        }
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        if (context.method_8036().method_18276()) {
            class_2680 state;
            class_1269 useResult;
            if (!context.method_8036().field_6002.field_9236 && !(useResult = (state = context.method_8045().method_8320(context.method_8037())).method_26174(context.method_8045(), context.method_8036(), context.method_20287(), new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), context.method_17699()))).method_23665()) {
                this.clearCard(context.method_8036(), context.method_8045(), context.method_20287());
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 w, class_1657 player, class_1268 hand) {
        if (player.method_18276() && !w.field_9236) {
            this.clearCard(player, w, hand);
        }
        return super.method_7836(w, player, hand);
    }

    private void clearCard(class_1657 player, class_1937 w, class_1268 hand) {
        IMemoryCard mem = (IMemoryCard)player.method_5998(hand).method_7909();
        mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
        player.method_5998(hand).method_7980(null);
    }
}

