/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.block.networking.CableBusBlock;
import appeng.block.paint.PaintSplotchesBlock;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.IBlockTool;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.misc.PaintBallItem;
import appeng.items.tools.powered.BlockRecolorer;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.helpers.BaseActionSource;
import appeng.tile.misc.PaintSplotchesBlockEntity;
import appeng.util.FakePlayer;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1823;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_3494;

public class ColorApplicatorItem
extends AEBasePoweredItem
implements IStorageCell<IAEItemStack>,
IBlockTool,
IMouseWheelItem {
    private static final Map<class_2960, AEColor> TAG_TO_COLOR = ImmutableMap.builder().put((Object)new class_2960("c:black_dyes"), (Object)AEColor.BLACK).put((Object)new class_2960("c:blue_dyes"), (Object)AEColor.BLUE).put((Object)new class_2960("c:brown_dyes"), (Object)AEColor.BROWN).put((Object)new class_2960("c:cyan_dyes"), (Object)AEColor.CYAN).put((Object)new class_2960("c:gray_dyes"), (Object)AEColor.GRAY).put((Object)new class_2960("c:green_dyes"), (Object)AEColor.GREEN).put((Object)new class_2960("c:light_blue_dyes"), (Object)AEColor.LIGHT_BLUE).put((Object)new class_2960("c:light_gray_dyes"), (Object)AEColor.LIGHT_GRAY).put((Object)new class_2960("c:lime_dyes"), (Object)AEColor.LIME).put((Object)new class_2960("c:magenta_dyes"), (Object)AEColor.MAGENTA).put((Object)new class_2960("c:orange_dyes"), (Object)AEColor.ORANGE).put((Object)new class_2960("c:pink_dyes"), (Object)AEColor.PINK).put((Object)new class_2960("c:purple_dyes"), (Object)AEColor.PURPLE).put((Object)new class_2960("c:red_dyes"), (Object)AEColor.RED).put((Object)new class_2960("c:white_dyes"), (Object)AEColor.WHITE).put((Object)new class_2960("c:yellow_dyes"), (Object)AEColor.YELLOW).build();
    private static final String TAG_COLOR = "color";

    public ColorApplicatorItem(class_1792.class_1793 props) {
        super(AEConfig.instance().getColorApplicatorBattery(), props);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 w = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1799 is = context.method_8041();
        class_2350 side = context.method_8038();
        Object p = context.method_8036();
        if (p == null && w instanceof class_3218) {
            p = FakePlayer.getOrCreate((class_3218)w);
        }
        class_2248 blk = w.method_8320(pos).method_26204();
        class_1799 paintBall = this.getColor(is);
        ICellInventoryHandler<IAEItemStack> inv = Api.instance().registries().cell().getCellInventory(is, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        if (inv != null) {
            AEColor color;
            IAEItemStack option = inv.extractItems(AEItemStack.fromItemStack(paintBall), Actionable.SIMULATE, new BaseActionSource());
            if (option != null) {
                paintBall = option.createItemStack();
                paintBall.method_7939(1);
            } else {
                paintBall = class_1799.field_8037;
            }
            if (p != null && !Platform.hasPermissions(new DimensionalCoord(w, pos), p)) {
                return class_1269.field_5814;
            }
            double powerPerUse = 100.0;
            if (!paintBall.method_7960() && paintBall.method_7909() instanceof class_1823) {
                class_2586 te = w.method_8321(pos);
                if (te instanceof IColorableTile && p != null && this.getAECurrentPower(is) > 100.0 && ((IColorableTile)te).getColor() != AEColor.TRANSPARENT && ((IColorableTile)te).recolourBlock(side, AEColor.TRANSPARENT, (class_1657)p)) {
                    inv.extractItems(AEItemStack.fromItemStack(paintBall), Actionable.MODULATE, new BaseActionSource());
                    this.extractAEPower(is, 100.0, Actionable.MODULATE);
                    return class_1269.field_5812;
                }
                class_2248 testBlk = w.method_8320(pos.method_10093(side)).method_26204();
                class_2586 painted = w.method_8321(pos.method_10093(side));
                if (this.getAECurrentPower(is) > 100.0 && testBlk instanceof PaintSplotchesBlock && painted instanceof PaintSplotchesBlockEntity) {
                    inv.extractItems(AEItemStack.fromItemStack(paintBall), Actionable.MODULATE, new BaseActionSource());
                    this.extractAEPower(is, 100.0, Actionable.MODULATE);
                    ((PaintSplotchesBlockEntity)painted).cleanSide(side.method_10153());
                    return class_1269.field_5812;
                }
            } else if (!paintBall.method_7960() && (color = this.getColorFromItem(paintBall)) != null && this.getAECurrentPower(is) > 100.0 && color != AEColor.TRANSPARENT && this.recolourBlock(blk, side, w, pos, color, (class_1657)p)) {
                inv.extractItems(AEItemStack.fromItemStack(paintBall), Actionable.MODULATE, new BaseActionSource());
                this.extractAEPower(is, 100.0, Actionable.MODULATE);
                return class_1269.field_5812;
            }
        }
        if (p != null && p.method_18276()) {
            this.cycleColors(is, paintBall, 1);
        }
        return class_1269.field_5814;
    }

    public class_2561 method_7864(class_1799 is) {
        class_2561 extra = GuiText.Empty.text();
        AEColor selected = this.getActiveColor(is);
        if (selected != null && Platform.isClient()) {
            extra = new class_2588(selected.translationKey);
        }
        return super.method_7864(is).method_27662().method_27693(" - ").method_10852(extra);
    }

    public AEColor getActiveColor(class_1799 tol) {
        return this.getColorFromItem(this.getColor(tol));
    }

    private AEColor getColorFromItem(class_1799 paintBall) {
        if (paintBall.method_7960()) {
            return null;
        }
        if (paintBall.method_7909() instanceof class_1823) {
            return AEColor.TRANSPARENT;
        }
        if (paintBall.method_7909() instanceof PaintBallItem) {
            PaintBallItem ipb = (PaintBallItem)paintBall.method_7909();
            return ipb.getColor();
        }
        for (Map.Entry<class_2960, AEColor> entry : TAG_TO_COLOR.entrySet()) {
            class_3494 tag = class_3489.method_15106().method_30210(entry.getKey());
            if (tag == null || !paintBall.method_7909().method_7855(tag)) continue;
            return entry.getValue();
        }
        return null;
    }

    public class_1799 getColor(class_1799 is) {
        class_2487 color;
        class_1799 oldColor;
        class_2487 c = is.method_7969();
        if (c != null && c.method_10545(TAG_COLOR) && !(oldColor = class_1799.method_7915((class_2487)(color = c.method_10562(TAG_COLOR)))).method_7960()) {
            return oldColor;
        }
        return this.findNextColor(is, class_1799.field_8037, 0);
    }

    private class_1799 findNextColor(class_1799 is, class_1799 anchor, int scrollOffset) {
        class_1799 newColor = class_1799.field_8037;
        ICellInventoryHandler<IAEItemStack> inv = Api.instance().registries().cell().getCellInventory(is, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        if (inv != null) {
            IItemList itemList = inv.getAvailableItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList());
            if (anchor.method_7960()) {
                IAEItemStack firstItem = (IAEItemStack)itemList.getFirstItem();
                if (firstItem != null) {
                    newColor = firstItem.asItemStackRepresentation();
                }
            } else {
                LinkedList<IAEItemStack> list = new LinkedList<IAEItemStack>();
                for (IAEItemStack i : itemList) {
                    list.add(i);
                }
                if (list.isEmpty()) {
                    return class_1799.field_8037;
                }
                list.sort(Comparator.comparingInt(a -> {
                    AEColor color = this.getColorFromItem(a.getDefinition());
                    return color != null ? color.ordinal() : Integer.MAX_VALUE;
                }));
                IAEItemStack where = (IAEItemStack)list.getFirst();
                AEColor anchorColor = this.getColorFromItem(anchor);
                for (int cycles = 1 + list.size(); cycles > 0 && this.getColorFromItem(where.getDefinition()) != anchorColor; --cycles) {
                    list.addLast((IAEItemStack)list.removeFirst());
                    where = (IAEItemStack)list.getFirst();
                }
                if (scrollOffset > 0) {
                    list.addLast((IAEItemStack)list.removeFirst());
                }
                if (scrollOffset < 0) {
                    list.addFirst((IAEItemStack)list.removeLast());
                }
                return ((IAEItemStack)list.get(0)).asItemStackRepresentation();
            }
        }
        if (!newColor.method_7960()) {
            this.setColor(is, newColor);
        }
        return newColor;
    }

    private void setColor(class_1799 is, class_1799 newColor) {
        class_2487 data = is.method_7948();
        if (newColor.method_7960()) {
            data.method_10551(TAG_COLOR);
        } else {
            class_2487 color = new class_2487();
            newColor.method_7953(color);
            data.method_10566(TAG_COLOR, (class_2520)color);
        }
    }

    private boolean recolourBlock(class_2248 blk, class_2350 side, class_1937 w, class_2338 pos, AEColor newColor, @Nullable class_1657 p) {
        class_2680 state = w.method_8320(pos);
        class_2248 recolored = BlockRecolorer.recolor(blk, newColor);
        if (recolored != blk) {
            class_2680 newState = recolored.method_9564();
            for (class_2769 prop : newState.method_28501()) {
                newState = ColorApplicatorItem.copyProp(state, newState, prop);
            }
            return w.method_8501(pos, newState);
        }
        if (blk instanceof CableBusBlock && p != null) {
            return ((CableBusBlock)blk).recolorBlock((class_1922)w, pos, side, newColor.dye, p);
        }
        class_2586 be = w.method_8321(pos);
        if (be instanceof IColorableTile) {
            IColorableTile ct = (IColorableTile)be;
            AEColor c = ct.getColor();
            if (c != newColor) {
                ct.recolourBlock(side, newColor, p);
                return true;
            }
            return false;
        }
        return false;
    }

    private static <T extends Comparable<T>> class_2680 copyProp(class_2680 oldState, class_2680 newState, class_2769<T> prop) {
        if (newState.method_28498(prop)) {
            return (class_2680)newState.method_11657(prop, oldState.method_11654(prop));
        }
        return newState;
    }

    public void cycleColors(class_1799 is, class_1799 paintBall, int i) {
        if (paintBall.method_7960()) {
            this.setColor(is, this.getColor(is));
        } else {
            this.setColor(is, this.findNextColor(is, paintBall, i));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 advancedTooltips) {
        super.method_7851(stack, world, lines, advancedTooltips);
        ICellInventoryHandler<IAEItemStack> cdi = Api.instance().registries().cell().getCellInventory(stack, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        Api.instance().client().addCellInformation(cdi, lines);
    }

    @Override
    public int getBytes(class_1799 cellItem) {
        return 512;
    }

    @Override
    public int getBytesPerType(class_1799 cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(class_1799 cellItem) {
        return 27;
    }

    @Override
    public boolean isBlackListed(class_1799 cellItem, IAEItemStack requestedAddition) {
        if (requestedAddition != null) {
            return this.getColorFromItem(requestedAddition.getDefinition()) == null;
        }
        return true;
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(class_1799 i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public boolean isEditable(class_1799 is) {
        return true;
    }

    @Override
    public FixedItemInv getUpgradesInventory(class_1799 is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public FixedItemInv getConfigInventory(class_1799 is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(class_1799 is) {
        String fz = is.method_7948().method_10558("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(class_1799 is, FuzzyMode fzMode) {
        is.method_7948().method_10582("FuzzyMode", fzMode.name());
    }

    @Override
    public void onWheel(class_1799 is, boolean up) {
        this.cycleColors(is, this.getColor(is), up ? 1 : -1);
    }

    @Override
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }
}

