/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.util.DimensionalCoord;
import appeng.block.misc.TinyTNTBlock;
import appeng.container.ContainerNull;
import appeng.core.AEConfig;
import appeng.hooks.IBlockTool;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.mixins.TntAccessor;
import appeng.util.FakePlayer;
import appeng.util.InWorldToolOperationResult;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2530;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class EntropyManipulatorItem
extends AEBasePoweredItem
implements IBlockTool {
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> heatUp = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> coolDown = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();

    public EntropyManipulatorItem(class_1792.class_1793 props) {
        super(AEConfig.instance().getEntropyManipulatorBattery(), props);
        this.coolDown.put(new InWorldToolOperationIngredient(class_2246.field_10340), new InWorldToolOperationResult(class_2246.field_10445.method_9564()));
        this.coolDown.put(new InWorldToolOperationIngredient(class_2246.field_10056), new InWorldToolOperationResult(class_2246.field_10416.method_9564()));
        this.coolDown.put(new InWorldToolOperationIngredient(class_2246.field_10164, (class_3611)class_3612.field_15908), new InWorldToolOperationResult(class_2246.field_10540.method_9564()));
        this.coolDown.put(new InWorldToolOperationIngredient(class_2246.field_10164, (class_3611)class_3612.field_15907), new InWorldToolOperationResult(class_2246.field_10540.method_9564()));
        this.coolDown.put(new InWorldToolOperationIngredient(class_2246.field_10219), new InWorldToolOperationResult(class_2246.field_10566.method_9564()));
        ArrayList<class_1799> snowBalls = new ArrayList<class_1799>();
        snowBalls.add(new class_1799((class_1935)class_1802.field_8543));
        this.coolDown.put(new InWorldToolOperationIngredient(class_2246.field_10382, (class_3611)class_3612.field_15909), new InWorldToolOperationResult(null, snowBalls));
        this.coolDown.put(new InWorldToolOperationIngredient(class_2246.field_10382, (class_3611)class_3612.field_15910), new InWorldToolOperationResult(class_2246.field_10295.method_9564()));
        this.heatUp.put(new InWorldToolOperationIngredient(class_2246.field_10295), new InWorldToolOperationResult(class_2246.field_10382.method_9564()));
        this.heatUp.put(new InWorldToolOperationIngredient(class_2246.field_10382, (class_3611)class_3612.field_15910), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient(class_2246.field_10382, (class_3611)class_3612.field_15909), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient(class_2246.field_10477), new InWorldToolOperationResult((class_2680)class_2246.field_10382.method_9564().method_11657((class_2769)class_2741.field_12538, (Comparable)Integer.valueOf(7)), (class_3611)class_3612.field_15909));
    }

    private void heat(class_2248 block, class_3611 fluid, class_1937 w, class_2338 pos) {
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(block, fluid));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(block, class_3612.field_15906));
        }
        if (r.getBlockState() != null) {
            w.method_8652(pos, r.getBlockState(), 3);
        } else {
            w.method_8652(pos, class_3612.field_15906.method_15785().method_15759(), 3);
        }
        if (r.getDrops() != null) {
            Platform.spawnDrops(w, pos, r.getDrops());
        }
        if (!w.field_9236) {
            w.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (w.field_9229.nextFloat() - w.field_9229.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                w.method_8406((class_2394)class_2398.field_11237, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random(), (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean canHeat(class_2248 block, class_3611 fluid) {
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(block, fluid));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(block, class_3612.field_15906));
        }
        return r != null;
    }

    private void cool(class_2248 block, class_3611 fluid, class_1937 w, class_2338 pos) {
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(block, fluid));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(block, class_3612.field_15906));
        }
        if (r.getBlockState() != null) {
            w.method_8652(pos, r.getBlockState(), 3);
        } else {
            w.method_8650(pos, false);
        }
        if (r.getDrops() != null) {
            Platform.spawnDrops(w, pos, r.getDrops());
        }
    }

    private boolean canCool(class_2248 block, class_3611 fluid) {
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(block, fluid));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(block, class_3612.field_15906));
        }
        return r != null;
    }

    public boolean method_7873(class_1799 item, class_1309 target, class_1309 hitter) {
        if (this.getAECurrentPower(item) > 1600.0) {
            this.extractAEPower(item, 1600.0, Actionable.MODULATE);
            target.method_20803(8);
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 w, class_1657 p, class_1268 hand) {
        class_2338 pos;
        class_2680 state;
        class_3965 target = EntropyManipulatorItem.method_7872((class_1937)w, (class_1657)p, (class_3959.class_242)class_3959.class_242.field_1347);
        if (target.method_17783() != class_239.class_240.field_1332 && ((state = w.method_8320(pos = target.method_17777())).method_26207() == class_3614.field_15922 || state.method_26207() == class_3614.field_15920) && Platform.hasPermissions(new DimensionalCoord(w, pos), p)) {
            class_1838 context = new class_1838(p, hand, target);
            this.method_7884(context);
        }
        return new class_1271(class_1269.field_5812, (Object)p.method_5998(hand));
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 w = context.method_8045();
        class_1799 item = context.method_8041();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        Object p = context.method_8036();
        boolean tryBoth = false;
        if (p == null) {
            if (w.field_9236) {
                return class_1269.field_5814;
            }
            p = FakePlayer.getOrCreate((class_3218)w);
            tryBoth = true;
        }
        if (this.getAECurrentPower(item) > 1600.0) {
            if (!p.method_7343(pos, side, item)) {
                return class_1269.field_5814;
            }
            class_2248 block = w.method_8320(pos).method_26204();
            class_3611 fluid = w.method_8316(pos).method_15772();
            if ((tryBoth || p.method_18276()) && this.canCool(block, fluid)) {
                this.extractAEPower(item, 1600.0, Actionable.MODULATE);
                this.cool(block, fluid, w, pos);
                return class_1269.field_5812;
            }
            if (tryBoth || !p.method_18276()) {
                if (block instanceof class_2530) {
                    TntAccessor.callPrimeTnt(w, pos, (class_1309)p);
                    w.method_8650(pos, false);
                    return class_1269.field_5812;
                }
                if (block instanceof TinyTNTBlock) {
                    w.method_8650(pos, false);
                    ((TinyTNTBlock)block).startFuse(w, pos, (class_1309)p);
                    return class_1269.field_5812;
                }
                if (this.canHeat(block, fluid)) {
                    this.extractAEPower(item, 1600.0, Actionable.MODULATE);
                    this.heat(block, fluid, w, pos);
                    return class_1269.field_5812;
                }
                class_1799[] stack = Platform.getBlockDrops(w, pos);
                ArrayList<class_1799> out = new ArrayList<class_1799>();
                boolean hasFurnaceable = false;
                boolean canFurnaceable = true;
                for (class_1799 i : stack) {
                    class_1715 tempInv = new class_1715((class_1703)new ContainerNull(), 1, 1);
                    tempInv.method_5447(0, i);
                    Optional recipe = w.method_8433().method_8132(class_3956.field_17546, (class_1263)tempInv, w);
                    if (recipe.isPresent()) {
                        class_1799 result = ((class_3861)recipe.get()).method_8116((class_1263)tempInv);
                        if (result.method_7909() instanceof class_1747 && class_2248.method_9503((class_1792)result.method_7909()) == block) {
                            canFurnaceable = false;
                        }
                        hasFurnaceable = true;
                        out.add(result);
                        continue;
                    }
                    canFurnaceable = false;
                    out.add(i);
                }
                if (hasFurnaceable && canFurnaceable) {
                    this.extractAEPower(item, 1600.0, Actionable.MODULATE);
                    InWorldToolOperationResult or = InWorldToolOperationResult.getBlockOperationResult(out.toArray(new class_1799[0]));
                    w.method_8465(p, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_15145, class_3419.field_15248, 1.0f, field_8005.nextFloat() * 0.4f + 0.8f);
                    if (or.getBlockState() == null) {
                        w.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                    } else {
                        w.method_8652(pos, or.getBlockState(), 3);
                    }
                    if (or.getDrops() != null) {
                        Platform.spawnDrops(w, pos, or.getDrops());
                    }
                    return class_1269.field_5812;
                }
                class_2338 offsetPos = pos.method_10093(side);
                if (!p.method_7343(offsetPos, side, item)) {
                    return class_1269.field_5814;
                }
                if (w.method_22347(offsetPos)) {
                    this.extractAEPower(item, 1600.0, Actionable.MODULATE);
                    w.method_8465(p, (double)offsetPos.method_10263() + 0.5, (double)offsetPos.method_10264() + 0.5, (double)offsetPos.method_10260() + 0.5, class_3417.field_15145, class_3419.field_15248, 1.0f, field_8005.nextFloat() * 0.4f + 0.8f);
                    w.method_8501(offsetPos, class_2246.field_10036.method_9564());
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    private static class InWorldToolOperationIngredient {
        private final class_2248 block;
        private final class_3611 fluid;

        public InWorldToolOperationIngredient(class_2248 block) {
            this(block, class_3612.field_15906);
        }

        public InWorldToolOperationIngredient(class_2248 block, class_3611 fluid) {
            this.block = block;
            this.fluid = fluid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InWorldToolOperationIngredient that = (InWorldToolOperationIngredient)o;
            return this.block.equals(that.block) && this.fluid.equals(that.fluid);
        }

        public int hashCode() {
            return Objects.hash(this.block, this.fluid);
        }
    }
}

