/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Upgrades;
import appeng.api.features.AEFeature;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.MatterCannonPacket;
import appeng.hooks.TickHandler;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.misc.PaintBallItem;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.helpers.PlayerSource;
import appeng.tile.misc.PaintSplotchesBlockEntity;
import appeng.util.LookDirection;
import appeng.util.Platform;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1472;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class MatterCannonItem
extends AEBasePoweredItem
implements IStorageCell<IAEItemStack> {
    private static final int ENERGY_PER_SHOT = 1600;

    public MatterCannonItem(class_1792.class_1793 props) {
        super(AEConfig.instance().getMatterCannonBattery(), props);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 advancedTooltips) {
        super.method_7851(stack, world, lines, advancedTooltips);
        ICellInventoryHandler<IAEItemStack> cdi = Api.instance().registries().cell().getCellInventory(stack, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        Api.instance().client().addCellInformation(cdi, lines);
    }

    public class_1271<class_1799> method_7836(class_1937 w, class_1657 p, @Nullable class_1268 hand) {
        if (this.getAECurrentPower(p.method_5998(hand)) > 1600.0) {
            ICellInventoryHandler<IAEItemStack> inv;
            int shots = 1;
            CellUpgrades cu = (CellUpgrades)this.getUpgradesInventory(p.method_5998(hand));
            if (cu != null) {
                shots += cu.getInstalledUpgrades(Upgrades.SPEED);
            }
            if ((inv = Api.instance().registries().cell().getCellInventory(p.method_5998(hand), null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class))) != null) {
                IItemList itemList = inv.getAvailableItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList());
                IAEItemStack req = (IAEItemStack)itemList.getFirstItem();
                if (req instanceof IAEItemStack) {
                    shots = Math.min(shots, (int)req.getStackSize());
                    for (int sh = 0; sh < shots; ++sh) {
                        IAEItemStack aeAmmo = req.copy();
                        this.extractAEPower(p.method_5998(hand), 1600.0, Actionable.MODULATE);
                        if (Platform.isClient()) {
                            return new class_1271(class_1269.field_5812, (Object)p.method_5998(hand));
                        }
                        aeAmmo.setStackSize(1L);
                        class_1799 ammo = aeAmmo.createItemStack();
                        if (ammo.method_7960()) {
                            return new class_1271(class_1269.field_5812, (Object)p.method_5998(hand));
                        }
                        if ((aeAmmo = inv.extractItems(aeAmmo, Actionable.MODULATE, new PlayerSource(p, null))) == null) {
                            return new class_1271(class_1269.field_5812, (Object)p.method_5998(hand));
                        }
                        LookDirection dir = Platform.getPlayerRay(p, 32.0);
                        class_243 rayFrom = dir.getA();
                        class_243 rayTo = dir.getB();
                        class_243 direction = rayTo.method_1020(rayFrom);
                        direction.method_1029();
                        double d0 = rayFrom.field_1352;
                        double d1 = rayFrom.field_1351;
                        double d2 = rayFrom.field_1350;
                        float penetration = Api.instance().registries().matterCannon().getPenetration(ammo);
                        if (penetration <= 0.0f) {
                            class_1799 type = aeAmmo.asItemStackRepresentation();
                            if (type.method_7909() instanceof PaintBallItem) {
                                this.shootPaintBalls(type, w, p, rayFrom, rayTo, direction, d0, d1, d2);
                            }
                            return new class_1271(class_1269.field_5812, (Object)p.method_5998(hand));
                        }
                        this.standardAmmo(penetration, w, p, rayFrom, rayTo, direction, d0, d1, d2);
                    }
                } else {
                    if (Platform.isServer()) {
                        p.method_9203(PlayerMessages.AmmoDepleted.get(), class_156.field_25140);
                    }
                    return new class_1271(class_1269.field_5812, (Object)p.method_5998(hand));
                }
            }
        }
        return new class_1271(class_1269.field_5814, (Object)p.method_5998(hand));
    }

    private void shootPaintBalls(class_1799 type, class_1937 w, class_1657 p, class_243 Vec3d, class_243 Vec3d1, class_243 direction, double d0, double d1, double d2) {
        class_238 bb = new class_238(Math.min(Vec3d.field_1352, Vec3d1.field_1352), Math.min(Vec3d.field_1351, Vec3d1.field_1351), Math.min(Vec3d.field_1350, Vec3d1.field_1350), Math.max(Vec3d.field_1352, Vec3d1.field_1352), Math.max(Vec3d.field_1351, Vec3d1.field_1351), Math.max(Vec3d.field_1350, Vec3d1.field_1350)).method_1009(16.0, 16.0, 16.0);
        class_1297 entity = null;
        class_243 entityIntersection = null;
        List list = w.method_8333((class_1297)p, bb, e -> !(e instanceof class_1542) && e.method_5805());
        double closest = 9999999.0;
        for (class_1297 entity1 : list) {
            double nd;
            if (p.method_5765() && entity1.method_5626((class_1297)p)) continue;
            float f1 = 0.3f;
            class_238 boundingBox = entity1.method_5829().method_1009((double)0.3f, (double)0.3f, (double)0.3f);
            class_243 intersection = boundingBox.method_992(Vec3d, Vec3d1).orElse(null);
            if (intersection == null || !((nd = Vec3d.method_1025(intersection)) < closest)) continue;
            entity = entity1;
            entityIntersection = intersection;
            closest = nd;
        }
        class_3959 rayTraceContext = new class_3959(Vec3d, Vec3d1, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)p);
        class_3965 pos = w.method_17742(rayTraceContext);
        class_243 vec = new class_243(d0, d1, d2);
        if (entity != null && pos.method_17783() != class_239.class_240.field_1333 && pos.method_17784().method_1025(vec) > closest) {
            pos = new class_3966(entity, entityIntersection);
        } else if (entity != null && pos.method_17783() == class_239.class_240.field_1333) {
            pos = new class_3966(entity, entityIntersection);
        }
        try {
            AppEng.instance().sendToAllNearExcept(null, d0, d1, d2, 128.0, w, new MatterCannonPacket(d0, d1, d2, (float)direction.field_1352, (float)direction.field_1351, (float)direction.field_1350, (byte)(pos.method_17783() == class_239.class_240.field_1333 ? 32.0 : pos.method_17784().method_1025(vec) + 1.0)));
        }
        catch (Exception err) {
            AELog.debug(err);
        }
        if (pos.method_17783() != class_239.class_240.field_1333 && type != null && type.method_7909() instanceof PaintBallItem) {
            PaintBallItem ipb = (PaintBallItem)type.method_7909();
            AEColor col = ipb.getColor();
            if (pos instanceof class_3966) {
                class_3966 entityResult = (class_3966)pos;
                class_1297 entityHit = entityResult.method_17782();
                int id = entityHit.method_5628();
                TickHandler.PlayerColor marker = new TickHandler.PlayerColor(id, col, 600);
                TickHandler.instance().getPlayerColors().put(id, marker);
                if (entityHit instanceof class_1472) {
                    class_1472 sh = (class_1472)entityHit;
                    sh.method_6631(col.dye);
                }
                entityHit.method_5643(class_1282.method_5532((class_1657)p), 0.0f);
                NetworkHandler.instance().sendToAll(marker.getPacket());
            } else if (pos instanceof class_3965) {
                class_2586 te;
                class_3965 blockResult = pos;
                class_2350 side = blockResult.method_17780();
                class_2338 hitPos = blockResult.method_17777().method_10093(side);
                if (!Platform.hasPermissions(new DimensionalCoord(w, hitPos), p)) {
                    return;
                }
                class_2680 whatsThere = w.method_8320(hitPos);
                if (whatsThere.method_26207().method_15800() && w.method_22347(hitPos)) {
                    Api.instance().definitions().blocks().paint().maybeBlock().ifPresent(paintBlock -> w.method_8652(hitPos, paintBlock.method_9564(), 3));
                }
                if ((te = w.method_8321(hitPos)) instanceof PaintSplotchesBlockEntity) {
                    class_243 hp = pos.method_17784().method_1023((double)hitPos.method_10263(), (double)hitPos.method_10264(), (double)hitPos.method_10260());
                    ((PaintSplotchesBlockEntity)te).addBlot(type, side.method_10153(), hp);
                }
            }
        }
    }

    private void standardAmmo(float penetration, class_1937 w, class_1657 p, class_243 Vec3d, class_243 Vec3d1, class_243 direction, double d0, double d1, double d2) {
        boolean hasDestroyed = true;
        while (penetration > 0.0f && hasDestroyed) {
            hasDestroyed = false;
            class_238 bb = new class_238(Math.min(Vec3d.field_1352, Vec3d1.field_1352), Math.min(Vec3d.field_1351, Vec3d1.field_1351), Math.min(Vec3d.field_1350, Vec3d1.field_1350), Math.max(Vec3d.field_1352, Vec3d1.field_1352), Math.max(Vec3d.field_1351, Vec3d1.field_1351), Math.max(Vec3d.field_1350, Vec3d1.field_1350)).method_1009(16.0, 16.0, 16.0);
            class_1297 entity = null;
            class_243 entityIntersection = null;
            List list = w.method_8333((class_1297)p, bb, e -> !(e instanceof class_1542) && e.method_5805());
            double closest = 9999999.0;
            for (class_1297 entity1 : list) {
                double nd;
                if (p.method_5765() && entity1.method_5626((class_1297)p)) continue;
                float f1 = 0.3f;
                class_238 boundingBox = entity1.method_5829().method_1009((double)0.3f, (double)0.3f, (double)0.3f);
                class_243 intersection = boundingBox.method_992(Vec3d, Vec3d1).orElse(null);
                if (intersection == null || !((nd = Vec3d.method_1025(intersection)) < closest)) continue;
                entity = entity1;
                entityIntersection = intersection;
                closest = nd;
            }
            class_3959 rayTraceContext = new class_3959(Vec3d, Vec3d1, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)p);
            class_243 vec = new class_243(d0, d1, d2);
            class_3965 pos = w.method_17742(rayTraceContext);
            if (entity != null && pos.method_17783() != class_239.class_240.field_1333 && pos.method_17784().method_1025(vec) > closest) {
                pos = new class_3966(entity, entityIntersection);
            } else if (entity != null && pos.method_17783() == class_239.class_240.field_1333) {
                pos = new class_3966(entity, entityIntersection);
            }
            try {
                AppEng.instance().sendToAllNearExcept(null, d0, d1, d2, 128.0, w, new MatterCannonPacket(d0, d1, d2, (float)direction.field_1352, (float)direction.field_1351, (float)direction.field_1350, (byte)(pos.method_17783() == class_239.class_240.field_1333 ? 32.0 : pos.method_17784().method_1025(vec) + 1.0)));
            }
            catch (Exception err) {
                AELog.debug(err);
            }
            if (pos.method_17783() == class_239.class_240.field_1333) continue;
            class_1285 dmgSrc = new class_1285("matter_cannon", (class_1297)p);
            if (pos instanceof class_3966) {
                class_3966 entityResult = (class_3966)pos;
                class_1297 entityHit = entityResult.method_17782();
                int dmg = (int)Math.ceil(penetration / 20.0f);
                if (entityHit instanceof class_1309) {
                    class_1309 el = (class_1309)entityHit;
                    penetration -= (float)dmg;
                    el.method_6005(0.0f, -direction.field_1352, -direction.field_1350);
                    el.method_5643((class_1282)dmgSrc, (float)dmg);
                    if (el.method_5805()) continue;
                    hasDestroyed = true;
                    continue;
                }
                if (entityHit instanceof class_1542) {
                    hasDestroyed = true;
                    entityHit.method_5650();
                    continue;
                }
                if (!entityHit.method_5643((class_1282)dmgSrc, (float)dmg)) continue;
                hasDestroyed = true;
                continue;
            }
            if (!(pos instanceof class_3965)) continue;
            class_3965 blockResult = pos;
            if (!AEConfig.instance().isFeatureEnabled(AEFeature.MASS_CANNON_BLOCK_DAMAGE)) {
                penetration = 0.0f;
                continue;
            }
            class_2338 blockPos = blockResult.method_17777();
            class_2680 bs = w.method_8320(blockPos);
            float hardness = bs.method_26214((class_1922)w, blockPos) * 9.0f;
            if (!((double)hardness >= 0.0) || !(penetration > hardness) || !Platform.hasPermissions(new DimensionalCoord(w, blockPos), p)) continue;
            hasDestroyed = true;
            penetration -= hardness;
            penetration = (float)((double)penetration * 0.6);
            w.method_22352(blockPos, true);
        }
    }

    @Override
    public boolean isEditable(class_1799 is) {
        return true;
    }

    @Override
    public FixedItemInv getUpgradesInventory(class_1799 is) {
        return new CellUpgrades(is, 4);
    }

    @Override
    public FixedItemInv getConfigInventory(class_1799 is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(class_1799 is) {
        String fz = is.method_7948().method_10558("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(class_1799 is, FuzzyMode fzMode) {
        is.method_7948().method_10582("FuzzyMode", fzMode.name());
    }

    @Override
    public int getBytes(class_1799 cellItem) {
        return 512;
    }

    @Override
    public int getBytesPerType(class_1799 cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(class_1799 cellItem) {
        return 1;
    }

    @Override
    public boolean isBlackListed(class_1799 cellItem, IAEItemStack requestedAddition) {
        float pen = Api.instance().registries().matterCannon().getPenetration(requestedAddition.createItemStack());
        if (pen > 0.0f) {
            return false;
        }
        return !(requestedAddition.getItem() instanceof PaintBallItem);
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(class_1799 i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }
}

